/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.porttypes;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.dir.master.ServiceInputAdapter;
import org.gcube.dir.master.contexts.MasterContext;
import org.gcube.dir.master.contexts.Registry;
import org.gcube.dir.master.contexts.ServiceContext;
import org.gcube.dir.master.fusion.io.FusionParameters;
import org.gcube.dir.master.fusion.mergers.Merger;
import org.gcube.dir.master.porttypes.BasePortType;
import org.gcube.dir.master.selection.io.CollectionRank;
import org.gcube.dir.master.selection.io.SelectionParameters;
import org.gcube.dir.master.selection.rankers.Ranker;
import org.gcube.dir.master.state.CollectionSet;
import org.gcube.dir.master.stubs.ICollectionRank;
import org.gcube.dir.master.stubs.ICollectionRanking;

public class Master
extends BasePortType {
    public StringArray getCollectionIDs(VOID params) throws GCUBEFault {
        try {
            List<String> ids = this.getCollectionSet().getCollectionIDs();
            return new StringArray(ids.toArray(new String[0]));
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public VOID addCollection(String id) throws GCUBEFault {
        String errMsg = "Could not add collection";
        try {
            ServiceContext.getContext().useCallerCredentials(new Thread[0]);
            CollectionSet set = this.getCollectionSet();
            set.addCollections(id);
            set.store();
            return new VOID();
        }
        catch (GCUBEException e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw e.toFault(new String[]{errMsg});
        }
        catch (Exception e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(errMsg, e).toFault(new String[0]);
        }
    }

    public ICollectionRanking select(ServiceInputAdapter<? extends SelectionParameters> params) throws GCUBEFault {
        String errMsg = "could not select over collections";
        try {
            List<Ranker> rankers;
            CollectionSet set = this.getCollectionSet();
            if (set.getSize() == 0) {
                return new ICollectionRanking(new ICollectionRank[0]);
            }
            SelectionParameters parameters = params.intern();
            try {
                rankers = Registry.findProcessor(Ranker.class, parameters);
            }
            catch (Registry.ProcessorNotFoundException e) {
                throw new GCUBERetryEquivalentException("no ranker available to process this instance of " + parameters.getClass().getSimpleName());
            }
            for (Ranker ranker : rankers) {
                try {
                    this.logger.info((Object)("trying to rank collections with a " + ranker.getClass().getSimpleName()));
                    List<CollectionRank> ranking = parameters.getCriterion().select(ranker.rank(parameters, set));
                    ArrayList<ICollectionRank> stubRanking = new ArrayList<ICollectionRank>();
                    for (CollectionRank rank : ranking) {
                        stubRanking.add(rank.extern());
                    }
                    return new ICollectionRanking(stubRanking.toArray(new ICollectionRank[0]));
                }
                catch (Exception tolerate) {
                    this.logger.error((Object)("Ranker " + ranker.getClass() + " has failed"), (Throwable)tolerate);
                }
            }
            throw new GCUBERetryEquivalentException("all rankers have failed");
        }
        catch (GCUBEException e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw e.toFault(new String[]{errMsg});
        }
        catch (Exception e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(errMsg, e).toFault(new String[0]);
        }
    }

    public String merge(ServiceInputAdapter<? extends FusionParameters> params) throws GCUBEFault {
        String errMsg = "Could not merge results";
        try {
            FusionParameters parameters = params.intern();
            CollectionSet set = this.getCollectionSet();
            List<String> ids = set.getCollectionIDs();
            for (String id : parameters.getResultSets().keySet()) {
                if (ids.contains(id)) continue;
                throw new GCUBEUnrecoverableException("collection " + id + " is unknown");
            }
            List<Merger> mergers = null;
            try {
                mergers = Registry.findProcessor(Merger.class, parameters);
            }
            catch (Exception e) {
                throw new GCUBERetryEquivalentException("no merger available to process this instance of " + parameters.getClass().getSimpleName());
            }
            Exception lastException = null;
            for (Merger merger : mergers) {
                try {
                    this.logger.info((Object)("Trying to merge results with a " + merger.getClass().getSimpleName()));
                    return merger.merge(parameters, set).getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
                }
                catch (Exception e) {
                    lastException = e;
                    this.logger.warn((Object)("Merger " + merger.getClass() + " has failed"), (Throwable)e);
                }
            }
            throw new GCUBERetryEquivalentException("All rankers have failed. Last observed exception was..", lastException);
        }
        catch (GCUBEException e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw e.toFault(new String[]{errMsg});
        }
        catch (Exception e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(errMsg, e).toFault(new String[0]);
        }
    }

    protected CollectionSet getCollectionSet() throws Exception {
        return (CollectionSet)MasterContext.getContext().getWSHome().find();
    }
}

