/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.porttypes;

import java.net.URL;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.types.VOID;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBReader;
import org.gcube.dir.master.contexts.MasterContext;
import org.gcube.dir.master.contexts.PluginManager;
import org.gcube.dir.master.contexts.ServiceContext;
import org.gcube.dir.master.porttypes.BasePortType;
import org.gcube.dir.master.state.CollectionSet;
import org.gcube.dir.master.stubs.FactoryParams;
import org.gcube.dir.master.stubs.Plugin;

public class Factory
extends BasePortType {
    public EndpointReferenceType createMaster(FactoryParams params) throws GCUBEFault {
        String errMsg = "Could not create Master";
        try {
            if (params == null) {
                throw new GCUBEUnrecoverableException((Throwable)new IllegalArgumentException("Creation parameters are missing"));
            }
            ServiceContext.getContext().useCallerCredentials(new Thread[0]);
            CollectionSet set = (CollectionSet)MasterContext.getContext().getWSHome().create(new Object[]{params});
            set.store();
            return set.getEPR();
        }
        catch (GCUBEException e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw e.toFault(new String[]{errMsg});
        }
        catch (Exception e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(errMsg, e).toFault(new String[0]);
        }
    }

    public VOID deployPlugin(Plugin params) throws GCUBEFault {
        String errMsg = "Could not deploy plugin";
        try {
            if (params == null || params.getUrl() == null) {
                throw new GCUBEUnrecoverableException((Throwable)new IllegalArgumentException("No parameters provided"));
            }
            PluginManager.deploy(new URL(params.getUrl()).openStream());
            return new VOID();
        }
        catch (GCUBEException e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw e.toFault(new String[]{errMsg});
        }
        catch (Throwable e) {
            this.logger.error((Object)errMsg, e);
            throw ServiceContext.getContext().getDefaultException(errMsg, e).toFault(new String[0]);
        }
    }

    public VOID deployPluginRS(String resultSetEPR) throws GCUBEFault {
        String errMsg = "Could not deploy plugin using ResultSet";
        try {
            if (resultSetEPR == null) {
                throw new GCUBEUnrecoverableException((Throwable)new IllegalArgumentException("No epr provided"));
            }
            RSBLOBIterator iterator = RSBLOBReader.getRSBLOBReader((RSLocator)new RSLocator(resultSetEPR)).makeLocal((RSResourceType)new RSResourceLocalType()).getRSIterator();
            ResultElementBLOBGeneric blob = null;
            while (blob == null && iterator.hasNext()) {
                blob = (ResultElementBLOBGeneric)iterator.next(ResultElementBLOBGeneric.class);
            }
            if (blob == null) {
                throw new Exception("Invalid resultset for plugin");
            }
            PluginManager.deploy(blob.getContentOfBLOB());
            return new VOID();
        }
        catch (GCUBEException e) {
            this.logger.error((Object)errMsg, (Throwable)e);
            throw e.toFault(new String[]{errMsg});
        }
        catch (Throwable e) {
            this.logger.error((Object)errMsg, e);
            throw ServiceContext.getContext().getDefaultException(errMsg, e).toFault(new String[0]);
        }
    }
}

