/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.index;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dir.master.index.DefaultTerm;
import org.gcube.dir.master.index.DefaultTermStats;
import org.gcube.dir.master.index.IndexCreationParameters;
import org.gcube.dir.master.index.IndexManager;
import org.gcube.dir.master.index.JDBCManagerParams;

public class JDBCManager
implements IndexManager<DefaultTerm, DefaultTermStats> {
    protected static final GCUBELog logger = new GCUBELog(JDBCManager.class);
    private static final String CREATESQLINDEX_STMT = "CREATE INDEX I_INDEX ON INDEX (term, sourceURI)";
    private static final String CREATETABLE_STMT = "CREATE CACHED TABLE INDEX (term VARCHAR(50), sourceURI VARCHAR(256), ctf INTEGER, cdf INTEGER)";
    private static final String DELETE_TERMS_STMT = "DELETE FROM INDEX WHERE sourceURI = ?";
    private static final String GET_TERMS_STMT = "SELECT * FROM INDEX WHERE sourceURI = ?";
    private static final String INSERT_TERMS_STMT = "INSERT INTO INDEX (term, sourceURI, ctf, cdf) VALUES (?,?,?,?)";
    private PreparedStatement addTermStatement;
    private PreparedStatement getTermsStatement;
    private PreparedStatement removeTermsStatement;
    Connection conn;

    @Override
    public void createIndex(IndexCreationParameters params) throws Exception {
        JDBCManagerParams JDBCParams;
        try {
            JDBCParams = (JDBCManagerParams)params;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(params.getClass() + " is not a valid type of creation parameters for this index");
        }
        Class.forName(JDBCParams.getDriverClassName());
        String connectionString = "jdbc:" + JDBCParams.getSignature() + ":" + GHNContext.getContext().getStorageRoot() + File.separatorChar + JDBCParams.getIndexName();
        this.conn = DriverManager.getConnection(connectionString, JDBCParams.getUserName(), JDBCParams.getPwd());
        ResultSet rs = this.conn.getMetaData().getTables(null, null, "INDEX", null);
        if (!rs.next()) {
            Statement st = this.conn.createStatement();
            st.executeUpdate(CREATETABLE_STMT);
            st.executeUpdate(CREATESQLINDEX_STMT);
            st.close();
        }
        this.addTermStatement = this.conn.prepareStatement(INSERT_TERMS_STMT);
        this.getTermsStatement = this.conn.prepareStatement(GET_TERMS_STMT);
        this.removeTermsStatement = this.conn.prepareStatement(DELETE_TERMS_STMT);
    }

    @Override
    public void addTerm(String collectionID, DefaultTerm term) throws Exception {
        this.addTermStatement.setString(1, term.getName().replaceAll("'", ""));
        this.addTermStatement.setString(2, collectionID);
        this.addTermStatement.setInt(3, term.getStats().getFrequency());
        this.addTermStatement.setInt(4, term.getStats().getDocFrequency());
        this.addTermStatement.execute();
    }

    @Override
    public List<DefaultTerm> getTerms(String collectionID) throws Exception {
        this.getTermsStatement.setString(1, collectionID.toString());
        ResultSet rs = this.getTermsStatement.executeQuery();
        ArrayList<DefaultTerm> terms = new ArrayList<DefaultTerm>();
        while (rs.next()) {
            String termName = rs.getString(1);
            int ctf = rs.getInt(3);
            int cdf = rs.getInt(4);
            DefaultTerm term = new DefaultTerm();
            term.setName(termName);
            DefaultTermStats stats = new DefaultTermStats();
            stats.setFrequency(ctf);
            stats.setDocFrequency(cdf);
            term.setStats(stats);
            terms.add(term);
        }
        return terms;
    }

    @Override
    public void removeTerms(String collectionID) throws Exception {
        this.removeTermsStatement.setString(1, collectionID);
        this.removeTermsStatement.executeUpdate();
    }

    @Override
    public Map<String, DefaultTermStats> getPostings(String termName, Collection<String> collectionIDs) throws Exception {
        StringBuilder getPostingsStmt = new StringBuilder("SELECT sourceURI,ctf,cdf FROM INDEX WHERE UPPER(term) = '" + termName.toUpperCase() + "'");
        getPostingsStmt.append(" AND sourceURI IN ( '' ");
        for (String u : collectionIDs) {
            getPostingsStmt.append(",'" + u.toString() + "'");
        }
        getPostingsStmt.append(")");
        Statement st = this.conn.createStatement();
        ResultSet rs = st.executeQuery(getPostingsStmt.toString());
        HashMap<String, DefaultTermStats> postings = new HashMap<String, DefaultTermStats>();
        while (rs.next()) {
            DefaultTermStats stats = new DefaultTermStats();
            stats.setFrequency(rs.getInt(2));
            stats.setDocFrequency(rs.getInt(3));
            postings.put(rs.getString(1), stats);
        }
        st.close();
        return postings;
    }

    @Override
    public void deleteIndex() throws Exception {
        Statement st = this.conn.createStatement();
        st.execute("SHUTDOWN");
        this.conn.close();
    }
}

