/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.fusion.mergers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEIHandler;
import org.gcube.common.core.utils.handlers.GCUBEParallelHandler;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.dir.master.Prototyped;
import org.gcube.dir.master.contexts.MasterContext;
import org.gcube.dir.master.fusion.io.FusionParameters;
import org.gcube.dir.master.fusion.mergers.Merger;
import org.gcube.dir.master.fusion.results.BaseResult;
import org.gcube.dir.master.fusion.results.RankedResult;

public abstract class RankingMerger<PARAMS extends FusionParameters>
extends Merger<PARAMS>
implements Prototyped<FusionParameters> {
    private static final String RESULT_CLASS_JNDI_NAME = "resultClass";
    protected static Class<? extends RankedResult> resultClass;
    private long rankTime = 0L;

    @Override
    public RSXMLWriter merge() throws Exception {
        final List<RankedResult> rankedResults = Collections.synchronizedList(new ArrayList());
        GCUBEParallelHandler master = new GCUBEParallelHandler(GCUBEParallelHandler.Mode.LAX);
        for (RSXMLReader reader : ((FusionParameters)this.getParams()).getResultSets().values()) {
            final RSXMLIterator iterator = reader.getRSIterator();
            master.addHandlers(new GCUBEIHandler[]{new GCUBEHandler<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws Exception {
                    int count = 0;
                    while (iterator.hasNext() && count < ((FusionParameters)RankingMerger.this.getParams()).getNumberOfResults()) {
                        RankedResult r = (RankedResult)iterator.next(RankingMerger.this.getResultClass());
                        Calendar before = Calendar.getInstance();
                        if (r == null) continue;
                        RankingMerger.this.rank(r);
                        rankedResults.add(r);
                        ++count;
                        Calendar now = Calendar.getInstance();
                        RankingMerger rankingMerger = RankingMerger.this;
                        synchronized (rankingMerger) {
                            long diff = now.getTimeInMillis() - before.getTimeInMillis();
                            RankingMerger.this.rankTime = RankingMerger.this.rankTime + diff;
                        }
                        Calendar calendar = now;
                    }
                }
            }});
        }
        Calendar startTime = Calendar.getInstance();
        master.run();
        this.postProcess(rankedResults);
        Collections.sort(rankedResults);
        List<RankedResult> results = rankedResults.subList(0, Math.abs(Math.min(((FusionParameters)this.getParams()).getNumberOfResults(), rankedResults.size())));
        RSXMLWriter mergedSet = RSXMLWriter.getRSXMLWriter();
        mergedSet.addResults(results.toArray(new ResultElementBase[0]));
        mergedSet.close();
        long totalTime = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis();
        this.logger.debug((Object)("Merge took " + totalTime + " msec, " + (totalTime - this.rankTime) + " of which were spent moving data."));
        return mergedSet;
    }

    protected abstract void rank(RankedResult var1) throws Exception;

    public Class<?> getResultClass() {
        if (resultClass == null) {
            String resultClassName = (String)MasterContext.getContext().getProperty(RESULT_CLASS_JNDI_NAME, new boolean[]{false});
            if (resultClassName == null) {
                resultClass = RankedResult.class;
            } else {
                try {
                    resultClass = Class.forName(resultClassName);
                    if (!BaseResult.class.isAssignableFrom(resultClass)) {
                        throw new RuntimeException("Result class does not extend " + RankedResult.class.getName());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return resultClass;
    }

    protected void postProcess(List<RankedResult> rankedResults) throws Exception {
    }

    @Override
    public FusionParameters getPrototype() {
        return new FusionParameters(null, null, 0);
    }
}

