/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.fusion.mergers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.dir.master.contexts.ServiceContext;
import org.gcube.dir.master.fusion.io.FusionParameters;
import org.gcube.dir.master.fusion.mergers.RankingMerger;
import org.gcube.dir.master.fusion.results.FullResult;
import org.gcube.dir.master.fusion.results.RankedResult;
import org.gcube.dir.master.index.DefaultTerm;
import org.gcube.dir.master.index.DefaultTermStats;
import org.gcube.dir.master.index.IndexManager;

public class ConsistentMerger<PARAMS extends FusionParameters>
extends RankingMerger<PARAMS> {
    private Map<String, TermStats> termStatMap = new HashMap<String, TermStats>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rank(RankedResult result) throws Exception {
        FullResult r = (FullResult)result;
        float score = 0.0f;
        ConsistentMerger consistentMerger = this;
        synchronized (consistentMerger) {
            for (DefaultTerm term : r.getTerms()) {
                String termName = term.getName().toLowerCase();
                TermStats globalTermStats = this.termStatMap.get(termName);
                if (globalTermStats == null) {
                    globalTermStats = new TermStats();
                    IndexManager<?, ?> manager = ServiceContext.getContext().getIndexManager();
                    int df = 0;
                    for (DefaultTermStats tStats : manager.getPostings(termName, this.set.getCollectionIDs()).values()) {
                        df += tStats.getDocFrequency();
                    }
                    this.logger.trace((Object)("DF for " + termName + ":" + df));
                    globalTermStats.idf = df == 0 ? 0.0f : (float)Math.log((float)this.set.getDocumentSize() / (float)df);
                    this.logger.trace((Object)("IDF for " + termName + ":" + globalTermStats.idf));
                    this.termStatMap.put(termName, globalTermStats);
                }
                float tf = (float)term.getStats().getFrequency() / (float)r.getLength();
                score += tf * globalTermStats.idf;
                if (!(tf > globalTermStats.maxtf)) continue;
                globalTermStats.maxtf = tf;
            }
            this.logger.trace((Object)("result score " + score));
            r.setScore(score);
        }
    }

    @Override
    protected void postProcess(List<RankedResult> rankedResults) throws Exception {
        float idealScore = 0.0f;
        for (TermStats stats : this.termStatMap.values()) {
            idealScore += stats.maxtf * stats.idf;
        }
        this.logger.trace((Object)("Scaling wrt ideal score " + idealScore));
        for (RankedResult r : rankedResults) {
            r.setScore(r.getScore() / idealScore);
        }
    }

    protected class TermStats {
        float idf;
        float maxtf;

        protected TermStats() {
        }
    }
}

