/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.contexts;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.dir.master.Prototyped;
import org.gcube.dir.master.contexts.PluginManager;
import org.gcube.dir.master.contexts.Registry;
import org.gcube.dir.master.index.IndexCreationParameters;
import org.gcube.dir.master.index.IndexManager;

public class ServiceContext
extends GCUBEServiceContext {
    public static final String JNDI_NAME = "gcube/dir/master";
    private static final String INDEXMANAGER_JNDI_NAME = "indexManager";
    private static final String INDEXMANAGERPARAMS_JNDI_NAME = "indexManagerParams";
    private static final String PROCESSORS_JNDI_NAME = "processors";
    private static final String STAGER_TASK = "stager";
    public static final String SELF_STAGING_PREFIX = "selfstaged";
    protected static ServiceContext cache = new ServiceContext();
    static Map<Class<?>, List<Class<? extends Prototyped<?>>>> map = new HashMap();

    private ServiceContext() {
    }

    public static ServiceContext getContext() {
        return cache;
    }

    public String getJNDIName() {
        return JNDI_NAME;
    }

    public IndexManager<?, ?> getIndexManager() {
        return (IndexManager)this.getProperty(INDEXMANAGER_JNDI_NAME, new boolean[]{true});
    }

    protected void onInitialisation() throws Exception {
        String[] processorClassNames;
        IndexCreationParameters params = (IndexCreationParameters)this.getProperty(INDEXMANAGERPARAMS_JNDI_NAME, new boolean[]{true});
        this.getIndexManager().createIndex(params);
        this.logger.info((Object)("Using full-text index @ " + params.getIndexName() + " with a " + this.getIndexManager().getClass().getSimpleName()));
        for (String processorClassName : processorClassNames = ((String)this.getProperty(PROCESSORS_JNDI_NAME, new boolean[]{true})).split(",")) {
            Registry.registerProcessor(Class.forName(processorClassName));
        }
        this.loadPlugins();
    }

    protected void loadPlugins() {
        FilenameFilter jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.substring(fileName.lastIndexOf(".") + 1).equals("jar");
            }
        };
        File pluginFolder = this.getPersistentFile("plugins", new boolean[0]);
        if (pluginFolder.exists()) {
            for (File file : pluginFolder.listFiles(jarFilter)) {
                try {
                    PluginManager.activate(file.toURL());
                }
                catch (Exception tolerate) {
                    this.logger.warn((Object)("Plugin in " + file.getName() + " could not be activated"), (Throwable)tolerate);
                }
            }
        }
    }
}

