/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.contexts;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dir.master.Prototyped;

public class Registry {
    private static GCUBELog logger = new GCUBELog(Registry.class);
    static Map<Class<?>, List<Class<? extends Prototyped<?>>>> map = new HashMap();

    public static synchronized void registerProcessor(Class<? extends Prototyped<?>> processorClass) throws Exception {
        Class<?> prototypeClass = processorClass.newInstance().getPrototype().getClass();
        List<Class<Prototyped<?>>> processorClasses = map.get(prototypeClass);
        if (processorClasses == null) {
            processorClasses = new ArrayList();
            map.put(prototypeClass, processorClasses);
        }
        if (!processorClasses.contains(processorClass)) {
            processorClasses.add(processorClass);
            logger.trace((Object)("Registered processor " + processorClass.getSimpleName()));
        } else {
            logger.trace((Object)("Processor " + processorClass.getSimpleName() + " is already registered"));
        }
    }

    public static synchronized <PROCESSOR> List<PROCESSOR> findProcessor(Class<PROCESSOR> processorClass, Object input) throws ProcessorNotFoundException, Exception {
        ArrayList processors = new ArrayList();
        for (Class<Object> registeredInputClass : Registry.typeOrder(map.keySet(), input)) {
            List<Class<Prototyped<?>>> registeredProcessorClasses = map.get(registeredInputClass);
            if (registeredProcessorClasses == null) continue;
            for (Class<Prototyped<?>> clazz : registeredProcessorClasses) {
                Prototyped<?> processor;
                if (!processorClass.isAssignableFrom(clazz) || !Registry.dynamicTypeCheck((processor = clazz.newInstance()).getPrototype(), input)) continue;
                processors.add(clazz.newInstance());
            }
        }
        if (processors.size() == 0) {
            throw new ProcessorNotFoundException();
        }
        return processors;
    }

    private static <T> List<Class<? super T>> typeOrder(Collection<Class<?>> classes, T input) {
        ArrayList<Class<T>> ordered = new ArrayList<Class<T>>();
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(input.getClass())) continue;
            ordered.add(clazz);
        }
        Collections.sort(ordered, new Comparator<Class<? super T>>(){

            @Override
            public int compare(Class<? super T> class1, Class<? super T> class2) {
                return class2.isAssignableFrom(class1) ? -1 : 1;
            }
        });
        return ordered;
    }

    private static <T> boolean dynamicTypeCheck(T obj1, T obj2) {
        try {
            if (!obj1.getClass().isAssignableFrom(obj2.getClass())) {
                return false;
            }
            List<Field> field2List = Registry.getFields(obj2.getClass());
            for (Field field1 : Registry.getFields(obj1.getClass())) {
                Field field2 = field2List.get(field2List.indexOf(field1));
                Object value1 = field1.get(obj1);
                if (value1 == null || Registry.isPrimitive(value1.getClass())) continue;
                Object value2 = field2.get(obj2);
                if (field1.getType().isArray()) {
                    if (Array.getLength(value1) == 0) {
                        return true;
                    }
                    Object element = Array.get(value1, 0);
                    for (int i = 0; i < Array.getLength(value2); ++i) {
                        if (Registry.dynamicTypeCheck(element, Array.get(value2, i))) continue;
                        return false;
                    }
                }
                if (Iterable.class.isAssignableFrom(field1.getType())) {
                    Iterator iter1 = ((Iterable)value1).iterator();
                    if (!iter1.hasNext()) {
                        return true;
                    }
                    Object element1 = iter1.next();
                    if (Registry.isPrimitive(element1.getClass())) {
                        // empty if block
                    }
                    for (Object element2 : (Iterable)value2) {
                        if (Registry.dynamicTypeCheck(element1, element2)) continue;
                        return false;
                    }
                }
                if (Registry.dynamicTypeCheck(value1, value2)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = clazz.getSuperclass() != null ? Registry.getFields(clazz.getSuperclass()) : new ArrayList();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            fields.add(field);
        }
        return fields;
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return clazz == Short.class || clazz == Byte.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Boolean.class || clazz == String.class;
    }

    public static class ProcessorNotFoundException
    extends Exception {
    }
}

