/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.contexts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import javax.xml.namespace.QName;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dir.master.Prototyped;
import org.gcube.dir.master.contexts.MasterContext;
import org.gcube.dir.master.contexts.Plugin;
import org.gcube.dir.master.contexts.Registry;
import org.gcube.dir.master.contexts.ServiceContext;
import org.globus.wsrf.config.ContainerConfig;

public class PluginManager {
    static GCUBELog logger = new GCUBELog(PluginManager.class);
    public static final String MANIFEST_ENTRYPOINT = "Plugin";
    public static final String PLUGINS_DIRECTORY_NAME = "plugins";

    public static void deploy(InputStream stream) throws Exception {
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        File file = ServiceContext.getContext().getPersistentFile(PLUGINS_DIRECTORY_NAME + File.separatorChar + "plugin-" + UUIDGenFactory.getUUIDGen().nextUUID() + ".jar", new boolean[]{true});
        try {
            int read;
            byte[] buffer = new byte[1024];
            out = new BufferedOutputStream(new FileOutputStream(file));
            in = new BufferedInputStream(stream);
            while ((read = in.read(buffer)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            throw new Exception("could not store plugin", e);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        try {
            Plugin plugin = PluginManager.activate(file.toURL());
            file.renameTo(new File(file.getParentFile(), plugin.getClass() + ".jar"));
        }
        catch (Exception e) {
            if (!file.delete()) {
                logger.warn((Object)("could not delete file " + file + " after failure on plugin activation"));
            }
            throw e;
        }
    }

    public static Plugin activate(URL url) throws Exception {
        URL jarURL = new URL("jar", "", url + "!/");
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarURL}, ((Object)((Object)ServiceContext.getContext())).getClass().getClassLoader());
        String pluginClassName = null;
        Class<?> pluginClass = null;
        try {
            pluginClassName = ((JarURLConnection)jarURL.openConnection()).getMainAttributes().getValue(MANIFEST_ENTRYPOINT);
            pluginClass = classLoader.loadClass(pluginClassName);
        }
        catch (Throwable e) {
            throw new Exception("Plugin in " + url.toExternalForm() + " seems malformed", e);
        }
        Plugin plugin = (Plugin)pluginClass.newInstance();
        logger.info((Object)("Activating plugin " + plugin.getName()));
        for (Prototyped<?> processor : plugin.getProcessors()) {
            try {
                Registry.registerProcessor(processor.getClass());
            }
            catch (Exception e) {
                logger.warn((Object)("Could not register plugin processor " + processor.getClass().getSimpleName()), (Throwable)e);
            }
        }
        WSDDEngineConfiguration engineConfig = (WSDDEngineConfiguration)ContainerConfig.getEngine().getConfig();
        SOAPService service = engineConfig.getDeployment().getService(new QName(MasterContext.getContext().getJNDIName()));
        TypeMappingRegistry registry = service.getTypeMappingRegistry();
        if (registry != null) {
            for (Plugin.TypeMapping m : plugin.getTypeMappings()) {
                try {
                    registry.getTypeMapping("").register(m.clazz, m.qname, m.sFactory, m.dfactory);
                    logger.trace((Object)("Registered type mappings " + m.qname + " <-> " + m.clazz));
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not register plugin type mapping for " + m.qname), (Throwable)e);
                }
            }
        }
        return plugin;
    }
}

