/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2.queries;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.GetMetadata;
import org.gcube.common.dbinterface.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMetadataImpl
implements GetMetadata {
    private static final Logger logger = LoggerFactory.getLogger(GetMetadataImpl.class);
    private String tableName;

    public void setTable(String tableName) {
        this.tableName = tableName.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Type> getResults() throws Exception {
        LinkedHashMap<String, Type> tempMapping;
        DBSession session = DBSession.connect();
        try {
            tempMapping = this.getResults(session);
        }
        finally {
            session.release();
        }
        return tempMapping;
    }

    public LinkedHashMap<String, Type> getResults(DBSession session) throws Exception {
        ResultSet result = session.getDBMetadata().getColumns(null, null, this.tableName, null);
        ArrayList<String> primaryKeyList = new ArrayList<String>(2);
        try {
            ResultSet primaryKeyRS = session.getDBMetadata().getPrimaryKeys(null, null, this.tableName);
            while (primaryKeyRS.next()) {
                primaryKeyList.add(primaryKeyRS.getString("column_name"));
            }
        }
        catch (Exception e) {
            logger.trace("no prymary keys found for " + this.tableName);
        }
        LinkedHashMap<String, Type> tempMapping = new LinkedHashMap<String, Type>();
        while (result.next()) {
            logger.trace("fieldId: " + result.getString("COLUMN_NAME") + "  and the type is " + result.getInt("COLUMN_SIZE") + " " + result.getString("TYPE_NAME") + "  " + result.getInt("NUM_PREC_RADIX") + "   " + result.getInt("DECIMAL_DIGITS"));
            String typeName = result.getString("TYPE_NAME").equals("numeric") && result.getInt("DECIMAL_DIGITS") > 0 ? "decimal" : result.getString("TYPE_NAME");
            Type tmpType = Type.parseType((String)typeName, (int)result.getInt("COLUMN_SIZE"), (int)result.getInt("COLUMN_SIZE"), (int)result.getInt("DECIMAL_DIGITS"));
            try {
                if (result.getString("COLUMN_DEF") != null && result.getString("COLUMN_DEF").contains("nextval")) {
                    tmpType.setAutoincrement(true);
                }
            }
            catch (Exception e) {
                tmpType.setAutoincrement(false);
            }
            if (primaryKeyList.contains(result.getString("COLUMN_NAME"))) {
                tmpType.setPrimaryKey(true);
            }
            tempMapping.put(result.getString("COLUMN_NAME"), tmpType);
        }
        return tempMapping;
    }
}

