/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.SmpFileNameParser;
import org.apache.commons.vfs2.provider.SmpFileSystem;
import org.apache.commons.vfs2.provider.SmpFileSystemConfigBuilder;

public class SmpFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI));

    public SmpFileProvider() {
        this.setFileNameParser(SmpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        return new SmpFileSystem(rootName, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return SmpFileSystemConfigBuilder.getInstance();
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

