/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.statistical_manager_wps_algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.process.ComputationStatus;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.SMAlgorithm;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.output.OutputBuilderUtil;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.SMutils;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.ExceptionReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SMAlgorithmHarvest
extends SMAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(SMAlgorithmHarvest.class);

    public Map<String, IData> run(Map<String, List<IData>> inputData) throws ExceptionReport {
        logger.info("Run: " + inputData);
        this.outputBuilder = new OutputBuilderUtil(this.algorithmId);
        HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
        try {
            List<Parameter> list = this.manageInputParameter(inputData);
            ComputationId computationId = this.executeComputation(list);
            this.monitoringComputation(computationId, wpsResultMap);
            return wpsResultMap;
        }
        catch (ExceptionReport e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionReport("DataMiner operation failed:" + e.getLocalizedMessage(), "SM");
        }
    }

    private void monitoringComputation(ComputationId computationId, Map<String, IData> wpsResultMap) throws Exception {
        logger.debug("monitoringComputation()");
        boolean notEnd = true;
        while (notEnd) {
            ComputationStatus computationStatus = SMutils.getSClient().getComputationStatus(computationId);
            switch (computationStatus.getStatus()) {
                case ACCEPTED: {
                    logger.info("Operation Accepted");
                    break;
                }
                case CANCELLED: {
                    notEnd = false;
                    logger.info("Operation Cancelled");
                    break;
                }
                case COMPLETE: {
                    notEnd = false;
                    logger.debug("Operation Completed");
                    this.retrieveOutput(computationId, wpsResultMap);
                    logger.debug("Output Retrieved");
                    break;
                }
                case FAILED: {
                    notEnd = false;
                    logger.error("Operation Failed");
                    logger.error(computationStatus.getMessage(), (Throwable)computationStatus.getError());
                    Exception e = new Exception("Operation Failed: " + computationStatus.getMessage());
                    throw e;
                }
                case RUNNING: {
                    logger.debug("Operation Running: " + computationStatus.getPercentage());
                    break;
                }
            }
            Thread.sleep(2000L);
        }
    }

    private void retrieveOutput(ComputationId computationId, Map<String, IData> wpsResultMap) throws ExceptionReport {
        try {
            logger.debug("retrieveOutput()");
            GenericFileDataBinding res = this.outputBuilder.getXmlFileDataBinding(SMutils.getOutputResourceByComputationId(computationId));
            wpsResultMap.put("resultList", (IData)res);
        }
        catch (Exception e) {
            logger.error("DataMiner error retrieving output:" + e.getLocalizedMessage(), (Throwable)e);
            throw new ExceptionReport("DataMiner error retrieving output:" + e.getMessage(), "SM");
        }
    }

    public Class<?> getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        return GenericFileDataBinding.class;
    }

    public List<String> getInputIdentifiers() {
        logger.debug("getInputIdentifiers()");
        ArrayList<String> identifierList = new ArrayList<String>();
        try {
            logger.info("Search input identifiers in: " + this.algorithmId);
            SClient sClient = SMutils.getSClient();
            Operator operator = sClient.getOperatorById(this.algorithmId);
            List parameters = sClient.getInputParameters(operator);
            logger.info("Parameters Retrieved: " + parameters);
            for (Parameter p : parameters) {
                this.defaultParameterValue.put(p.getName(), p);
                identifierList.add(p.getName());
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return identifierList;
        }
        logger.info("Input IdentifierList: " + identifierList);
        return identifierList;
    }

    public List<String> getOutputIdentifiers() {
        logger.debug("getOutputIdentifiers()");
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("resultList");
        logger.info("Output Identifiers: " + identifierList);
        return identifierList;
    }
}

