/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.statistical_manager_wps_algorithms.class_generator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.SMutils;

public class ClassesGenerator {
    private String scope;
    private String classPackagePath = "src/main/java/org/gcube/dataanalysis/statistical_manager_wps_algorithms/generated";
    private final String packageLocationPath = "/home/angela/workspaceEcl/statistical-manager-wps-algorithms/" + this.classPackagePath;

    public ClassesGenerator(String scope) {
        this.scope = scope;
    }

    public void engine() {
        System.out.print(this.packageLocationPath);
        if (this.scope == null) {
            this.scope = "/gcube/devsec";
        }
        ArrayList<String> algorithms = SMutils.getAlgorithmsId(this.scope);
        for (String algorithm : algorithms) {
            this.writeClass(algorithm);
        }
    }

    private String formatName(String algName) {
        String firstPart = algName.substring(0, 1).toUpperCase() + algName.substring(1, algName.length() - 1).toLowerCase();
        return firstPart.replace(" ", "_");
    }

    public void writeClass(String idAlgorithm) {
        try {
            FileWriter fstream = new FileWriter(this.packageLocationPath + "/" + this.formatName(idAlgorithm) + ".java");
            BufferedWriter output = new BufferedWriter(fstream);
            String className = this.formatName(idAlgorithm);
            output.write("package org.gcube.dataanalysis.statistical_manager_wps_algorithms.generated;");
            output.newLine();
            output.write(this.writeImport());
            output.newLine();
            output.write("public class " + className + " extends SMAlgorithmHarvest  {");
            output.write("public " + this.formatName(idAlgorithm) + " (){");
            output.newLine();
            output.write("super();");
            output.newLine();
            output.write("algorithmId=\"" + idAlgorithm + "\";");
            output.newLine();
            output.write("scope=\"" + this.scope + "\";");
            output.newLine();
            output.write("}");
            output.newLine();
            output.write(this.getOvverideDescriptionIsValid());
            output.newLine();
            output.write(this.getOvverideProcessDescriptionType());
            output.newLine();
            output.write(this.getSelfInitializeDescription());
            output.newLine();
            output.write("}");
            output.close();
            fstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getOvverideDescriptionIsValid() {
        String method = "@Override public boolean processDescriptionIsValid() {return true;}";
        return method;
    }

    public String getOvverideProcessDescriptionType() {
        String method = "@Override protected ProcessDescriptionType initializeDescription() {return SelfInitializeDescription();}";
        return method;
    }

    public String getSelfInitializeDescription() {
        String method = "\tprotected ProcessDescriptionType SelfInitializeDescription() {\t\tProcessDescriptionsDocument document = ProcessDescriptionsDocument.Factory.newInstance();\t ProcessDescriptions processDescriptions = document.addNewProcessDescriptions();\t ProcessDescriptionType processDescription = processDescriptions.addNewProcessDescription();\t\t processDescription.setStatusSupported(true);\t processDescription.setStoreSupported(true);\t\t processDescription.setProcessVersion(\"1.0.0\");\tprocessDescription.addNewIdentifier().setStringValue(this.getClass().getName());\tprocessDescription.addNewTitle().setStringValue(this.algorithmId);\tString descr = SMutils.getAlgorithmDescription(this.algorithmId,this.scope);\tSystem.out.println(\" Description:\" + descr);\tif (descr != null)\tprocessDescription.addNewAbstract().setStringValue(descr);\tList<String> identifiers = this.getInputIdentifiers();\tDataInputs dataInputs = null;\tif (identifiers.size() > 0) {\tdataInputs = processDescription.addNewDataInputs();\t}\tfor (String identifier : identifiers) {\tSystem.out.println(\" identifie\" + identifier);\tParameter parameter = defaultParameterValue.get(identifier);\tInputDescriptionType dataInput = dataInputs.addNewInput();\tif (defaultParameterValue.containsKey(identifier)) {\tString title = parameter.getDescription() + \"; \";\tdataInput.addNewTitle().setStringValue(title);\tString possibleValue = \"Suggested Value: \"\t+ parameter.getDefaultValue() + \" \"; \tint i = 0;\tfor (String s : parameter.getPossibleValues()) {\tif (i == 0)\tpossibleValue = possibleValue + \"Possible Values : \";\tif (i != parameter.getPossibleValues().size() - 1)\tpossibleValue = possibleValue + s + \"; \";\telse\tpossibleValue = possibleValue + s;\ti++;\t}\tdataInput.addNewAbstract().setStringValue(possibleValue);\t}\tdataInput.setMinOccurs(getMinOccurs(identifier));\tdataInput.setMaxOccurs(getMaxOccurs(identifier));\tdataInput.addNewIdentifier().setStringValue(identifier);\tLiteralInputType literalData = dataInput.addNewLiteralData();\tint j = 0;\tAllowedValues values = null;\tfor (String s : parameter.getPossibleValues()) {\tif (j == 0)\tvalues = literalData.addNewAllowedValues();\tvalues.addNewValue().setStringValue(s);\tj++;\t}\tif (j == 0)\tliteralData.addNewAnyValue();\tString inputClassType = \"\";\tClass<?> inputDataTypeClass;\tif (parameter.getType() != null)\tinputDataTypeClass = parameter.getType();\telse\tinputDataTypeClass = this.getInputDataType(identifier);\tConstructor<?>[] constructors = inputDataTypeClass.getConstructors();\tfor (Constructor<?> constructor : constructors) {\tClass<?>[] parameters = constructor.getParameterTypes();\tif (parameters.length == 1) {\tinputClassType = parameters[0].getSimpleName();\t}\t}\tif (inputClassType.length() > 0) {\tDomainMetadataType datatype = literalData.addNewDataType();\tdatatype.setReference(\"xs:\" + inputClassType.toLowerCase());\t}\t}\tProcessOutputs dataOutputs = processDescription.addNewProcessOutputs();\tList<String> outputIdentifiers = this.getOutputIdentifiers();\tfor (String identifier : outputIdentifiers) {\tOutputDescriptionType dataOutput = dataOutputs.addNewOutput();\tdataOutput.addNewIdentifier().setStringValue(identifier);\tdataOutput.addNewTitle().setStringValue(identifier);\tdataOutput.addNewAbstract().setStringValue(identifier);\tClass<?> outputDataTypeClass = this.getOutputDataType(identifier);\tClass<?>[] interfaces = outputDataTypeClass.getInterfaces();\tfor (Class<?> implementedInterface : interfaces) {\tif (implementedInterface.equals(ILiteralData.class)) {\tLiteralOutputType literalData = dataOutput.addNewLiteralOutput();\tString outputClassType = \"\";\tConstructor<?>[] constructors = outputDataTypeClass.getConstructors();\tfor (Constructor<?> constructor : constructors) {\tClass<?>[] parameters = constructor.getParameterTypes();\tif (parameters.length == 1) {\toutputClassType = parameters[0].getSimpleName();\t}\t}\tif (outputClassType.length() > 0) {\tliteralData.addNewDataType().setReference(\"xs:\" + outputClassType.toLowerCase());\t}\t} else if (implementedInterface.equals(IBBOXData.class)) {\tSupportedCRSsType bboxData = dataOutput.addNewBoundingBoxOutput();\tString[] supportedCRSAray = getSupportedCRSForBBOXOutput(identifier);\tfor (int i = 0; i < supportedCRSAray.length; i++) {\tif (i == 0) {\tDefault defaultCRS = bboxData.addNewDefault();\tdefaultCRS.setCRS(supportedCRSAray[0]);\tif (supportedCRSAray.length == 1) {\tCRSsType supportedCRS = bboxData.addNewSupported();\tsupportedCRS.addCRS(supportedCRSAray[0]);\t}\t} else {\tif (i == 1) {\tCRSsType supportedCRS = bboxData.addNewSupported();\tsupportedCRS.addCRS(supportedCRSAray[1]);\t} else {\tbboxData.getSupported().addCRS(supportedCRSAray[i]);\t}\t}\t}\t} else if (implementedInterface.equals(IComplexData.class)) {\tSupportedComplexDataType complexData = dataOutput.addNewComplexOutput();\tcomplexData.addNewDefault().addNewFormat().setMimeType(GenericFileDataConstants.MIME_TYPE_PLAIN_TEXT.toString());List<IGenerator> generators = GeneratorFactory.getInstance().getAllGenerators();\tList<IGenerator> foundGenerators = new ArrayList<IGenerator>();\tfor (IGenerator generator : generators) {\tClass<?>[] supportedClasses = generator.getSupportedDataBindings();\tfor (Class<?> clazz : supportedClasses) {\tif (clazz.equals(outputDataTypeClass)) {\tfoundGenerators.add(generator);\t}\t}\t}\t}\t}\t}\tSystem.out.println(document.getProcessDescriptions()\t.getProcessDescriptionArray(0).toString());\treturn document.getProcessDescriptions().getProcessDescriptionArray(0);\t}";
        return method;
    }

    public String writeImport() {
        String importStr = "import java.lang.reflect.Constructor;import java.util.ArrayList;import java.util.List;import net.opengis.ows.x11.DomainMetadataType;import net.opengis.wps.x100.CRSsType;import net.opengis.wps.x100.InputDescriptionType;import net.opengis.wps.x100.LiteralInputType;import net.opengis.wps.x100.LiteralOutputType;import net.opengis.wps.x100.OutputDescriptionType;import net.opengis.wps.x100.ProcessDescriptionType;import net.opengis.wps.x100.SupportedCRSsType;import net.opengis.wps.x100.ProcessDescriptionType.DataInputs;import net.opengis.wps.x100.ProcessDescriptionType.ProcessOutputs;import net.opengis.wps.x100.ProcessDescriptionsDocument;import net.opengis.wps.x100.ProcessDescriptionsDocument.ProcessDescriptions;import net.opengis.wps.x100.SupportedCRSsType.Default;import net.opengis.wps.x100.SupportedComplexDataType;import org.gcube.dataanalysis.statistical_manager_wps_algorithms.SMAlgorithmHarvest;import org.gcube.dataanalysis.statistical_manager_wps_algorithms.parameters.Parameter;import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.SMutils;import org.n52.wps.io.GeneratorFactory;import org.n52.wps.io.IGenerator;import org.n52.wps.io.data.GenericFileDataConstants;import org.n52.wps.io.data.IBBOXData;import org.n52.wps.io.data.IComplexData;import org.n52.wps.io.data.ILiteralData;";
        return importStr;
    }
}

