/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMAbstractResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMComputation;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMFile;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMObject;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMOperationInfo;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.output.OutputManagement;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.output.StringOutputManagement;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.ComputationStatus;

public class SMutils {
    private static StatisticalManagerFactory factory = null;

    public static StatisticalManagerFactory getFactory(String scope) {
        if (ScopeProvider.instance.get() != scope) {
            System.out.println("SCOPE:" + scope);
            ScopeProvider.instance.set(scope.toString());
            factory = (StatisticalManagerFactory)StatisticalManagerDSL.createStateful().withTimeout(5, TimeUnit.MINUTES).build();
            return factory;
        }
        ScopeProvider.instance.set(scope.toString());
        if (factory == null) {
            factory = (StatisticalManagerFactory)StatisticalManagerDSL.createStateful().withTimeout(5, TimeUnit.MINUTES).build();
        }
        return factory;
    }

    public static String getComputationFailledMessage(String computationId) {
        SMComputation computation = factory.getComputation(computationId);
        SMAbstractResource abstractResource = computation.abstractResource();
        SMResource smResource = abstractResource.resource();
        if (smResource.description() != null) {
            return smResource.description();
        }
        return "Process execution fail.";
    }

    public static SMParameters getParameters(String algorithmId, String scope) {
        StatisticalManagerFactory factory = SMutils.getFactory(scope);
        SMParameters smParams = factory.getAlgorithmParameters(algorithmId);
        return smParams;
    }

    public static ArrayList<String> getAlgorithmsId(String scope) {
        StatisticalManagerFactory factory = SMutils.getFactory(scope);
        HashMap<String, String> algs = new HashMap<String, String>();
        SMListGroupedAlgorithms list = factory.getAlgorithms(new SMTypeParameter[0]);
        for (SMGroupedAlgorithms group : list.thelist()) {
            for (SMAlgorithm algorithm : group.thelist()) {
                String alg_id = algorithm.name();
                if (algs.containsKey(alg_id)) continue;
                algs.put(alg_id, alg_id);
            }
        }
        Set set = algs.keySet();
        return new ArrayList<String>(set);
    }

    public static ComputationStatus getComputationStatus(String scope, String computationId, String username) {
        StatisticalManagerFactory factory = SMutils.getFactory(scope);
        SMOperationInfo infos = factory.getComputationInfo(computationId, username);
        SMOperationStatus status = SMOperationStatus.values()[infos.status()];
        switch (status) {
            case COMPLETED: {
                return ComputationStatus.COMPLETE;
            }
            case PENDING: {
                return ComputationStatus.PENDING;
            }
            case FAILED: {
                return ComputationStatus.FAILED;
            }
            case RUNNING: {
                return ComputationStatus.RUNNING;
            }
        }
        return null;
    }

    public static ArrayList<OutputManagement> getResourceById(String jobId, String scope) throws Exception {
        StatisticalManagerFactory factory = SMutils.getFactory(scope);
        SMComputation computation = factory.getComputation(jobId);
        return SMutils.getMapFromMapResource(computation.abstractResource().resource());
    }

    private void convertSMComputationToJobItem(SMComputation computation, boolean loadResourceData) {
        String computationId = "" + computation.operationId();
        String operatorId = computation.algorithm();
        String computationTitle = computation.title();
        String computationDescription = computation.description();
        String categoryId = computation.category();
        Date startDate = computation.submissionDate() == null ? null : computation.submissionDate().getTime();
        Date endDate = computation.completedDate() == null ? null : computation.completedDate().getTime();
        String infrastructure = computation.infrastructure();
        SMAbstractResource abstractResource = computation.abstractResource();
        SMResource smResource = abstractResource.resource();
    }

    public static ArrayList<OutputManagement> managementSmResource(SMResource smResource, String key) throws Exception {
        int resourceTypeIndex = smResource.resourceType();
        ArrayList<OutputManagement> list = new ArrayList<OutputManagement>();
        SMResourceType smResType = SMResourceType.values()[resourceTypeIndex];
        switch (smResType) {
            case FILE: {
                SMFile fileRes = (SMFile)smResource;
                StringOutputManagement file = new StringOutputManagement();
                file.addInput(smResource.resourceId(), fileRes.url());
                list.add(file);
                break;
            }
            case OBJECT: {
                SMObject objRes = (SMObject)smResource;
                if (objRes.name().contentEquals(PrimitiveTypes.MAP.toString())) {
                    list.addAll(SMutils.getMapFromMapResource((SMResource)objRes));
                    break;
                }
                if (objRes.name().contentEquals(PrimitiveTypes.IMAGES.toString())) {
                    StringOutputManagement output = new StringOutputManagement();
                    output.addInput(key, objRes.url());
                    list.add(output);
                    break;
                }
                StringOutputManagement output = new StringOutputManagement();
                output.addInput(key, objRes.url());
                list.add(output);
                break;
            }
            case TABULAR: {
                SMTable tableRes = (SMTable)smResource;
                StringOutputManagement output = new StringOutputManagement();
                output.addInput(tableRes.resourceId(), tableRes.resourceId());
                list.add(output);
            }
        }
        return list;
    }

    public static ArrayList<OutputManagement> getMapFromMapResource(SMResource mapRes) throws Exception {
        ArrayList<OutputManagement> list = new ArrayList<OutputManagement>();
        try {
            String url = ((SMObject)mapRes).url();
            InputStream is = SMutils.getStorageClientInputStream(url);
            XStream xstream = new XStream();
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject", SMObject.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile", SMFile.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource", SMResource.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable", SMTable.class);
            Map smMap = (Map)xstream.fromXML(is);
            LinkedHashMap map = new LinkedHashMap();
            for (String key : smMap.keySet()) {
                SMResource smResource = (SMResource)smMap.get(key);
                list.addAll(SMutils.managementSmResource(smResource, key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static InputStream getStorageClientInputStream(String url) throws Exception {
        URL u = new URL(null, url, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return new SMPURLConnection(u);
            }
        });
        return u.openConnection().getInputStream();
    }

    public static String getAlgorithmDescription(String algId, String scope) {
        StatisticalManagerFactory factory = SMutils.getFactory(scope);
        SMListGroupedAlgorithms groups = factory.getAlgorithms(new SMTypeParameter[0]);
        if (groups == null) {
            System.out.print("GROUPS OF ALGORITHMS IS NULL!");
        } else {
            System.out.print("GROUPS OF ALGORITHMS IS NOT NULL!");
        }
        for (SMGroupedAlgorithms group : groups.thelist()) {
            for (SMAlgorithm algorithm : group.thelist()) {
                if (!algorithm.name().equals(algId)) continue;
                return algorithm.description();
            }
        }
        return null;
    }
}

