/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.statistical_manager_wps_algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMInputEntry;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.SMAlgorithm;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.parameters.ParametersUtil;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.ComputationStatus;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.SMutils;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.ExceptionReport;

public abstract class SMAlgorithmHarvestFirstVersion
extends SMAlgorithm {
    public Map<String, IData> run(Map<String, List<IData>> inputData) throws ExceptionReport {
        HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
        String scope = ((LiteralStringBinding)inputData.get("scope").get(0)).getPayload();
        String username = ((LiteralStringBinding)inputData.get("username").get(0)).getPayload();
        String algorithm = ((LiteralStringBinding)inputData.get("algorithm").get(0)).getPayload();
        String parameterList = ((LiteralStringBinding)inputData.get("parameterList").get(0)).getPayload();
        ScopeProvider.instance.set(scope);
        System.out.println("setted scope :" + ScopeProvider.instance.get());
        StatisticalManagerFactory factory = SMutils.getFactory(scope);
        System.out.println("get parameter");
        SMParameters smParameters = SMutils.getParameters(algorithm, scope);
        System.out.println("get parameter done");
        ArrayList<String> values = ParametersUtil.getListParameters(parameterList);
        SMInputEntry[] list = new SMInputEntry[smParameters.list().size()];
        int i = 0;
        for (SMParameter p : smParameters.list()) {
            System.out.println("add parameter value ");
            System.out.println(p.name() + ": " + values.get(i));
            list[i] = new SMInputEntry(p.name(), values.get(i));
            ++i;
        }
        System.out.println("berfore execute computation");
        String computationId = this.executeComputation(factory, username, algorithm, "wps call of " + algorithm, list, scope);
        System.out.println("after execution: " + computationId);
        ComputationStatus status = ComputationStatus.RUNNING;
        while (status != ComputationStatus.FAILED && status != ComputationStatus.COMPLETE) {
            status = SMutils.getComputationStatus(scope, computationId, username);
            try {
                Thread.sleep(2000L);
                System.out.println("sleep two second");
                status = SMutils.getComputationStatus(scope, computationId, username);
                System.out.println("status :" + status.name());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        LiteralStringBinding res = status.equals((Object)ComputationStatus.COMPLETE) ? new LiteralStringBinding("completed") : new LiteralStringBinding("failed");
        wpsResultMap.put("resultList", (IData)res);
        return wpsResultMap;
    }

    public Class<?> getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public List<String> getInputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("scope");
        identifierList.add("username");
        identifierList.add("algorithm");
        return identifierList;
    }

    public List<String> getOutputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("resultList");
        return identifierList;
    }
}

