/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.statistical_manager_wps_algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMInputEntry;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.StatisticalServiceType;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.SMAlgorithm;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.output.OutputBuilderUtil;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.parameters.Parameter;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.ComputationStatus;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.SMutils;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralBooleanBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralFloatBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.ExceptionReport;

public abstract class SMAlgorithmHarvest
extends SMAlgorithm {
    public Map<String, IData> run(Map<String, List<IData>> inputData) throws ExceptionReport {
        SMInputEntry[] list;
        this.outputBuilder = new OutputBuilderUtil(this.algorithmId);
        HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
        String username = "wps.statisticalmanager";
        ScopeProvider.instance.set(this.scope);
        StatisticalManagerFactory factory = SMutils.getFactory(this.scope);
        try {
            list = this.manageInputParameter(inputData);
        }
        catch (Exception e1) {
            throw new ExceptionReport("Statistical Manager Computation Failed:" + e1.getMessage(), "SM");
        }
        String computationId = this.executeComputation(factory, username, this.algorithmId, "wps call of " + this.algorithmId, list, this.scope);
        ComputationStatus status = ComputationStatus.RUNNING;
        while (status != ComputationStatus.FAILED && status != ComputationStatus.COMPLETE) {
            status = SMutils.getComputationStatus(this.scope, computationId, username);
            try {
                Thread.sleep(2000L);
                System.out.println("sleep two second");
                status = SMutils.getComputationStatus(this.scope, computationId, username);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        GenericFileDataBinding res = null;
        if (status.equals((Object)ComputationStatus.COMPLETE)) {
            try {
                res = this.outputBuilder.getXmlFileDataBinding(SMutils.getResourceById(computationId, this.scope));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ExceptionReport("Statistical Manager Computation Failed:" + e.getMessage(), "SM");
            }
        } else {
            throw new ExceptionReport("Statistical Manager Computation Failed:" + SMutils.getComputationFailledMessage(computationId), "SM");
        }
        wpsResultMap.put("resultList", (IData)res);
        return wpsResultMap;
    }

    public Class<?> getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        return GenericFileDataBinding.class;
    }

    public List<String> getInputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        StatisticalManagerFactory factory = SMutils.getFactory(this.scope);
        SMParameters smParameters = SMutils.getParameters(this.algorithmId, this.scope);
        for (SMParameter p : smParameters.list()) {
            String type;
            SMTypeParameter smType = p.type();
            Class<LiteralIntBinding> primitiveType = null;
            StatisticalServiceType smTypeName = smType.name();
            identifierList.add(p.name());
            ArrayList<String> possibleValues = new ArrayList<String>();
            if (smTypeName.equals((Object)StatisticalServiceType.ENUM)) {
                if (smType.values() != null) {
                    possibleValues = new ArrayList(smType.values());
                }
            } else if (smTypeName.equals((Object)StatisticalServiceType.PRIMITIVE) && (type = (String)smType.values().get(0)) != null) {
                if (type.contentEquals(Boolean.class.getName())) {
                    ArrayList<String> possible = new ArrayList<String>();
                    possible.add("true");
                    possible.add("false");
                    primitiveType = LiteralBooleanBinding.class;
                    possibleValues = possible;
                } else if (type.contentEquals(Integer.class.getName())) {
                    primitiveType = LiteralIntBinding.class;
                } else if (type.contentEquals(String.class.getName())) {
                    primitiveType = LiteralStringBinding.class;
                } else if (type.contentEquals(Double.class.getName())) {
                    primitiveType = LiteralDoubleBinding.class;
                } else if (type.contentEquals(Float.class.getName())) {
                    primitiveType = LiteralFloatBinding.class;
                }
            }
            String paramName = p.name();
            String paramDescription = p.description();
            String defaultValue = p.defaultValue();
            Parameter parameter = new Parameter(paramName, defaultValue, paramDescription, possibleValues, primitiveType);
            this.defaultParameterValue.put(paramName, parameter);
        }
        return identifierList;
    }

    public List<String> getOutputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("resultList");
        return identifierList;
    }
}

