/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.statistical_manager_wps_algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMAbstractResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMEntries;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMFile;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMInputEntry;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMObject;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMTable;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.StatisticalServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.output.OutputBuilderUtil;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.parameters.Parameter;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.SMutils;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralBooleanBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralFloatBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractSelfDescribingAlgorithm;

public abstract class SMAlgorithm
extends AbstractSelfDescribingAlgorithm {
    protected String algorithmId;
    protected String scope;
    protected OutputBuilderUtil outputBuilder;
    protected HashMap<String, Parameter> defaultParameterValue = new HashMap();

    public boolean processDescriptionIsValid() {
        System.out.print("validation*******");
        return true;
    }

    public String executeComputation(StatisticalManagerFactory factory, String username, String computationTitle, String description, SMInputEntry[] list, String scope) {
        ScopeProvider.instance.set(scope);
        SMComputationConfig config = new SMComputationConfig();
        config.parameters(new SMEntries(list));
        config.algorithm(computationTitle);
        SMComputationRequest request = new SMComputationRequest();
        request.user(username);
        request.title(computationTitle);
        request.description(description);
        request.config(config);
        String computationId = factory.executeComputation(request);
        return computationId;
    }

    public ArrayList<String> manageOutput(SMAbstractResource abstractResource) {
        ArrayList<String> output = new ArrayList<String>();
        SMResource smResource = abstractResource.resource();
        int resourceTypeIndex = smResource.resourceType();
        SMResourceType smResType = SMResourceType.values()[resourceTypeIndex];
        switch (smResType) {
            case FILE: {
                SMFile fileRes = (SMFile)smResource;
                break;
            }
            case OBJECT: {
                SMObject objRes = (SMObject)smResource;
                if (!objRes.name().contentEquals(PrimitiveTypes.MAP.toString()) && !objRes.name().contentEquals(PrimitiveTypes.IMAGES.toString())) break;
            }
            case TABULAR: {
                SMTable sMTable = (SMTable)smResource;
            }
        }
        return output;
    }

    public String formatParameterForSM(String id, IData data) throws Exception {
        String parameter = new String();
        Class<?> inputDataTypeClass = data.getClass();
        if (this.defaultParameterValue.containsKey(id)) {
            inputDataTypeClass = this.defaultParameterValue.get(id).getType();
        }
        if (inputDataTypeClass == LiteralBooleanBinding.class) {
            boolean bool = ((LiteralBooleanBinding)data).getPayload();
            parameter = bool ? "true" : "false";
        } else if (inputDataTypeClass == LiteralIntBinding.class) {
            Integer i = ((LiteralIntBinding)data).getPayload();
            parameter = i.toString();
        } else if (inputDataTypeClass == LiteralStringBinding.class) {
            parameter = ((LiteralStringBinding)data).getPayload();
        } else if (inputDataTypeClass == LiteralDoubleBinding.class) {
            Double i = ((LiteralDoubleBinding)data).getPayload();
            parameter = i.toString();
        } else if (inputDataTypeClass == LiteralFloatBinding.class) {
            Float i = ((LiteralFloatBinding)data).getPayload();
            parameter = i.toString();
        }
        System.out.println(parameter);
        return parameter;
    }

    public SMInputEntry[] manageInputParameter(Map<String, List<IData>> inputData) throws Exception {
        SMParameters smParameters = SMutils.getParameters(this.algorithmId, this.scope);
        SMInputEntry[] list = new SMInputEntry[smParameters.list().size()];
        try {
            int i = 0;
            for (SMParameter smParam : smParameters.list()) {
                SMTypeParameter smType = smParam.type();
                StatisticalServiceType smTypeName = smType.name();
                String value = new String();
                if (inputData.get(smParam.name()) != null && inputData.get(smParam.name()).get(0) != null) {
                    if (smTypeName.equals((Object)StatisticalServiceType.TABULAR)) {
                        value = ((LiteralStringBinding)inputData.get(smParam.name()).get(0)).getPayload();
                    } else if (smTypeName.equals((Object)StatisticalServiceType.TABULAR_LIST)) {
                        value = ((LiteralStringBinding)inputData.get(smParam.name()).get(0)).getPayload();
                    } else if (smTypeName.equals((Object)StatisticalServiceType.PRIMITIVE)) {
                        value = this.formatParameterForSM(smParam.name(), inputData.get(smParam.name()).get(0));
                    } else if (smTypeName.equals((Object)StatisticalServiceType.ENUM)) {
                        value = ((LiteralStringBinding)inputData.get(smParam.name()).get(0)).getPayload();
                    } else if (smTypeName.equals((Object)StatisticalServiceType.LIST)) {
                        value = ((LiteralStringBinding)inputData.get(smParam.name()).get(0)).getPayload();
                    } else if (smTypeName.equals((Object)StatisticalServiceType.COLUMN)) {
                        value = ((LiteralStringBinding)inputData.get(smParam.name()).get(0)).getPayload();
                    } else if (smTypeName.equals((Object)StatisticalServiceType.COLUMN_LIST)) {
                        value = ((LiteralStringBinding)inputData.get(smParam.name()).get(0)).getPayload();
                    } else if (smTypeName.equals((Object)StatisticalServiceType.FILE)) {
                        value = ((LiteralStringBinding)inputData.get(smParam.name()).get(0)).getPayload();
                    }
                    list[i] = new SMInputEntry(smParam.name(), value);
                    ++i;
                    continue;
                }
                list[i] = new SMInputEntry(smParam.name(), null);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

