package org.gcube.dataanalysis.ecoengine.test.signalprocessing;

import java.util.List;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;

public class TestSimpleSignal {

//	static AlgorithmConfiguration[] configs = {periodicSignalConfig()};//russianSignalConfig(),simpleSignalConfig()};
	static AlgorithmConfiguration[] configs = {periodicSignalConfig(), russianSignalConfig(),simpleSignalConfig(), occurrencePointsSignalConfig(),hugeSignalConfig()};
//	static AlgorithmConfiguration[] configs = {russianSignalConfig()};
//	static AlgorithmConfiguration[] configs = {hugeSignalConfig()};
//	static AlgorithmConfiguration[] configs = {periodicSignalConfig()};
	public static void main(String[] args) throws Exception {
		for (int i = 0; i < configs.length; i++) {
			System.out.println("*****************TEST "+i+" *****************");

			List<ComputationalAgent> trans = null;
			trans = TransducerersFactory.getTransducerers(configs[i]);
			trans.get(0).init();
			Regressor.process(trans.get(0));
			StatisticalType st = trans.get(0).getOutput();
			AnalysisLogger.getLogger().debug("ST:" + st);
			trans = null;
			System.out.println("*****************END TEST*****************");
		}
	}

	public static AlgorithmConfiguration simpleSignalConfig() {

		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setAgent("TIME_SERIES_PROCESSING");
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("DatabaseUserName", "utente");
		config.setParam("DatabasePassword", "d4science");
		config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");
		// vessels
		config.setParam("TimeSeriesTable", "timeseries_id4dd368bf_63fb_4d19_8e31_20ced63a477d");
		config.setParam("ValueColum", "quantity");

		AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);

		config.setGcubeScope("/gcube");
		config.setConfigPath("./cfg");
		return config;

	}
	
	public static AlgorithmConfiguration russianSignalConfig() {

		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setAgent("TIME_SERIES_PROCESSING");
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("DatabaseUserName", "utente");
		config.setParam("DatabasePassword", "d4science");
		config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");
		// vessels
		config.setParam("TimeSeriesTable", "generic_ideb9efbe0_61ad_4eea_b0ee_95e64ce11b28");
		config.setParam("ValueColum", "quantity");

		AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);

		config.setGcubeScope("/gcube");
		config.setConfigPath("./cfg");
		return config;

	}
	
	public static AlgorithmConfiguration occurrencePointsSignalConfig() {

		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setAgent("TIME_SERIES_PROCESSING");
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("DatabaseUserName", "utente");
		config.setParam("DatabasePassword", "d4science");
		config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");
		// vessels
		config.setParam("TimeSeriesTable", "generic_id037d302d_2ba0_4e43_b6e4_1a797bb91728");
		config.setParam("ValueColum", "speed");
		config.setParam("TimeColum", "datetime");
		config.setParam("AggregationFunction", "AVG");

		AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);

		config.setGcubeScope("/gcube");
		config.setConfigPath("./cfg");
		return config;

	}

	public static AlgorithmConfiguration periodicSignalConfig() {

		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setAgent("TIME_SERIES_PROCESSING");
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("DatabaseUserName", "utente");
		config.setParam("DatabasePassword", "d4science");
		config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");
		// vessels
		config.setParam("TimeSeriesTable", "signalcsv");
		config.setParam("ValueColum", "signal");
		config.setParam("FrequencyResolution", "1");
		
		
		AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);

		config.setGcubeScope("/gcube");
		config.setConfigPath("./cfg");
		return config;

	}
	
	public static AlgorithmConfiguration hugeSignalConfig() {

		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setAgent("TIME_SERIES_PROCESSING");
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("DatabaseUserName", "utente");
		config.setParam("DatabasePassword", "d4science");
		config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");
		// vessels
		config.setParam("TimeSeriesTable", "generic_id634a660c_4d1a_410c_aa45_eb6e4c5afdf9");
		config.setParam("ValueColum", "quantity");
		config.setParam("TimeColum", "years");
		
		
		AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);

		config.setGcubeScope("/gcube");
		config.setConfigPath("./cfg");
		return config;

	}
	
}
