/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.signals.PeriodicityDetector;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.ecoengine.signals.TimeSeries;
import org.gcube.dataanalysis.ecoengine.utils.AggregationFunctions;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.hibernate.SessionFactory;

public class TimeSeriesAnalysis
extends StandardLocalExternalAlgorithm {
    private static String timeSeriesTable = "TimeSeriesTable";
    private static String valuesColumn = "ValueColum";
    private static String timeColumn = "TimeColum";
    private static String frequencyResolution = "FrequencyResolution";
    private static String aggregationFunction = "AggregationFunction";

    @Override
    public void init() throws Exception {
    }

    @Override
    public String getDescription() {
        return "An algorithms applying signal processing to a non uniform time series. It uniformly samples the series, then extracts hidden periodicities and signal properties.";
    }

    @Override
    protected void process() throws Exception {
        SessionFactory dbconnection = null;
        try {
            dbconnection = DatabaseUtils.initDBSession(this.config);
            String tablename = this.config.getParam(timeSeriesTable);
            String valuescolum = this.config.getParam(valuesColumn);
            String timecolumn = this.config.getParam(timeColumn);
            String aggregationFunc = this.config.getParam(aggregationFunction);
            String frequencyRes = this.config.getParam(frequencyResolution);
            float frequencyResDouble = 1.0f;
            if (timecolumn == null) {
                timecolumn = "time";
            }
            if (aggregationFunc == null) {
                aggregationFunc = "SUM";
            }
            if (frequencyRes != null) {
                try {
                    frequencyResDouble = Float.parseFloat(frequencyRes);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Table Name: " + tablename));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Time Column: " + timecolumn));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Values Column: " + valuescolum));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Aggregation: " + aggregationFunc));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Frequency Resolution: " + frequencyRes));
            String query = "select * from (select " + aggregationFunc + "(" + valuescolum + ")," + timecolumn + " from " + tablename + " group by " + timecolumn + ") as a";
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Query to execute: " + query));
            List<Object> results = DatabaseFactory.executeSQLQuery(query, dbconnection);
            if (results == null || results.size() == 0) {
                throw new Exception("Error in retrieving values from the table: no time series found");
            }
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Building signal");
            ArrayList<Tuple<String>> signal = new ArrayList<Tuple<String>>();
            int sizesignal = 0;
            for (Object row : results) {
                Object[] srow = (Object[])row;
                String value = "" + srow[0];
                String time = "" + srow[1];
                signal.add(new Tuple<String>(time, value));
                ++sizesignal;
            }
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Signal built with success. Size: " + sizesignal));
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Building Time Series");
            TimeSeries ts = TimeSeries.buildFromSignal(signal, this.config);
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Uniformly sampling the signal");
            SignalProcessing.displaySignalWithTime(ts.getValues(), ts.getTime(), "Time Series", "HH:mm:ss MM-dd-yy");
            ts.convertToUniformSignal(0.0);
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Uniform sampling finished");
            SignalProcessing.displaySignalWithTime(ts.getValues(), ts.getTime(), "Unif Samp Time Series", "HH:mm:ss MM-dd-yy");
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Detecting periodicity");
            PeriodicityDetector pd = new PeriodicityDetector();
            double F = pd.detectFrequency(ts.getValues(), 1, 0.01f, 0.5f, frequencyResDouble, true);
            AnalysisLogger.getLogger().debug((Object)("Detected Frequency: " + F + " indecision [" + pd.lowermeanF + " , " + pd.uppermeanF + "]"));
            AnalysisLogger.getLogger().debug((Object)("Detected Period: " + pd.meanPeriod + " indecision [" + pd.lowermeanPeriod + " , " + pd.uppermeanPeriod + "]"));
            AnalysisLogger.getLogger().debug((Object)("Detected Periodicity Strength: " + pd.periodicityStrength + " (" + pd.getPeriodicityStregthInterpretation() + ")"));
            AnalysisLogger.getLogger().debug((Object)("Periodicity inside this samples range: [" + pd.startPeriodTime + ";" + pd.endPeriodTime + "]"));
            AnalysisLogger.getLogger().debug((Object)("Maximum Frequency in the Spectrogram " + MathFunctions.roundDecimal(pd.maxFrequency, 2)));
            AnalysisLogger.getLogger().debug((Object)("Minimum Frequency in the Spectrogram " + MathFunctions.roundDecimal(pd.minFrequency, 2)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (dbconnection != null) {
                dbconnection.close();
            }
        }
    }

    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.TIMESERIES);
        InputTable p = new InputTable(templates, timeSeriesTable, "The table containing the time series", "timeseries");
        this.inputs.add(p);
        ColumnType p1 = new ColumnType(timeSeriesTable, valuesColumn, "The column containing the values of the time series", "values", false);
        this.inputs.add(p1);
        this.addDoubleInput(frequencyResolution, "The precision in detecting the period. The lower this number the less the number of points in the Spectrogram (higher number of samples used at each step). Reducing this, the spectrogram will be finer and sharper, but you should tune it. Too many samples will make the Spectrogram noisy.", "1");
        this.addEnumerateInput(AggregationFunctions.values(), aggregationFunction, "Function to apply to samples with the same time instant", AggregationFunctions.SUM.name());
    }

    @Override
    public void shutdown() {
    }
}

