/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals;

import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.SignalConverter;

public class PeriodicityDetector {
    static int defaultSamplingRate = 8000;
    static float defaultSignalLengthTimeinSec = 5.0f;
    static float defaultHiddenFrequency = 2.0f;
    static float defaultMinPossibleFreq = 0.0f;
    static float defaultMaxPossibleFreq = 1000.0f;
    static float defaultSNratio = 0.0f;
    static float defaultFreqError = 1.0f;
    public int currentSamplingRate;
    public int currentWindowShiftSamples;
    public int currentWindowAnalysisSamples;
    public double[][] currentspectrum;
    public double meanF = 0.0;
    public double lowermeanF = 0.0;
    public double uppermeanF = 0.0;
    public double meanPeriod = 0.0;
    public double lowermeanPeriod = 0.0;
    public double uppermeanPeriod = 0.0;
    public double startPeriodTime = 0.0;
    public double endPeriodTime = 0.0;
    public double startPeriodSampleIndex = 0.0;
    public double endPeriodSampleIndex = 0.0;
    public double periodicityStrength = 0.0;
    public double minFrequency;
    public double maxFrequency;

    public String getPeriodicityStregthInterpretation() {
        if (this.periodicityStrength > 0.6) {
            return "High";
        }
        if (this.periodicityStrength < 0.6 && this.periodicityStrength > 0.5) {
            return "Moderate";
        }
        if (this.periodicityStrength < 0.5 && this.periodicityStrength > 0.3) {
            return "Weak";
        }
        if (this.periodicityStrength < 0.5 && this.periodicityStrength > 0.3) {
            return "Very Low";
        }
        return "None";
    }

    public void demo() throws Exception {
        double[] signal = this.produceNoisySignal(defaultSignalLengthTimeinSec, defaultSamplingRate, defaultHiddenFrequency, defaultSNratio);
        AnalysisLogger.getLogger().debug((Object)("Signal samples: " + signal.length));
        double F = this.detectFrequency(signal, defaultSamplingRate, defaultMinPossibleFreq, defaultMaxPossibleFreq, defaultFreqError, true);
        AnalysisLogger.getLogger().debug((Object)("Detected F:" + F + " indecision [" + this.lowermeanF + " , " + this.uppermeanF + "]"));
    }

    public static void main(String[] args) throws Exception {
        PeriodicityDetector processor = new PeriodicityDetector();
        processor.demo();
    }

    public double[] produceNoisySignal(float signalLengthTimeinSec, int samplingRate, float frequency, float SNratio) {
        double[] sin = SignalConverter.generateSinSignal((int)signalLengthTimeinSec * samplingRate, 1.0f / (float)samplingRate, frequency);
        for (int i = 0; i < sin.length; ++i) {
            sin[i] = sin[i] + (double)SNratio * Math.random();
        }
        return sin;
    }

    public double detectFrequency(double[] signal, boolean display) throws Exception {
        return this.detectFrequency(signal, 1, 0.0f, 1.0f, 1.0f, display);
    }

    public double detectFrequency(double[] signal) throws Exception {
        return this.detectFrequency(signal, false);
    }

    public double detectFrequency(double[] signal, int samplingRate, float minPossibleFreq, float maxPossibleFreq, float wantedFreqError, boolean display) throws Exception {
        double meanF;
        long pow = Math.round(Math.log((float)samplingRate / wantedFreqError) / Math.log(2.0));
        if (pow == 0L) {
            pow = Math.round(Math.log((float)signal.length / (float)("" + signal.length).length()) / Math.log(2.0));
        }
        int wLength = (int)Math.pow(2.0, pow);
        AnalysisLogger.getLogger().debug((Object)("Suggested pow for window length=" + pow));
        AnalysisLogger.getLogger().debug((Object)("Suggested windows length (samples)=" + wLength));
        AnalysisLogger.getLogger().debug((Object)("Suggested windows length (s)=" + (float)wLength / (float)samplingRate + " s"));
        int windowAnalysisSamples = (int)Math.pow(2.0, 14.0);
        windowAnalysisSamples = wLength;
        int windowShiftSamples = Math.round((float)windowAnalysisSamples / 2.0f);
        float windowShiftTime = (float)SignalConverter.sample2Time(windowShiftSamples, samplingRate);
        float error = (float)samplingRate / (float)windowAnalysisSamples;
        AnalysisLogger.getLogger().debug((Object)("Error in the Measure will be: " + error + " Hz"));
        AnalysisLogger.getLogger().debug((Object)("A priori Min Freq: " + minPossibleFreq + " s"));
        AnalysisLogger.getLogger().debug((Object)("A priori Max Freq: " + maxPossibleFreq + " s"));
        if (maxPossibleFreq >= (float)samplingRate) {
            maxPossibleFreq = (float)samplingRate / 2.0f - 0.1f * (float)samplingRate / 2.0f;
        }
        if (minPossibleFreq == 0.0f) {
            minPossibleFreq = 0.1f;
        }
        this.minFrequency = minPossibleFreq;
        this.maxFrequency = maxPossibleFreq;
        this.currentSamplingRate = samplingRate;
        this.currentWindowShiftSamples = windowShiftSamples;
        this.currentWindowAnalysisSamples = windowAnalysisSamples;
        double[][] spectrum = SignalConverter.spectrogram("spectrogram", signal, samplingRate, windowShiftSamples, windowAnalysisSamples, false);
        if (display) {
            SignalConverter.displaySpectrogram(spectrum, signal, "complete spectrogram", samplingRate, windowShiftSamples, windowAnalysisSamples);
        }
        spectrum = SignalConverter.cutSpectrum(spectrum, minPossibleFreq, maxPossibleFreq, windowAnalysisSamples, samplingRate);
        if (display) {
            SignalConverter.displaySpectrogram(spectrum, signal, "clean spectrogram", samplingRate, windowShiftSamples, windowAnalysisSamples);
        }
        SignalConverter signalMaximumAnalyzer = new SignalConverter();
        double[] maxfrequencies = signalMaximumAnalyzer.takeMaxFrequenciesInSpectrogram(spectrum, samplingRate, windowAnalysisSamples, minPossibleFreq);
        double[] powers = signalMaximumAnalyzer.averagepower;
        this.currentspectrum = spectrum;
        AnalysisLogger.getLogger().debug((Object)("Number of frequency peaks " + maxfrequencies.length));
        SignalConverter signalconverter = new SignalConverter();
        maxfrequencies = signalconverter.takeLongestStableTract(maxfrequencies, 0.5);
        if (maxfrequencies == null) {
            return 0.0;
        }
        this.startPeriodTime = SignalConverter.spectrogramTimeFromIndex(signalconverter.startStableTractIdx, windowShiftTime);
        this.endPeriodTime = SignalConverter.spectrogramTimeFromIndex(signalconverter.endStableTractIdx, windowShiftTime);
        this.startPeriodSampleIndex = SignalConverter.time2Sample(this.startPeriodTime, samplingRate);
        this.endPeriodSampleIndex = Math.min(SignalConverter.time2Sample(this.endPeriodTime, samplingRate), signal.length - 1);
        float power = 0.0f;
        int counter = 0;
        for (int i = signalconverter.startStableTractIdx; i < signalconverter.endStableTractIdx; ++i) {
            power = MathFunctions.incrementPerc(power, (float)powers[i], counter);
            ++counter;
        }
        this.periodicityStrength = power;
        if (this.periodicityStrength == -0.0) {
            this.periodicityStrength = 0.0;
        }
        this.meanF = meanF = MathFunctions.mean(maxfrequencies);
        this.lowermeanF = meanF - (double)error;
        this.uppermeanF = meanF + (double)error;
        this.meanPeriod = 1.0 / meanF;
        this.lowermeanPeriod = 1.0 / this.lowermeanF;
        this.uppermeanPeriod = 1.0 / this.uppermeanF;
        return meanF;
    }
}

