/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.GenericAlgorithm;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionGeneric;

public class LocalSimpleSplitGenerator
implements Generator {
    protected AlgorithmConfiguration config;
    protected ExecutorService executorService;
    protected int numberOfThreadsToUse;
    protected boolean[] threadActivity;
    protected boolean stopInterrupt;
    protected SpatialProbabilityDistributionGeneric distributionModel;
    protected int processedSpeciesCounter;
    protected int spaceVectorsNumber;
    protected List<Object> environmentVectors;
    protected long lastTime;
    protected int lastProcessedRecordsNumber;
    protected int processedRecordsCounter;
    protected float status;
    protected int chunksize;
    protected ConcurrentLinkedQueue<String> probabilityBuffer;
    protected ConcurrentHashMap<Object, Map<Object, Float>> completeDistribution;

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public String getResourceLoad() {
        long tk = System.currentTimeMillis();
        double activity = Double.valueOf(this.processedRecordsCounter - this.lastProcessedRecordsNumber) * 1000.0 / Double.valueOf(tk - this.lastTime);
        this.lastTime = tk;
        this.lastProcessedRecordsNumber = this.processedRecordsCounter;
        ResourceLoad rs = new ResourceLoad(tk, activity);
        return rs.toString();
    }

    @Override
    public String getResources() {
        Resources res = new Resources();
        try {
            for (int i = 0; i < this.numberOfThreadsToUse; ++i) {
                try {
                    double value = this.threadActivity[i] ? 100.0 : 0.0;
                    res.addResource("Thread_" + (i + 1), value);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon(res.list).replace("resId", "resID");
        }
        return "";
    }

    @Override
    public String getLoad() {
        long tk = System.currentTimeMillis();
        double activity = this.processedSpeciesCounter;
        ResourceLoad rs = new ResourceLoad(tk, activity);
        return rs.toString();
    }

    @Override
    public void init() {
        AnalysisLogger.setLogger(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        this.stopInterrupt = false;
        this.completeDistribution = new ConcurrentHashMap();
        try {
            this.initModel();
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)"error", (Throwable)e);
        }
        this.probabilityBuffer = new ConcurrentLinkedQueue();
    }

    protected void initModel() throws Exception {
        Properties p = AlgorithmConfiguration.getProperties(this.config.getConfigPath() + AlgorithmConfiguration.algorithmsFile);
        String objectclass = p.getProperty(this.config.getModel());
        this.distributionModel = (SpatialProbabilityDistributionGeneric)Class.forName(objectclass).newInstance();
        this.distributionModel.init(this.config);
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
        this.numberOfThreadsToUse = config.getNumberOfResources() == 0 ? 1 : config.getNumberOfResources();
    }

    public void initializeThreads() {
        this.executorService = Executors.newFixedThreadPool(this.numberOfThreadsToUse);
        this.threadActivity = new boolean[this.numberOfThreadsToUse];
        for (int j = 0; j < this.threadActivity.length; ++j) {
            this.threadActivity[j] = false;
        }
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.stopInterrupt = true;
    }

    private void wait4Thread(int index) {
        while (this.threadActivity[index]) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void compute() throws Exception {
        long tstart = System.currentTimeMillis();
        try {
            AnalysisLogger.getLogger().trace((Object)"generate->Take features reference");
            this.environmentVectors = this.distributionModel.getGeographicalInfoObjects();
            if (this.environmentVectors == null || this.environmentVectors.size() == 0) {
                throw new Exception("Empty Features Set");
            }
            this.spaceVectorsNumber = this.environmentVectors.size();
            AnalysisLogger.getLogger().trace((Object)("generate->Features to calc: " + this.spaceVectorsNumber));
            AnalysisLogger.getLogger().trace((Object)"generate->Take groups references");
            List<Object> speciesVectors = this.distributionModel.getMainInfoObjects();
            int speciesVectorNumber = speciesVectors.size();
            AnalysisLogger.getLogger().trace((Object)("generate->Number of groups of features: " + speciesVectorNumber));
            this.chunksize = this.spaceVectorsNumber / this.numberOfThreadsToUse;
            if (this.chunksize == 0) {
                this.chunksize = 1;
            }
            int numOfChunks = this.spaceVectorsNumber / this.chunksize;
            if (this.spaceVectorsNumber % this.chunksize != 0) {
                ++numOfChunks;
            }
            AnalysisLogger.getLogger().trace((Object)("generate->Calculation Started with " + numOfChunks + " chunks and " + speciesVectorNumber + " groups - chunk size will be " + this.chunksize));
            this.initializeThreads();
            int overallcounter = 0;
            this.processedSpeciesCounter = 0;
            for (Object species : speciesVectors) {
                int currentThread = 0;
                long computationT0 = System.currentTimeMillis();
                this.distributionModel.singleStepPreprocess(species, this.spaceVectorsNumber);
                AnalysisLogger.getLogger().trace((Object)("-> species " + this.distributionModel.getMainInfoID(species) + " - n. " + (this.processedSpeciesCounter + 1)));
                for (int k = 0; k < numOfChunks; ++k) {
                    int start = k * this.chunksize;
                    this.wait4Thread(currentThread);
                    this.startNewTCalc(currentThread, species, start);
                    if (++currentThread >= this.numberOfThreadsToUse) {
                        currentThread = 0;
                    }
                    this.status = (float)overallcounter / (float)(speciesVectorNumber * numOfChunks) * 100.0f;
                    if (this.status == 100.0f) {
                        this.status = 99.0f;
                    }
                    ++overallcounter;
                }
                for (int i = 0; i < this.numberOfThreadsToUse; ++i) {
                    this.wait4Thread(i);
                }
                long computationT1 = System.currentTimeMillis();
                AnalysisLogger.getLogger().trace((Object)("generate->Species Computation Finished in " + (computationT1 - computationT0) + " ms"));
                ++this.processedSpeciesCounter;
                this.distributionModel.singleStepPostprocess(species, this.spaceVectorsNumber);
                if (!this.stopInterrupt) continue;
                break;
            }
            long computationT2 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace((Object)("generate->All Species Computed in " + (computationT2 - tstart) + " ms"));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)"error", (Throwable)e);
            throw e;
        }
        finally {
            AnalysisLogger.getLogger().trace((Object)"generate-> Storing Probability Distribution");
            try {
                this.distributionModel.storeDistribution(this.completeDistribution);
            }
            catch (Exception ee) {
                AnalysisLogger.getLogger().trace((Object)"generate-> Error Storing Probability Distribution ", (Throwable)ee);
            }
            try {
                this.distributionModel.postProcess();
            }
            catch (Exception ee) {}
            try {
                this.shutdown();
            }
            catch (Exception ee) {}
            long tend = System.currentTimeMillis();
            long ttotal = tend - tstart;
            AnalysisLogger.getLogger().warn((Object)("generate->Distribution Generator->Algorithm finished in: " + (double)ttotal / 60000.0 + " min\n"));
            this.status = 100.0f;
        }
    }

    private void startNewTCalc(int index, Object speciesVector, int start) {
        this.threadActivity[index] = true;
        ThreadCalculator tc = new ThreadCalculator(index, speciesVector, start);
        this.executorService.submit(tc);
    }

    @Override
    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_GEOINFO};
        return p;
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        return new ArrayList<StatisticalType>();
    }

    @Override
    public StatisticalType getOutput() {
        return this.distributionModel.getOutput();
    }

    @Override
    public GenericAlgorithm getAlgorithm() {
        return this.distributionModel;
    }

    @Override
    public String getDescription() {
        return "A generator which splits a distribution on different threads along the species dimension";
    }

    private class ThreadCalculator
    implements Callable<Integer> {
        int threadIndex;
        int spaceindex;
        Object speciesVector;

        public ThreadCalculator(int threadIndex, Object speciesVector, int start) {
            this.threadIndex = threadIndex;
            this.speciesVector = speciesVector;
            this.spaceindex = start;
        }

        @Override
        public Integer call() {
            AnalysisLogger.getLogger().trace((Object)("threadCalculation->" + (this.threadIndex + 1)));
            int max = Math.min(this.spaceindex + LocalSimpleSplitGenerator.this.chunksize, LocalSimpleSplitGenerator.this.spaceVectorsNumber);
            String speciesID = LocalSimpleSplitGenerator.this.distributionModel.getMainInfoID(this.speciesVector);
            AnalysisLogger.getLogger().trace((Object)("threadCalculation-> calculating elements from " + this.spaceindex + " to " + max + " for species " + speciesID));
            Map<Object, Float> geoDistrib = LocalSimpleSplitGenerator.this.completeDistribution.get(speciesID);
            if (geoDistrib == null) {
                geoDistrib = new ConcurrentHashMap<Object, Float>();
                LocalSimpleSplitGenerator.this.completeDistribution.put(this.speciesVector, geoDistrib);
            }
            for (int i = this.spaceindex; i < max; ++i) {
                Object enfeatures = LocalSimpleSplitGenerator.this.environmentVectors.get(i);
                float prob = LocalSimpleSplitGenerator.this.distributionModel.calcProb(this.speciesVector, enfeatures);
                geoDistrib.put(enfeatures, Float.valueOf(prob));
                ++LocalSimpleSplitGenerator.this.processedRecordsCounter;
            }
            AnalysisLogger.getLogger().trace((Object)"FINISHED");
            LocalSimpleSplitGenerator.this.threadActivity[this.threadIndex] = false;
            return 0;
        }
    }
}

