/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.executor.job.management.GenericWorker;
import org.gcube.dataanalysis.executor.job.management.GenericWorkerCaller;
import org.gcube.dataanalysis.executor.util.InfraRetrieval;

public class WPSJobManager {
    static final int pollingTime = 5000;
    static final long maxTaskTime = 720000L;
    int overallFailures = 0;
    int overallSuccess = 0;
    int overallTasks = 0;
    int nservices = -1;
    boolean stopThreads = false;
    boolean hasResentMessages = false;

    public static String getCallTemplate() {
        String call = null;
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("templates/WPSGWTemplate2.xml");
            AnalysisLogger.getLogger().debug((Object)("WPSJobManager->GW template Input stream is null " + (is == null)));
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuilder vud = new StringBuilder();
            while ((line = in.readLine()) != null) {
                vud.append(line + "\n");
            }
            in.close();
            call = vud.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return call;
    }

    public final synchronized void incrementOverallFailures() {
        ++this.overallFailures;
    }

    public final synchronized void hasResentTrue() {
        if (!this.hasResentMessages) {
            this.hasResentMessages = true;
        }
    }

    public final synchronized void incrementOverallSuccess() {
        ++this.overallSuccess;
    }

    public final synchronized void stop() {
        this.stopThreads = true;
    }

    public final synchronized boolean isStopped() {
        return this.stopThreads;
    }

    public int getNumberOfNodes() {
        return 1;
    }

    public int getActiveNodes() {
        return 1;
    }

    public float getStatus() {
        return (float)(this.overallFailures + this.overallSuccess) / (float)this.overallTasks;
    }

    public boolean wasAborted() {
        return this.stopThreads;
    }

    public boolean hasResentMessages() {
        return this.hasResentMessages;
    }

    public int estimateNumberOfServices(String scope) throws Exception {
        List<String> wpsservices = InfraRetrieval.retrieveService("DataMiner", scope);
        if (wpsservices == null || wpsservices.size() == 0) {
            AnalysisLogger.getLogger().debug((Object)"WPSJobManager->Error: No DataMiner GCore Endpoints found!");
            throw new Exception("No DataMinerWorkers GCore Endpoint found in the VRE " + scope);
        }
        ArrayList<String> differentServices = new ArrayList<String>();
        for (String service : wpsservices) {
            service = service.substring(service.indexOf("/") + 2);
            if (differentServices.contains(service = service.substring(0, service.indexOf(":")))) continue;
            differentServices.add(service);
        }
        int numberofservices = differentServices.size();
        AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Number of found services " + numberofservices));
        this.nservices = Math.max(1, numberofservices - 1);
        return this.nservices;
    }

    public void uploadAndExecuteChunkized(AlgorithmConfiguration configuration, String algorithmClass, List<String> arguments, String session) throws Exception {
        ExecutorService executor = null;
        try {
            int njobs;
            String wpshostAddress;
            int numberofservices = 1;
            String callTemplate = WPSJobManager.getCallTemplate();
            AnalysisLogger.getLogger().debug((Object)"WPSJobManager->Estimating the number of services");
            numberofservices = this.nservices > 0 ? this.nservices : this.estimateNumberOfServices(configuration.getGcubeScope());
            AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Number of dataminer services " + numberofservices));
            int parallelisation = numberofservices * 2;
            AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Number of parallel processes (parallelisation) : " + parallelisation));
            List<String> wpshosts = InfraRetrieval.retrieveServiceAddress("DataAnalysis", "DataMinerWorkers", configuration.getGcubeScope(), "noexclusion");
            if (wpshosts == null || wpshosts.size() == 0) {
                AnalysisLogger.getLogger().debug((Object)"WPSJobManager->Error: No DataMinerWorkers Service Endpoints found at all!");
                throw new Exception("WPSJobManager->No Dataminer Workers Service Endpoint found in the VRE - DataMinerWorkers Resource is required in the VRE" + configuration.getGcubeScope());
            }
            String wpshost = wpshosts.get(0);
            wpshost = wpshost.substring(wpshost.indexOf("/") + 2);
            wpshost = wpshostAddress = wpshost.substring(0, wpshost.indexOf("/"));
            int wpsport = 80;
            this.overallTasks = arguments.size();
            AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Workers WPS host " + wpshost));
            executor = Executors.newFixedThreadPool(this.nservices);
            int taskNumber = 0;
            AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Executing algorithm class:" + algorithmClass));
            for (String argument : arguments) {
                String[] lfnlnr = argument.split(" ");
                int leftOff = Integer.parseInt(lfnlnr[0]);
                int leftNum = Integer.parseInt(lfnlnr[1]);
                int rightOff = Integer.parseInt(lfnlnr[2]);
                int rightNum = Integer.parseInt(lfnlnr[3]);
                int maxTrials = parallelisation;
                TasksWatcher watcher = new TasksWatcher(algorithmClass, configuration.getGcubeUserName(), configuration.getGcubeToken(), wpshost, wpsport, session, taskNumber, configuration, leftOff, rightOff, leftNum, rightNum, callTemplate, maxTrials);
                executor.execute(watcher);
                AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Task number " + taskNumber + " launched with arguments: " + argument));
                ++taskNumber;
                Thread.sleep(1000L);
            }
            int pnjobs = njobs = this.overallFailures + this.overallSuccess;
            while (njobs < this.overallTasks) {
                Thread.sleep(5000L);
                float percFailure = (float)this.overallFailures / (float)this.overallTasks;
                if (this.overallFailures > 0) {
                    this.stop();
                }
                if (pnjobs >= (njobs = this.overallFailures + this.overallSuccess)) continue;
                AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Number of finished jobs " + njobs + " of " + this.overallTasks));
                AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Number of errors " + this.overallFailures + " - perc failure " + percFailure));
                pnjobs = njobs;
            }
            AnalysisLogger.getLogger().debug((Object)"WPSJobManager->Overall computation finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (executor != null) {
                AnalysisLogger.getLogger().debug((Object)"WPSJobManager->Shutting down the executions");
                executor.shutdown();
                AnalysisLogger.getLogger().debug((Object)"WPSJobManager->Shut down completed");
            }
        }
    }

    public class TasksWatcher
    implements Runnable {
        AlgorithmConfiguration configuration;
        String algorithm;
        String username;
        String token;
        String wpsHost;
        int wpsPort;
        int taskNumber;
        String session;
        public String exitstatus = GenericWorker.TASK_UNDEFINED;
        int leftSetIndex;
        int rightSetIndex;
        int leftElements;
        int rightElements;
        String callTemplate;
        int maxTrialsPerThread;

        public TasksWatcher(String algorithm, String username, String token, String wpsHost, int wpsPort, String session, int taskNumber, AlgorithmConfiguration configuration, int leftSetIndex, int rightSetIndex, int leftElements, int rightElements, String callTemplate, int maxTrialsPerThread) {
            this.algorithm = algorithm;
            this.token = token;
            this.wpsHost = wpsHost;
            this.wpsPort = wpsPort;
            this.taskNumber = taskNumber;
            this.session = session;
            this.username = username;
            this.configuration = configuration;
            this.leftSetIndex = leftSetIndex;
            this.leftElements = leftElements;
            this.rightSetIndex = rightSetIndex;
            this.rightElements = rightElements;
            this.callTemplate = callTemplate;
            this.maxTrialsPerThread = maxTrialsPerThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callTask(boolean isduplicate) {
            String url = "http://" + this.wpsHost + ":" + this.wpsPort + "/wps/WebProcessingService";
            boolean deleteTemporaryFiles = true;
            AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Task Number : " + this.taskNumber + " GO!"));
            try {
                AnalysisLogger.getLogger().debug((Object)"WPSJobManager->Invoking the GW to start");
                String algorithmCall = GenericWorkerCaller.getGenericWorkerCall(this.algorithm, this.session, this.configuration, this.leftSetIndex, this.rightSetIndex, this.leftElements, this.rightElements, isduplicate, deleteTemporaryFiles, this.callTemplate);
                String result = HttpRequest.PostXmlString((String)url, (String)this.wpsHost, (int)this.wpsPort, new LinkedHashMap(), (String)this.username, (String)this.token, (String)algorithmCall);
                AnalysisLogger.getLogger().debug((Object)("WPSJobManager->GW starting Output " + result.replace("\n", "")));
                boolean success = false;
                boolean failure = false;
                if (result.contains(GenericWorker.TASK_SUCCESS)) {
                    success = true;
                } else if (result.contains(GenericWorker.TASK_FAILURE)) {
                    failure = true;
                }
                String statusLocation = "";
                long taskTimeCounter = 0L;
                while (!(success || WPSJobManager.this.isStopped() || failure)) {
                    if (result == null || result.contains(GenericWorker.TASK_FAILURE)) {
                        failure = true;
                        continue;
                    }
                    if (taskTimeCounter > 720000L) {
                        failure = true;
                        continue;
                    }
                    if (result.contains(GenericWorker.TASK_SUCCESS)) {
                        success = true;
                        continue;
                    }
                    if (result.contains("<wps:ProcessAccepted>Process Accepted</wps:ProcessAccepted>")) {
                        if (result.contains("<ows:Exception ")) {
                            failure = true;
                            continue;
                        }
                        statusLocation = result.substring(result.indexOf("statusLocation=") + "statusLocation=".length());
                        statusLocation = statusLocation.substring(0, statusLocation.indexOf(">"));
                        statusLocation = statusLocation.replace("\"", "");
                        statusLocation = statusLocation + "&gcube-token=" + this.token;
                        result = "";
                        continue;
                    }
                    Thread.sleep(5000L);
                    taskTimeCounter += 5000L;
                    result = HttpRequest.sendGetRequest((String)statusLocation, (String)"");
                }
                if (WPSJobManager.this.isStopped() && statusLocation != null && statusLocation.length() > 0) {
                    String wpscancel = statusLocation.replace("RetrieveResultServlet", "CancelComputationServlet");
                    result = HttpRequest.sendGetRequest((String)wpscancel, (String)"");
                }
                this.exitstatus = GenericWorker.TASK_SUCCESS;
                if (failure) {
                    this.exitstatus = GenericWorker.TASK_FAILURE;
                    AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Task Number " + this.taskNumber + " - Failure cause: " + URLDecoder.decode(result, "UTF-8")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().error((Object)("WPSJobManager->Task Number " + this.taskNumber + " - Process exception "), (Throwable)e);
                this.exitstatus = GenericWorker.TASK_FAILURE;
            }
        }

        @Override
        public void run() {
            int trials = 0;
            boolean duplicate = false;
            while (!this.exitstatus.equals(GenericWorker.TASK_SUCCESS) && trials < this.maxTrialsPerThread) {
                this.callTask(duplicate);
                if (!this.exitstatus.equals(GenericWorker.TASK_FAILURE)) continue;
                WPSJobManager.this.hasResentTrue();
                duplicate = true;
                AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Task Number " + this.taskNumber + " - Retrying n." + ++trials));
            }
            if (this.exitstatus.equals(GenericWorker.TASK_SUCCESS)) {
                WPSJobManager.this.incrementOverallSuccess();
            } else {
                WPSJobManager.this.incrementOverallFailures();
            }
            AnalysisLogger.getLogger().debug((Object)("WPSJobManager->Task Number " + this.taskNumber + " - Finished: " + this.exitstatus));
        }
    }
}

