/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.ws.EndpointReference;
import org.gcube.common.clients.Plugin;
import org.gcube.common.clients.ProxyBuilderImpl;
import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.dataanalysis.executor.job.management.WorkerWatcher;
import org.gcube.dataanalysis.executor.scripts.ScriptIOWorker;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.client.plugins.ExecutorPlugin;
import org.gcube.vremanagement.executor.client.plugins.query.SmartExecutorPluginQuery;
import org.gcube.vremanagement.executor.client.plugins.query.filter.EndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.plugins.query.filter.SpecificEndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.proxies.SmartExecutorProxy;
import org.gcube.vremanagement.executor.client.util.Tuple;
import org.gcube.vremanagement.executor.plugin.PluginState;

public class RemoteJobManager {
    private static String pluginName = "SmartGenericWorker";
    private int actualNumberOfNodes;
    private List<String> eprs;
    float status;
    boolean abort;
    boolean shutdown;
    protected int activeNodes;
    String scope;
    List<String> filenames;
    List<String> fileurls;
    boolean yetuploaded;
    String session;

    public int getActiveNodes() {
        return this.activeNodes;
    }

    public float getStatus() {
        return this.status;
    }

    public int getNumberOfNodes() {
        return this.actualNumberOfNodes;
    }

    public void setNumberOfNodes(int newNumberOfNodes) {
        this.actualNumberOfNodes = newNumberOfNodes;
    }

    public void init(String scope, int numberOfNodes) throws Exception {
        this.scope = scope;
        AnalysisLogger.getLogger().debug((Object)("Using the following scope for this computation: " + scope));
        this.shutdown = false;
        this.yetuploaded = false;
        this.actualNumberOfNodes = this.eprs == null ? this.findNodes(scope) : this.eprs.size();
        if (numberOfNodes < this.actualNumberOfNodes) {
            this.actualNumberOfNodes = numberOfNodes;
        }
    }

    public RemoteJobManager(String scope, int numberOfNodes) throws Exception {
        this.init(scope, numberOfNodes);
    }

    public RemoteJobManager(String scope, int numberOfNodes, List<String> eprs) throws Exception {
        this.eprs = eprs;
        this.init(scope, numberOfNodes);
    }

    public boolean uploadAndExecute(String serviceClass, String serviceName, String owner, String localDir, String remoteDir, String outputDir, String script, List<String> arguments, boolean deletefiles) throws Exception {
        boolean executeAll = false;
        long t0 = System.currentTimeMillis();
        if (!this.yetuploaded) {
            ScopeProvider.instance.set(this.scope);
            IClient client = new StorageClient(serviceClass, serviceName, owner, AccessType.SHARED).getClient();
            File dir = new File(localDir);
            File[] files = dir.listFiles();
            AnalysisLogger.getLogger().debug((Object)"Start uploading");
            this.filenames = new ArrayList<String>();
            this.fileurls = new ArrayList<String>();
            for (File sfile : files) {
                String localf = sfile.getAbsolutePath();
                String filename = sfile.getName();
                String remotef = remoteDir + sfile.getName();
                client.put(true).LFile(localf).RFile(remotef);
                String url = client.getUrl().RFile(remotef);
                AnalysisLogger.getLogger().debug((Object)("URL created: " + url));
                this.filenames.add(filename);
                this.fileurls.add(url);
            }
            AnalysisLogger.getLogger().debug((Object)"Upload end");
            this.yetuploaded = true;
            this.session = ("" + UUID.randomUUID()).replace("-", "");
        }
        if (this.actualNumberOfNodes > 0) {
            AnalysisLogger.getLogger().debug((Object)("Executing script on " + this.actualNumberOfNodes + " nodes"));
            int len = arguments.size();
            ArrayList<WorkerWatcher> tasksProxies = new ArrayList<WorkerWatcher>();
            this.activeNodes = 0;
            for (int i = 0; i < this.actualNumberOfNodes; ++i) {
                String argum = "";
                if (i < len) {
                    argum = arguments.get(i);
                }
                Map<String, Object> inputs = this.generateInput(this.filenames, this.fileurls, outputDir, script, argum, i, this.scope, serviceClass, serviceName, owner, remoteDir, this.session, deletefiles);
                AnalysisLogger.getLogger().debug((Object)("-> Owner: " + owner + " ServiceClass: " + serviceClass + " ServiceName:" + serviceName + " remoteDir:" + remoteDir));
                String selectedEPR = this.eprs.get(i);
                AnalysisLogger.getLogger().debug((Object)("Launching node " + (i + 1) + " on " + selectedEPR));
                ExecutorPlugin runExecutorPlugin = new ExecutorPlugin();
                SmartExecutorPluginQuery runQuery = new SmartExecutorPluginQuery((Plugin)runExecutorPlugin);
                runQuery.addConditions(pluginName, new Tuple[0]);
                SpecificEndpointDiscoveryFilter sedf = new SpecificEndpointDiscoveryFilter(selectedEPR);
                runQuery.setEndpointDiscoveryFilter((EndpointDiscoveryFilter)sedf);
                SmartExecutorProxy proxy = (SmartExecutorProxy)new ProxyBuilderImpl((Plugin)runExecutorPlugin, (Query)runQuery, new Property[0]).build();
                LaunchParameter launchParameter = new LaunchParameter(pluginName, inputs);
                String excecutionIdentifier = proxy.launch(launchParameter);
                tasksProxies.add(new WorkerWatcher(proxy, excecutionIdentifier, AnalysisLogger.getLogger()));
                AnalysisLogger.getLogger().debug((Object)("Launching node " + (i + 1) + " OK on " + selectedEPR));
            }
            this.activeNodes = this.actualNumberOfNodes;
            AnalysisLogger.getLogger().debug((Object)"Launch Finished - Controlling Status");
            int allstatus = 0;
            this.abort = false;
            block2: while (this.activeNodes != 0 && !this.abort && !this.shutdown) {
                int nworkers = tasksProxies.size();
                int i = 0;
                while (i < nworkers) {
                    WorkerWatcher proxy = (WorkerWatcher)tasksProxies.get(i);
                    PluginState enumState = proxy.getState();
                    String state = enumState.toString();
                    AnalysisLogger.getLogger().debug((Object)("REMOTE JOB MANAGER-> STATE " + state));
                    this.abort = state == null || state.equals("FAILED") || !state.equals("DONE") && !state.equals("RUNNING");
                    boolean finished = false;
                    if (state != null) {
                        finished = state.equals("DONE");
                    }
                    if (finished) {
                        tasksProxies.remove(i);
                        ++allstatus;
                        --this.activeNodes;
                        --nworkers;
                        if (this.activeNodes == 0) {
                            continue block2;
                        }
                    } else {
                        ++i;
                    }
                    this.status = Math.min((float)allstatus / (float)this.actualNumberOfNodes * 100.0f, 95.0f);
                    if (this.abort || this.shutdown) continue block2;
                    Thread.sleep(2000L);
                }
            }
            this.activeNodes = 0;
            AnalysisLogger.getLogger().debug((Object)"All Tasks have Finished");
            if (!this.abort) {
                AnalysisLogger.getLogger().debug((Object)"All Task were successful");
            } else {
                AnalysisLogger.getLogger().debug((Object)"Tasks were NOT successful");
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"Warning: could not execute tasks: No Nodes Available!");
        }
        AnalysisLogger.getLogger().debug((Object)("Whole procedure done in " + (System.currentTimeMillis() - t0) + " ms"));
        this.status = 100.0f;
        return executeAll;
    }

    public boolean wasAborted() {
        return this.abort;
    }

    public void stop() {
        this.shutdown = true;
    }

    private List<EndpointReference> getFilteredEndpoints(String scopeString) {
        ScopeProvider.instance.set(scopeString);
        ExecutorPlugin executorPlugin = new ExecutorPlugin();
        SmartExecutorPluginQuery query = new SmartExecutorPluginQuery((Plugin)executorPlugin);
        query.addConditions(pluginName, new Tuple[0]);
        query.setServiceEndpointQueryFilter(null);
        query.setEndpointDiscoveryFilter(null);
        return query.fire();
    }

    private int findNodes(String scopeString) throws Exception {
        return this.getFilteredEndpoints(scopeString).size();
    }

    private Map<String, Object> generateInput(Object filenames, Object fileurls, String outputDir, String script, String argum, int i, String scope, String serviceClass, String serviceName, String owner, String remoteDir, String session, boolean deletefiles) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("FILE_NAMES", filenames);
        inputs.put("FILE_URLS", fileurls);
        inputs.put("OUTPUTDIR", ScriptIOWorker.toInputString(outputDir));
        inputs.put("SCRIPT", ScriptIOWorker.toInputString(script));
        inputs.put("ARGUMENTS", ScriptIOWorker.toInputString(argum));
        inputs.put("NODE_IDENTIFIER", "" + i);
        inputs.put("SCOPE", ScriptIOWorker.toInputString(scope));
        inputs.put("SERVICE_CLASS", ScriptIOWorker.toInputString(serviceClass));
        inputs.put("SERVICE_NAME", ScriptIOWorker.toInputString(serviceName));
        inputs.put("OWNER", ScriptIOWorker.toInputString(owner));
        inputs.put("REMOTEDIR", ScriptIOWorker.toInputString(remoteDir));
        inputs.put("CLEAN_CACHE", "" + deletefiles);
        return inputs;
    }
}

