/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.test.projections;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.DistanceCalculator;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;

public class GeolocateCountry {
    static String faoreport = "FAO data.csv";
    static HashMap<String, String> centroids = new HashMap();
    static HashMap<String, String> capitals = new HashMap();

    public static void main1(String[] args) throws Exception {
        BufferedReader fr = new BufferedReader(new FileReader(new File(faoreport)));
        String line = fr.readLine();
        long counter = 0L;
        while (line != null) {
            String[] split = line.split("\t");
            String country = split[17];
            String x = split[5];
            String y = split[4];
            if (country.contains("Russia")) break;
            if (++counter % 500000L == 0L) {
                System.out.println("Country:" + country + " " + x + "," + y);
            }
            line = fr.readLine();
        }
        fr.close();
    }

    public static void main2(String[] args) throws Exception {
        BufferedReader fr = new BufferedReader(new FileReader(new File(faoreport)));
        String line = fr.readLine();
        GeolocateCountry.parseCentroidsFile();
        GeolocateCountry.parseWorldCapitalsFile();
        line = fr.readLine();
        HashMap<String, String> yetDone = new HashMap<String, String>();
        while (line != null) {
            List p = Transformations.parseCVSString((String)line, (String)",");
            String country = (String)p.get(1);
            String suggestion = (String)yetDone.get(country);
            if (suggestion == null) {
                suggestion = GeolocateCountry.getCentroid(country, capitals, 0.6);
                if (suggestion.length() == 0) {
                    suggestion = GeolocateCountry.getCentroid(country, centroids, 0.3);
                }
                yetDone.put(country, suggestion);
            }
            System.out.println(line + "," + suggestion);
            line = fr.readLine();
        }
        fr.close();
    }

    public static void main(String[] args) throws Exception {
        String file = "LargeTS.csv";
        System.out.println("Processing");
        List<String> countries = GeolocateCountry.geoLocateCountries(1, file);
        System.out.println("Dumping");
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File("LargeTsGeo.csv")));
        for (String country : countries) {
            bw.write(country + "\n");
        }
        bw.close();
        System.out.println("Done");
    }

    public static List<String> geoLocateCountries(int idxCountryColumn, String file) throws Exception {
        BufferedReader fr = new BufferedReader(new FileReader(new File(file)));
        String line = fr.readLine();
        GeolocateCountry.parseCentroidsFile();
        GeolocateCountry.parseWorldCapitalsFile();
        line = fr.readLine();
        ArrayList<String> yetDone = new ArrayList<String>();
        while (line != null) {
            List p = Transformations.parseCVSString((String)line, (String)",");
            String country = (String)p.get(idxCountryColumn);
            String suggestion = null;
            suggestion = GeolocateCountry.getCentroid(country, capitals, 0.6);
            if (suggestion.length() == 0) {
                suggestion = GeolocateCountry.getCentroid(country, centroids, 0.3);
            }
            if (suggestion == null || suggestion.length() == 0) {
                suggestion = ",,,,";
            }
            String outstring = country + "," + suggestion;
            yetDone.add(outstring);
            line = fr.readLine();
        }
        fr.close();
        return yetDone;
    }

    public static Map<String, String> geoLocateCountriesWithNoDuplicates(int idxCountryColumn, String file) throws Exception {
        BufferedReader fr = new BufferedReader(new FileReader(new File(file)));
        String line = fr.readLine();
        GeolocateCountry.parseCentroidsFile();
        GeolocateCountry.parseWorldCapitalsFile();
        line = fr.readLine();
        LinkedHashMap<String, String> yetDone = new LinkedHashMap<String, String>();
        while (line != null) {
            List p = Transformations.parseCVSString((String)line, (String)",");
            String country = (String)p.get(idxCountryColumn);
            String suggestion = yetDone.get(country);
            if (suggestion == null) {
                suggestion = GeolocateCountry.getCentroid(country, capitals, 0.6);
                if (suggestion.length() == 0) {
                    suggestion = GeolocateCountry.getCentroid(country, centroids, 0.3);
                }
                yetDone.put(country, suggestion);
            }
            System.out.println(line + "," + suggestion);
            line = fr.readLine();
        }
        fr.close();
        return yetDone;
    }

    public static void parseCentroidsFile() throws Exception {
        BufferedReader fr = new BufferedReader(new FileReader(new File("countriescentroids.txt")));
        String line = fr.readLine();
        while (line != null) {
            String[] elems = line.split(",");
            String x = elems[0];
            String y = elems[1];
            String cntry_name = elems[2];
            centroids.put(cntry_name, x + "," + y);
            line = fr.readLine();
        }
        fr.close();
    }

    public static void parseWorldCapitalsFile() throws Exception {
        BufferedReader fr = new BufferedReader(new FileReader(new File("country-capitals.csv")));
        String line = fr.readLine();
        while (line != null) {
            String[] elems = line.split(",");
            String x = elems[3];
            String y = elems[2];
            String cntry_name = elems[0];
            capitals.put(cntry_name, x + "," + y);
            line = fr.readLine();
        }
        fr.close();
    }

    public static String getCentroid(String country, HashMap<String, String> centroids, double threshold) {
        String c = centroids.get(country);
        ArrayList<String> sb = new ArrayList<String>();
        ArrayList<Double> scores = new ArrayList<Double>();
        DistanceCalculator dc = new DistanceCalculator();
        if (c == null) {
            for (String key : centroids.keySet()) {
                Double cscore;
                double score;
                if (key.length() <= 0 || !((score = dc.CD(false, country, key, true, false)) > threshold)) continue;
                int i = 0;
                Iterator iterator = scores.iterator();
                while (iterator.hasNext() && !((cscore = (Double)iterator.next()) < score)) {
                    ++i;
                }
                sb.add(i, key + "," + centroids.get(key) + "," + MathFunctions.roundDecimal((double)score, (int)2));
                scores.add(i, score);
            }
            if (sb.size() > 0) {
                return ((String)sb.get(0)).toString();
            }
            return "";
        }
        return country + "," + c + "," + 1;
    }
}

