/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.meta;

import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.geo.meta.OGCFormatter;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.geotoolkit.metadata.iso.DefaultIdentifier;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultCitationDate;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.metadata.iso.constraint.DefaultLegalConstraints;
import org.geotoolkit.metadata.iso.distribution.DefaultDigitalTransferOptions;
import org.geotoolkit.metadata.iso.distribution.DefaultDistribution;
import org.geotoolkit.metadata.iso.distribution.DefaultFormat;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.geotoolkit.metadata.iso.identification.DefaultKeywords;
import org.geotoolkit.metadata.iso.identification.DefaultResolution;
import org.geotoolkit.metadata.iso.identification.DefaultUsage;
import org.geotoolkit.metadata.iso.lineage.DefaultLineage;
import org.geotoolkit.metadata.iso.lineage.DefaultNominalResolution;
import org.geotoolkit.metadata.iso.lineage.DefaultProcessStep;
import org.geotoolkit.metadata.iso.lineage.DefaultProcessing;
import org.geotoolkit.metadata.iso.lineage.DefaultSource;
import org.geotoolkit.metadata.iso.maintenance.DefaultMaintenanceInformation;
import org.geotoolkit.metadata.iso.quality.DefaultDataQuality;
import org.geotoolkit.metadata.iso.quality.DefaultScope;
import org.geotoolkit.metadata.iso.spatial.DefaultGeometricObjects;
import org.geotoolkit.metadata.iso.spatial.DefaultVectorSpatialRepresentation;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.xml.XML;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.lineage.NominalResolution;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.Scope;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.metadata.spatial.TopologyLevel;
import org.opengis.util.InternationalString;

public class GenericLayerMetadata {
    private String geonetworkUrl = "http://geoserver-dev2.d4science-ii.research-infrastructures.eu/geonetwork/";
    private String geoserverUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetwork/";
    private String geonetworkUser = "admin";
    private String geonetworkPwd = "admin";
    private String geonetworkGroup = "3";
    private String title = "temperature 04091217ruc.nc";
    private String layerName = "T";
    private String usageField = "Environmental enrichment";
    private String processdescription = "Maps publication";
    private String usageLimitations = "Not for commercial scopes";
    private Date sourceGenerationDate = new Date(System.currentTimeMillis());
    private String categoryTypes = "_BIOTA_";
    private String contactInfo = "support@d4science.org";
    private String abstractField = "";
    private String purpose = "Maps publication";
    private String author = "D4Science";
    private double res = 0.5;
    private double xLL = -180.0;
    private double xRU = 180.0;
    private double yLL = -85.5;
    private double yRU = 85.5;
    private HashSet<String> customTopics;
    private Date startDate;
    private Date endDate;

    public void setCustomTopics(String ... topics) {
        this.customTopics = new HashSet();
        for (String topic : topics) {
            this.customTopics.add(topic);
        }
    }

    public HashSet<String> getCustomTopics() {
        return this.customTopics;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getGeonetworkUrl() {
        return this.geonetworkUrl;
    }

    public void setGeonetworkUrl(String geonetworkUrl) {
        this.geonetworkUrl = geonetworkUrl;
    }

    public String getGeonetworkUser() {
        return this.geonetworkUser;
    }

    public void setGeonetworkUser(String geonetworkUser) {
        this.geonetworkUser = geonetworkUser;
    }

    public String getGeonetworkPwd() {
        return this.geonetworkPwd;
    }

    public void setGeonetworkPwd(String geonetworkPwd) {
        this.geonetworkPwd = geonetworkPwd;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getUsageField() {
        return this.usageField;
    }

    public void setUsageField(String usageField) {
        this.usageField = usageField;
    }

    public String getProcessdescription() {
        return this.processdescription;
    }

    public void setProcessdescription(String processdescription) {
        this.processdescription = processdescription;
    }

    public String getUsageLimitations() {
        return this.usageLimitations;
    }

    public void setUsageLimitations(String usageLimitations) {
        this.usageLimitations = usageLimitations;
    }

    public Date getSourceGenerationDate() {
        return this.sourceGenerationDate;
    }

    public void setSourceGenerationDate(Date sourceGenerationDate) {
        this.sourceGenerationDate = sourceGenerationDate;
    }

    public String getCategoryTypes() {
        return this.categoryTypes;
    }

    public void setCategoryTypes(String categoryTypes) {
        this.categoryTypes = categoryTypes;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getAbstractField() {
        return this.abstractField;
    }

    public void setAbstractField(String abstractField) {
        this.abstractField = abstractField;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public double getResolution() {
        return this.res;
    }

    public void setResolution(double res) {
        this.res = res;
    }

    public double getXLeftLow() {
        return this.xLL;
    }

    public void setXLeftLow(double xLL) {
        this.xLL = xLL;
    }

    public double getXRightUpper() {
        return this.xRU;
    }

    public void setXRightUpper(double xRU) {
        this.xRU = xRU;
    }

    public double getYLeftLow() {
        return this.yLL;
    }

    public void setYLeftLow(double yLL) {
        this.yLL = yLL;
    }

    public double getYRightUpper() {
        return this.yRU;
    }

    public void setYRightUpper(double yRU) {
        this.yRU = yRU;
    }

    public String getGeoserverUrl() {
        return this.geoserverUrl;
    }

    public void setGeoserverUrl(String geoserverUrl) {
        this.geoserverUrl = geoserverUrl;
    }

    public String getGeonetworkGroup() {
        return this.geonetworkGroup;
    }

    public void setGeonetworkGroup(String geonetworkGroup) {
        this.geonetworkGroup = geonetworkGroup;
    }

    public static File meta2File(Metadata meta) throws IOException, JAXBException {
        File temp = File.createTempFile("meta", ".xml");
        FileWriter writer = new FileWriter(temp);
        writer.write(XML.marshal((Object)meta));
        writer.close();
        return temp;
    }

    public void insertMetaData() throws Exception {
        ArrayList<String> layerUris = new ArrayList<String>();
        layerUris.add(OGCFormatter.getWmsUrl(this.geoserverUrl, this.layerName, null, OGCFormatter.buildBoundingBox(this.xLL, this.yLL, this.xRU, this.yRU)));
        layerUris.add(OGCFormatter.getWfsUrl(this.geoserverUrl, this.layerName, OGCFormatter.buildBoundingBox(this.xLL, this.yLL, this.xRU, this.yRU), 0, "json"));
        layerUris.add(OGCFormatter.getWcsUrl(this.geoserverUrl, this.layerName, OGCFormatter.buildBoundingBox(this.xLL, this.yLL, this.xRU, this.yRU)));
        HashMap descriptiveKeyWords = new HashMap();
        HashSet<String> keySet = new HashSet<String>();
        keySet.add("D4Science");
        if (this.customTopics != null) {
            keySet.addAll(this.customTopics);
        }
        descriptiveKeyWords.put(KeywordType.THEME, keySet);
        if (this.startDate != null) {
            HashSet<String> temporalkeySet = new HashSet<String>();
            temporalkeySet.add(this.startDate.toString());
            if (!this.endDate.equals(this.startDate)) {
                temporalkeySet.add(this.endDate.toString());
            }
            descriptiveKeyWords.put(KeywordType.TEMPORAL, temporalkeySet);
        }
        DefaultResponsibleParty party = new DefaultResponsibleParty();
        party.setIndividualName(this.author);
        DefaultContact contact = new DefaultContact();
        contact.setContactInstructions((InternationalString)new DefaultInternationalString(this.contactInfo));
        party.setContactInfo((Contact)contact);
        party.setRole(Role.ORIGINATOR);
        DefaultCitation citation = new DefaultCitation();
        citation.setTitle((InternationalString)new DefaultInternationalString(this.title));
        ArrayList<DefaultCitationDate> citDates = new ArrayList<DefaultCitationDate>();
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.CREATION));
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.PUBLICATION));
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.REVISION));
        citation.setDates(citDates);
        ArrayList<DefaultInternationalString> citAltTitle = new ArrayList<DefaultInternationalString>();
        citAltTitle.add(new DefaultInternationalString(this.title));
        citation.setAlternateTitles(citAltTitle);
        citation.setEditionDate(this.sourceGenerationDate);
        citation.getPresentationForms().add(PresentationForm.MAP_DIGITAL);
        ArrayList<DefaultKeywords> keywordslist = new ArrayList<DefaultKeywords>();
        for (Map.Entry entry : descriptiveKeyWords.entrySet()) {
            DefaultKeywords keywords = new DefaultKeywords();
            for (String key : (HashSet)entry.getValue()) {
                keywords.getKeywords().add(new DefaultInternationalString(key));
            }
            keywords.setType((KeywordType)entry.getKey());
            DefaultCitation thesaurus = new DefaultCitation();
            thesaurus.setTitle((InternationalString)new DefaultInternationalString("General"));
            thesaurus.setDates(citDates);
            keywords.setThesaurusName((Citation)thesaurus);
            keywordslist.add(keywords);
        }
        DefaultUsage usage = new DefaultUsage();
        usage.setSpecificUsage((InternationalString)new DefaultInternationalString(this.usageField));
        usage.setUsageDate(this.sourceGenerationDate);
        usage.setUserDeterminedLimitations((InternationalString)new DefaultInternationalString(this.usageLimitations));
        usage.setUserContactInfo(new ArrayList<DefaultResponsibleParty>(Arrays.asList(party)));
        ArrayList<DefaultUsage> usages = new ArrayList<DefaultUsage>(Arrays.asList(usage));
        List<TopicCategory> categories = GenericLayerMetadata.guessTopicCategory(this.categoryTypes);
        AnalysisLogger.getLogger().debug((Object)("Guessed Topics: " + categories));
        DefaultGeometricObjects geoObjs = new DefaultGeometricObjects();
        geoObjs.setGeometricObjectType(GeometricObjectType.COMPLEX);
        DefaultVectorSpatialRepresentation spatial = new DefaultVectorSpatialRepresentation();
        spatial.setTopologyLevel(TopologyLevel.GEOMETRY_ONLY);
        spatial.getGeometricObjects().add(geoObjs);
        DefaultExtent extent = new DefaultExtent();
        extent.setGeographicElements(Collections.singleton(new DefaultGeographicBoundingBox(this.xLL, this.xRU, this.yLL, this.yRU)));
        extent.setDescription((InternationalString)new DefaultInternationalString("Bounding box"));
        extent.freeze();
        DefaultNominalResolution resolution = new DefaultNominalResolution();
        resolution.setGroundResolution(Double.valueOf(this.res));
        resolution.setScanningResolution(Double.valueOf(this.res));
        DefaultResolution dres = new DefaultResolution();
        dres.setDistance(Double.valueOf(this.res));
        DefaultDistribution distribution = new DefaultDistribution();
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        for (String uri : layerUris) {
            DefaultOnlineResource onlineresource = new DefaultOnlineResource(new URI(uri));
            transferOptions.getOnLines().add(onlineresource);
        }
        distribution.getTransferOptions().add(transferOptions);
        DefaultFormat format1 = new DefaultFormat();
        format1.setName((InternationalString)new DefaultInternationalString("WMS"));
        format1.setVersion((InternationalString)new DefaultInternationalString("1.1.0"));
        DefaultFormat format2 = new DefaultFormat();
        format2.setName((InternationalString)new DefaultInternationalString("WFS"));
        format2.setVersion((InternationalString)new DefaultInternationalString("1.1.0"));
        DefaultFormat format3 = new DefaultFormat();
        format3.setName((InternationalString)new DefaultInternationalString("WCS"));
        format3.setVersion((InternationalString)new DefaultInternationalString("1.0.0"));
        distribution.setDistributionFormats(new ArrayList<DefaultFormat>(Arrays.asList(format1, format2, format3)));
        DefaultLegalConstraints constraints = new DefaultLegalConstraints();
        constraints.getUseLimitations().add(new DefaultInternationalString("Licensed"));
        constraints.getAccessConstraints().add(Restriction.LICENSE);
        constraints.getUseConstraints().add(Restriction.LICENSE);
        DefaultDataQuality processQuality = new DefaultDataQuality();
        DefaultCitation sourceCitation = new DefaultCitation();
        sourceCitation.setTitle((InternationalString)new DefaultInternationalString(this.title));
        sourceCitation.getDates().add(new DefaultCitationDate(this.sourceGenerationDate, DateType.CREATION));
        sourceCitation.getIdentifiers().add(new DefaultIdentifier(this.categoryTypes));
        DefaultSource source = new DefaultSource();
        source.setResolution((NominalResolution)resolution);
        source.setDescription((InternationalString)new DefaultInternationalString(this.title));
        source.setSourceCitation((Citation)sourceCitation);
        DefaultProcessStep preprocessStep = new DefaultProcessStep();
        DefaultProcessStep processStep = new DefaultProcessStep((ProcessStep)preprocessStep);
        DefaultProcessing processing = new DefaultProcessing();
        processing.setSoftwareReferences(new ArrayList<DefaultCitation>(Arrays.asList(sourceCitation)));
        processStep.setDescription((InternationalString)new DefaultInternationalString(this.processdescription));
        DefaultLineage processLineage = new DefaultLineage();
        processLineage.setProcessSteps(new ArrayList<DefaultProcessStep>(Arrays.asList(processStep)));
        processQuality.setLineage((Lineage)processLineage);
        processQuality.setScope((Scope)new DefaultScope(ScopeCode.DATASET));
        DefaultDataIdentification ident = new DefaultDataIdentification();
        ident.setCitation((Citation)citation);
        ident.setAbstract((InternationalString)new DefaultInternationalString(this.abstractField));
        ident.setPurpose((InternationalString)new DefaultInternationalString(this.purpose));
        ident.getResourceMaintenances().add(new DefaultMaintenanceInformation(MaintenanceFrequency.AS_NEEDED));
        ident.setDescriptiveKeywords(keywordslist);
        ident.setTopicCategories(categories);
        ident.setResourceSpecificUsages(usages);
        ident.setExtents(new ArrayList<DefaultExtent>(Arrays.asList(extent)));
        ident.setSpatialRepresentationTypes(new ArrayList<SpatialRepresentationType>(Arrays.asList(SpatialRepresentationType.GRID)));
        ident.setSpatialResolutions(new ArrayList<DefaultResolution>(Arrays.asList(dres)));
        ident.setLanguages(new ArrayList<Locale>(Arrays.asList(Locale.ENGLISH)));
        DefaultMetadata meta = new DefaultMetadata((ResponsibleParty)party, this.sourceGenerationDate, (Identification)ident);
        meta.getSpatialRepresentationInfo().add(spatial);
        meta.setDistributionInfo((Distribution)distribution);
        meta.getMetadataConstraints().add(constraints);
        meta.getDataQualityInfo().add(processQuality);
        meta.setLanguage(Locale.ENGLISH);
        GeoNetworkAdministration readerScope = GeoNetwork.get();
        readerScope.login(LoginLevel.SCOPE);
        GNInsertConfiguration configuration = readerScope.getCurrentUserConfiguration("datasets", "_none_");
        readerScope.insertAndPromoteMetadata(configuration, (Metadata)meta);
    }

    public void customMetaDataInsert(String[] urls, String[] protocols) throws Exception {
        this.customMetaDataInsert(urls, protocols, true);
    }

    public void customMetaDataInsert(String[] urls, String[] protocols, boolean isprivate) throws Exception {
        ArrayList<String> layerUris = new ArrayList<String>();
        for (int i = 0; i < urls.length; ++i) {
            layerUris.add(urls[i]);
        }
        HashMap descriptiveKeyWords = new HashMap();
        HashSet<String> keySet = new HashSet<String>();
        if (this.customTopics != null) {
            keySet.addAll(this.customTopics);
        }
        descriptiveKeyWords.put(KeywordType.THEME, keySet);
        if (this.startDate != null) {
            HashSet<String> temporalkeySet = new HashSet<String>();
            temporalkeySet.add(this.startDate.toString());
            if (!this.endDate.equals(this.startDate)) {
                temporalkeySet.add(this.endDate.toString());
            }
            descriptiveKeyWords.put(KeywordType.TEMPORAL, temporalkeySet);
        }
        DefaultResponsibleParty party = new DefaultResponsibleParty();
        party.setIndividualName(this.author);
        DefaultContact contact = new DefaultContact();
        contact.setContactInstructions((InternationalString)new DefaultInternationalString(this.contactInfo));
        party.setContactInfo((Contact)contact);
        party.setRole(Role.ORIGINATOR);
        DefaultCitation citation = new DefaultCitation();
        citation.setTitle((InternationalString)new DefaultInternationalString(this.title));
        ArrayList<DefaultCitationDate> citDates = new ArrayList<DefaultCitationDate>();
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.CREATION));
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.PUBLICATION));
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.REVISION));
        citation.setDates(citDates);
        ArrayList<DefaultInternationalString> citAltTitle = new ArrayList<DefaultInternationalString>();
        citAltTitle.add(new DefaultInternationalString(this.title));
        citation.setAlternateTitles(citAltTitle);
        citation.setEditionDate(this.sourceGenerationDate);
        citation.getPresentationForms().add(PresentationForm.MAP_DIGITAL);
        ArrayList<DefaultKeywords> keywordslist = new ArrayList<DefaultKeywords>();
        for (Map.Entry entry : descriptiveKeyWords.entrySet()) {
            DefaultKeywords keywords = new DefaultKeywords();
            for (String key : (HashSet)entry.getValue()) {
                keywords.getKeywords().add(new DefaultInternationalString(key));
            }
            keywords.setType((KeywordType)entry.getKey());
            DefaultCitation thesaurus = new DefaultCitation();
            thesaurus.setTitle((InternationalString)new DefaultInternationalString("General"));
            thesaurus.setDates(citDates);
            keywords.setThesaurusName((Citation)thesaurus);
            keywordslist.add(keywords);
        }
        DefaultUsage usage = new DefaultUsage();
        usage.setSpecificUsage((InternationalString)new DefaultInternationalString(this.usageField));
        usage.setUsageDate(this.sourceGenerationDate);
        usage.setUserDeterminedLimitations((InternationalString)new DefaultInternationalString(this.usageLimitations));
        usage.setUserContactInfo(new ArrayList<DefaultResponsibleParty>(Arrays.asList(party)));
        ArrayList<DefaultUsage> usages = new ArrayList<DefaultUsage>(Arrays.asList(usage));
        List<TopicCategory> categories = GenericLayerMetadata.guessTopicCategory(this.categoryTypes);
        AnalysisLogger.getLogger().debug((Object)("Guessed Topics: " + categories));
        DefaultGeometricObjects geoObjs = new DefaultGeometricObjects();
        geoObjs.setGeometricObjectType(GeometricObjectType.COMPLEX);
        DefaultVectorSpatialRepresentation spatial = new DefaultVectorSpatialRepresentation();
        spatial.setTopologyLevel(TopologyLevel.GEOMETRY_ONLY);
        spatial.getGeometricObjects().add(geoObjs);
        DefaultExtent extent = new DefaultExtent();
        extent.setGeographicElements(Collections.singleton(new DefaultGeographicBoundingBox(this.xLL, this.xRU, this.yLL, this.yRU)));
        extent.setDescription((InternationalString)new DefaultInternationalString("Bounding box"));
        extent.freeze();
        DefaultNominalResolution resolution = new DefaultNominalResolution();
        resolution.setGroundResolution(Double.valueOf(this.res));
        resolution.setScanningResolution(Double.valueOf(this.res));
        DefaultResolution dres = new DefaultResolution();
        dres.setDistance(Double.valueOf(this.res));
        DefaultDistribution distribution = new DefaultDistribution();
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        for (String uri : layerUris) {
            DefaultOnlineResource onlineres = new DefaultOnlineResource(new URI(uri));
            String url = onlineres.getLinkage().toURL().toString();
            String estdescription = GenericLayerMetadata.getDescription(url);
            String estProtocol = GenericLayerMetadata.getProtocol(url);
            String estName = GenericLayerMetadata.getName(this.title, this.abstractField, estProtocol, url);
            AnalysisLogger.getLogger().debug((Object)("URL:" + url + "\nDescription:" + estdescription + "\nName:" + estName + "\nProtocol:" + estProtocol));
            onlineres.setDescription((InternationalString)new DefaultInternationalString(estdescription));
            onlineres.setName(estName);
            onlineres.setProtocol(estProtocol);
            transferOptions.getOnLines().add(new DefaultOnlineResource(new URI(uri)));
        }
        distribution.getTransferOptions().add(transferOptions);
        DefaultFormat[] formats = new DefaultFormat[protocols.length];
        for (int i = 0; i < protocols.length; ++i) {
            DefaultFormat format = new DefaultFormat();
            format.setName((InternationalString)new DefaultInternationalString(protocols[i]));
            format.setVersion((InternationalString)new DefaultInternationalString("1.0.0"));
            formats[i] = format;
        }
        distribution.setDistributionFormats(new ArrayList<DefaultFormat>(Arrays.asList(formats)));
        DefaultLegalConstraints constraints = new DefaultLegalConstraints();
        constraints.getUseLimitations().add(new DefaultInternationalString("Licensed"));
        constraints.getAccessConstraints().add(Restriction.LICENSE);
        constraints.getUseConstraints().add(Restriction.LICENSE);
        DefaultDataQuality processQuality = new DefaultDataQuality();
        DefaultCitation sourceCitation = new DefaultCitation();
        sourceCitation.setTitle((InternationalString)new DefaultInternationalString(this.title));
        sourceCitation.getDates().add(new DefaultCitationDate(this.sourceGenerationDate, DateType.CREATION));
        sourceCitation.getIdentifiers().add(new DefaultIdentifier(this.categoryTypes));
        DefaultSource source = new DefaultSource();
        source.setResolution((NominalResolution)resolution);
        source.setDescription((InternationalString)new DefaultInternationalString(this.title));
        source.setSourceCitation((Citation)sourceCitation);
        DefaultProcessStep preprocessStep = new DefaultProcessStep();
        DefaultProcessStep processStep = new DefaultProcessStep((ProcessStep)preprocessStep);
        DefaultProcessing processing = new DefaultProcessing();
        processing.setSoftwareReferences(new ArrayList<DefaultCitation>(Arrays.asList(sourceCitation)));
        processStep.setDescription((InternationalString)new DefaultInternationalString(this.processdescription));
        DefaultLineage processLineage = new DefaultLineage();
        processLineage.setProcessSteps(new ArrayList<DefaultProcessStep>(Arrays.asList(processStep)));
        processQuality.setLineage((Lineage)processLineage);
        processQuality.setScope((Scope)new DefaultScope(ScopeCode.DATASET));
        DefaultDataIdentification ident = new DefaultDataIdentification();
        ident.setCitation((Citation)citation);
        ident.setAbstract((InternationalString)new DefaultInternationalString(this.abstractField));
        ident.setPurpose((InternationalString)new DefaultInternationalString(this.purpose));
        ident.getResourceMaintenances().add(new DefaultMaintenanceInformation(MaintenanceFrequency.AS_NEEDED));
        ident.setDescriptiveKeywords(keywordslist);
        ident.setTopicCategories(categories);
        ident.setResourceSpecificUsages(usages);
        ident.setExtents(new ArrayList<DefaultExtent>(Arrays.asList(extent)));
        ident.setSpatialRepresentationTypes(new ArrayList<SpatialRepresentationType>(Arrays.asList(SpatialRepresentationType.GRID)));
        ident.setSpatialResolutions(new ArrayList<DefaultResolution>(Arrays.asList(dres)));
        ident.setLanguages(new ArrayList<Locale>(Arrays.asList(Locale.ENGLISH)));
        DefaultMetadata meta = new DefaultMetadata((ResponsibleParty)party, this.sourceGenerationDate, (Identification)ident);
        meta.setFileIdentifier(UUID.randomUUID().toString());
        meta.getSpatialRepresentationInfo().add(spatial);
        meta.setDistributionInfo((Distribution)distribution);
        meta.getMetadataConstraints().add(constraints);
        meta.getDataQualityInfo().add(processQuality);
        meta.setLanguage(Locale.ENGLISH);
        GeoNetworkAdministration readerScope = GeoNetwork.get();
        if (isprivate) {
            readerScope.login(LoginLevel.PRIVATE);
        } else {
            readerScope.login(LoginLevel.SCOPE);
        }
        GNInsertConfiguration configuration = readerScope.getCurrentUserConfiguration("datasets", "_none_");
        if (isprivate) {
            readerScope.insertMetadata(configuration, (Metadata)meta);
        } else {
            readerScope.insertAndPromoteMetadata(configuration, (Metadata)meta);
        }
    }

    public static List<TopicCategory> guessTopicCategory(String refString) {
        String searcher = refString.toLowerCase();
        ArrayList<TopicCategory> categories = new ArrayList<TopicCategory>();
        for (TopicCategory topic : TopicCategory.values()) {
            if (!searcher.contains("_" + topic.name().toLowerCase() + "_")) continue;
            categories.add(topic);
        }
        return categories;
    }

    public Metadata createBasicMeta(String[] urls, String[] protocols) throws Exception {
        ArrayList<String> layerUris = new ArrayList<String>();
        for (int i = 0; i < urls.length; ++i) {
            layerUris.add(urls[i].trim());
        }
        HashMap descriptiveKeyWords = new HashMap();
        HashSet<String> keySet = new HashSet<String>();
        if (this.customTopics != null) {
            keySet.addAll(this.customTopics);
        }
        descriptiveKeyWords.put(KeywordType.THEME, keySet);
        if (this.startDate != null) {
            HashSet<String> temporalkeySet = new HashSet<String>();
            temporalkeySet.add(this.startDate.toString());
            if (!this.endDate.equals(this.startDate)) {
                temporalkeySet.add(this.endDate.toString());
            }
            descriptiveKeyWords.put(KeywordType.TEMPORAL, temporalkeySet);
        }
        DefaultResponsibleParty party = new DefaultResponsibleParty();
        party.setIndividualName(this.author);
        DefaultContact contact = new DefaultContact();
        contact.setContactInstructions((InternationalString)new DefaultInternationalString(this.contactInfo));
        party.setContactInfo((Contact)contact);
        party.setRole(Role.ORIGINATOR);
        DefaultCitation citation = new DefaultCitation();
        citation.setTitle((InternationalString)new DefaultInternationalString(this.title));
        ArrayList<DefaultCitationDate> citDates = new ArrayList<DefaultCitationDate>();
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.CREATION));
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.PUBLICATION));
        citDates.add(new DefaultCitationDate(this.sourceGenerationDate, DateType.REVISION));
        citation.setDates(citDates);
        ArrayList<DefaultInternationalString> citAltTitle = new ArrayList<DefaultInternationalString>();
        citAltTitle.add(new DefaultInternationalString(this.title));
        citation.setAlternateTitles(citAltTitle);
        citation.setEditionDate(this.sourceGenerationDate);
        citation.getPresentationForms().add(PresentationForm.MAP_DIGITAL);
        ArrayList<DefaultKeywords> keywordslist = new ArrayList<DefaultKeywords>();
        for (Map.Entry entry : descriptiveKeyWords.entrySet()) {
            DefaultKeywords keywords = new DefaultKeywords();
            for (String key : (HashSet)entry.getValue()) {
                keywords.getKeywords().add(new DefaultInternationalString(key));
            }
            keywords.setType((KeywordType)entry.getKey());
            DefaultCitation thesaurus = new DefaultCitation();
            thesaurus.setTitle((InternationalString)new DefaultInternationalString("General"));
            thesaurus.setDates(citDates);
            keywords.setThesaurusName((Citation)thesaurus);
            keywordslist.add(keywords);
        }
        DefaultUsage usage = new DefaultUsage();
        usage.setSpecificUsage((InternationalString)new DefaultInternationalString(this.usageField));
        usage.setUsageDate(this.sourceGenerationDate);
        usage.setUserDeterminedLimitations((InternationalString)new DefaultInternationalString(this.usageLimitations));
        usage.setUserContactInfo(new ArrayList<DefaultResponsibleParty>(Arrays.asList(party)));
        ArrayList<DefaultUsage> usages = new ArrayList<DefaultUsage>(Arrays.asList(usage));
        List<TopicCategory> categories = GenericLayerMetadata.guessTopicCategory(this.categoryTypes);
        AnalysisLogger.getLogger().debug((Object)("Guessed Topics: " + categories));
        DefaultGeometricObjects geoObjs = new DefaultGeometricObjects();
        geoObjs.setGeometricObjectType(GeometricObjectType.COMPLEX);
        DefaultVectorSpatialRepresentation spatial = new DefaultVectorSpatialRepresentation();
        spatial.setTopologyLevel(TopologyLevel.GEOMETRY_ONLY);
        spatial.getGeometricObjects().add(geoObjs);
        DefaultExtent extent = new DefaultExtent();
        extent.setGeographicElements(Collections.singleton(new DefaultGeographicBoundingBox(this.xLL, this.xRU, this.yLL, this.yRU)));
        extent.setDescription((InternationalString)new DefaultInternationalString("Bounding box"));
        extent.freeze();
        DefaultNominalResolution resolution = new DefaultNominalResolution();
        resolution.setGroundResolution(Double.valueOf(this.res));
        resolution.setScanningResolution(Double.valueOf(this.res));
        DefaultResolution dres = new DefaultResolution();
        dres.setDistance(Double.valueOf(this.res));
        DefaultDistribution distribution = new DefaultDistribution();
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        for (String uri : layerUris) {
            transferOptions.getOnLines().add(new DefaultOnlineResource(new URI(uri)));
        }
        distribution.getTransferOptions().add(transferOptions);
        DefaultFormat[] formats = new DefaultFormat[protocols.length];
        for (int i = 0; i < protocols.length; ++i) {
            DefaultFormat format = new DefaultFormat();
            format.setName((InternationalString)new DefaultInternationalString(protocols[i]));
            format.setVersion((InternationalString)new DefaultInternationalString("1.0.0"));
            formats[i] = format;
        }
        distribution.setDistributionFormats(new ArrayList<DefaultFormat>(Arrays.asList(formats)));
        DefaultLegalConstraints constraints = new DefaultLegalConstraints();
        constraints.getUseLimitations().add(new DefaultInternationalString("Licensed"));
        constraints.getAccessConstraints().add(Restriction.LICENSE);
        constraints.getUseConstraints().add(Restriction.LICENSE);
        DefaultDataQuality processQuality = new DefaultDataQuality();
        DefaultCitation sourceCitation = new DefaultCitation();
        sourceCitation.setTitle((InternationalString)new DefaultInternationalString(this.title));
        sourceCitation.getDates().add(new DefaultCitationDate(this.sourceGenerationDate, DateType.CREATION));
        sourceCitation.getIdentifiers().add(new DefaultIdentifier(this.categoryTypes));
        DefaultSource source = new DefaultSource();
        source.setResolution((NominalResolution)resolution);
        source.setDescription((InternationalString)new DefaultInternationalString(this.title));
        source.setSourceCitation((Citation)sourceCitation);
        DefaultProcessStep preprocessStep = new DefaultProcessStep();
        DefaultProcessStep processStep = new DefaultProcessStep((ProcessStep)preprocessStep);
        DefaultProcessing processing = new DefaultProcessing();
        processing.setSoftwareReferences(new ArrayList<DefaultCitation>(Arrays.asList(sourceCitation)));
        processStep.setDescription((InternationalString)new DefaultInternationalString(this.processdescription));
        DefaultLineage processLineage = new DefaultLineage();
        processLineage.setProcessSteps(new ArrayList<DefaultProcessStep>(Arrays.asList(processStep)));
        processQuality.setLineage((Lineage)processLineage);
        processQuality.setScope((Scope)new DefaultScope(ScopeCode.DATASET));
        DefaultDataIdentification ident = new DefaultDataIdentification();
        ident.setCitation((Citation)citation);
        ident.setAbstract((InternationalString)new DefaultInternationalString(this.abstractField));
        ident.setPurpose((InternationalString)new DefaultInternationalString(this.purpose));
        ident.getResourceMaintenances().add(new DefaultMaintenanceInformation(MaintenanceFrequency.AS_NEEDED));
        ident.setDescriptiveKeywords(keywordslist);
        ident.setTopicCategories(categories);
        ident.setResourceSpecificUsages(usages);
        ident.setExtents(new ArrayList<DefaultExtent>(Arrays.asList(extent)));
        ident.setSpatialRepresentationTypes(new ArrayList<SpatialRepresentationType>(Arrays.asList(SpatialRepresentationType.GRID)));
        ident.setSpatialResolutions(new ArrayList<DefaultResolution>(Arrays.asList(dres)));
        ident.setLanguages(new ArrayList<Locale>(Arrays.asList(Locale.ENGLISH)));
        DefaultMetadata meta = new DefaultMetadata((ResponsibleParty)party, this.sourceGenerationDate, (Identification)ident);
        meta.getSpatialRepresentationInfo().add(spatial);
        meta.setDistributionInfo((Distribution)distribution);
        meta.getMetadataConstraints().add(constraints);
        meta.getDataQualityInfo().add(processQuality);
        meta.setLanguage(Locale.ENGLISH);
        return meta;
    }

    public static String getProtocol(String url) {
        if (url.toLowerCase().contains("service=wfs")) {
            return "OGC:WFS-1.1.0-http-get-feature";
        }
        if (url.toLowerCase().contains("service=wms")) {
            return "OGC:WMS-1.3.0-http-get-map";
        }
        if (url.toLowerCase().contains("service=wcs")) {
            return "OGC:WCS-1.0.0-http-get-coverage";
        }
        if (url.toLowerCase().contains("/dodsC")) {
            return "OGC:OPeNDAP-2.0.0";
        }
        return "WWW:LINK-1.0-http--link";
    }

    public static String getDescription(String url) {
        if (url.toLowerCase().contains("service=wfs")) {
            return "GIS data (WFS - JSON)";
        }
        if (url.toLowerCase().contains("service=wms")) {
            if (url.toLowerCase().contains("openlayers")) {
                return "GIS data (WMS - OpenLayers)";
            }
            return "GIS data (WMS)";
        }
        if (url.toLowerCase().contains("service=wcs")) {
            return "GIS data (WCS - Geotiff)";
        }
        if (url.toLowerCase().contains("/dodsc")) {
            return "GIS data (OPenNDAP - NetCDF)";
        }
        return "Direct HTTP link";
    }

    public static String getName(String title, String abstractTitle, String protocol, String url) {
        try {
            if (abstractTitle.matches(".+: ")) {
                String variablename = title.substring(title.indexOf(":"));
                AnalysisLogger.getLogger().debug((Object)("detected variable " + variablename));
                return variablename;
            }
            if (url.contains("catalog.xml")) {
                return "Catalogue";
            }
            if (protocol.equals("WWW:LINK-1.0-http--link") || protocol.equals("OGC:OPeNDAP-2.0.0")) {
                int slash = url.lastIndexOf("/");
                if (slash > 0) {
                    String file = url.substring(slash + 1);
                    if (file.trim().length() > 0 && file.contains(".")) {
                        return file;
                    }
                    return "Direct link to resource";
                }
                return "Direct link to resource";
            }
            int check = -1;
            String checker = "";
            if (protocol.equals("OGC:WMS-1.3.0-http-get-map")) {
                checker = "layers=";
            } else if (protocol.equals("OGC:WFS-1.0.0-http-get-feature")) {
                checker = "typename=";
            } else if (protocol.equals("OGC:WCS-1.0.0-http-get-coverage")) {
                checker = "coverage=";
            }
            check = url.toLowerCase().indexOf(checker);
            if (check > 0) {
                String cutUrl = url.substring(check + checker.length());
                int end = cutUrl.indexOf("&");
                String layerName = cutUrl;
                if (end > -1) {
                    layerName = cutUrl.substring(0, end);
                }
                int column = -1;
                column = layerName.indexOf(":");
                if (column > 0) {
                    layerName = layerName.substring(column + 1);
                }
                AnalysisLogger.getLogger().debug((Object)("Layer Name: " + layerName));
                return layerName;
            }
            return title;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "LINK";
        }
    }
}

