/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geothermal;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.geo.algorithms.XYExtraction;
import org.hibernate.SessionFactory;
import org.jfree.chart.JFreeChart;

public abstract class AbstractProcess
implements Transducerer {
    static String geothermalData = "GeothermalManagementArea_ERANET";
    String featuresTable = "gth" + UUID.randomUUID().toString().replace("_", "").replace("-", "");
    String getTable = "select distinct   f_NAME,f_AREA,f_MWe_1990,f_MWth_1995,f_H_TJy_1995,f_MWe_1995,f_MWth_2000,f_H_TJy_2000,f_MWe_2000,f_MWth_2005,f_H_TJy_2005,f_MWe_2005,f_MWth_2010,f_H_TJy_2010,f_MWe_2010,f_MWe_2013 from " + this.featuresTable;
    AlgorithmConfiguration config;
    float status;
    public static boolean display = false;
    static String MWE = "MegaWatt Electrical";
    static String MWT = "MegaWatt Thermal";
    static String TJY = "Heat TeraJoule per Year";
    protected static String countryParam = "CountryName";
    protected static String yearStartParam = "StartYear";
    protected static String yearEndParam = "EndYear";
    public List<StatisticalType> inputs = new ArrayList<StatisticalType>();
    public HashMap<String, Image> producedImages = new HashMap();
    protected ResourceFactory resourceManager;

    protected void extractElements() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"General Processing: Extracting features ");
        this.config.setParam("Layer", geothermalData);
        this.config.setParam("Z", "0");
        this.config.setParam("TimeIndex", "0");
        this.config.setParam("BBox_LowerLeftLat", "-90");
        this.config.setParam("BBox_LowerLeftLong", "-180");
        this.config.setParam("BBox_UpperRightLat", "90");
        this.config.setParam("BBox_UpperRightLong", "180");
        this.config.setParam("XResolution", "1");
        this.config.setParam("YResolution", "1");
        this.config.setParam("OutputTableName", this.featuresTable);
        this.config.setParam("OutputTableLabel", this.featuresTable);
        XYExtraction extractor = new XYExtraction();
        extractor.setConfiguration(this.config);
        extractor.init();
        extractor.compute();
        AnalysisLogger.getLogger().debug((Object)("General Processing: All features extracted in the table: " + this.featuresTable));
    }

    abstract void initDatasets();

    abstract void fulfillDataset(String var1, String var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, int var31, int var32);

    abstract JFreeChart createChartForMWE();

    abstract JFreeChart createChartForMWT();

    abstract JFreeChart createChartForTJY();

    abstract void renderChartForMWE();

    abstract void renderChartForMWT();

    abstract void renderChartForTJY();

    public void compute() throws Exception {
        SessionFactory session = null;
        try {
            this.extractElements();
            this.status = 30.0f;
            session = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
            List rows = DatabaseFactory.executeSQLQuery((String)this.getTable, (SessionFactory)session);
            this.initDatasets();
            String countryFilter = this.config.getParam(countryParam);
            int startYearFilter = 0;
            int endYearFilter = 3000;
            try {
                startYearFilter = Integer.parseInt(this.config.getParam(yearStartParam));
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                endYearFilter = Integer.parseInt(this.config.getParam(yearEndParam));
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (endYearFilter < startYearFilter) {
                throw new Exception("Invalid Years Range");
            }
            int nrows = rows.size();
            float step = (float)MathFunctions.roundDecimal((double)((90.0 - (double)this.status) / (double)nrows), (int)2);
            for (Object row : rows) {
                Object[] rowA = (Object[])row;
                String country = "" + rowA[0];
                if (countryFilter == null || countryFilter.length() == 0 || countryFilter.equalsIgnoreCase("ALL") || countryFilter.equalsIgnoreCase(country)) {
                    this.fulfillDataset("" + rowA[0], "" + rowA[1], Double.parseDouble("" + rowA[2]), Double.parseDouble("" + rowA[3]), Double.parseDouble("" + rowA[4]), Double.parseDouble("" + rowA[5]), Double.parseDouble("" + rowA[6]), Double.parseDouble("" + rowA[7]), Double.parseDouble("" + rowA[8]), Double.parseDouble("" + rowA[9]), Double.parseDouble("" + rowA[10]), Double.parseDouble("" + rowA[11]), Double.parseDouble("" + rowA[12]), Double.parseDouble("" + rowA[13]), Double.parseDouble("" + rowA[14]), Double.parseDouble("" + rowA[15]), startYearFilter, endYearFilter);
                }
                this.status = Math.min(this.status + step, 90.0f);
            }
            try {
                JFreeChart chartMWE = this.createChartForMWE();
                Image imageMWE = ImageTools.toImage((BufferedImage)chartMWE.createBufferedImage(680, 420));
                this.producedImages.put(MWE, imageMWE);
                if (display) {
                    this.renderChartForMWE();
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)"Could not produce chart for MWE");
            }
            try {
                JFreeChart chartMWT = this.createChartForMWT();
                Image imageMWT = ImageTools.toImage((BufferedImage)chartMWT.createBufferedImage(680, 420));
                this.producedImages.put(MWT, imageMWT);
                if (display) {
                    this.renderChartForMWT();
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)"Could not produce chart for MWT");
            }
            try {
                JFreeChart chartTJY = this.createChartForTJY();
                Image imageTJY = ImageTools.toImage((BufferedImage)chartTJY.createBufferedImage(680, 420));
                this.producedImages.put(TJY, imageTJY);
                if (display) {
                    this.renderChartForTJY();
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)"Could not produce chart for TJY");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                try {
                    AnalysisLogger.getLogger().debug((Object)("Dropping table " + this.featuresTable));
                    DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.featuresTable), (SessionFactory)session);
                    AnalysisLogger.getLogger().debug((Object)("Table " + this.featuresTable + " dropped"));
                }
                catch (Exception ee) {
                    AnalysisLogger.getLogger().debug((Object)("Could not drop table " + this.featuresTable + ": " + ee.getLocalizedMessage()));
                }
                session.close();
            }
            this.status = 100.0f;
        }
    }

    public String getDescription() {
        return "";
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    public List<StatisticalType> getInputParameters() {
        IOHelper.addStringInput(this.inputs, (String)countryParam, (String)"The country on which the analysis will focus (ALL to get statistics about all countries)", (String)"ALL");
        IOHelper.addIntegerInput(this.inputs, (String)yearStartParam, (String)"The starting year of the analysis", (String)"1990");
        IOHelper.addIntegerInput(this.inputs, (String)yearEndParam, (String)"The final year of the analysis", (String)"2013");
        DatabaseType.addDefaultDBPars(this.inputs);
        return this.inputs;
    }

    public StatisticalType getOutput() {
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), this.producedImages, PrimitiveTypes.IMAGES, "images", "Trends");
        LinkedHashMap<String, PrimitiveType> outputmap = new LinkedHashMap<String, PrimitiveType>();
        outputmap.put("Images", images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), outputmap, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    public String getResources() {
        return ResourceFactory.getResources((float[])new float[]{100.0f});
    }

    public float getStatus() {
        return this.status;
    }

    public void init() throws Exception {
    }

    public void setConfiguration(AlgorithmConfiguration arg0) {
        this.config = arg0;
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }
}

