/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.fin.taxamatch;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.taxamatch.fin.func_Taxamatch;

public class TaxaMatchTransducer
extends StandardLocalExternalAlgorithm {
    static String GenusOperator = "ComparisonOperatorforGenus";
    static String SpeciesOperator = "ComparisonOperatorforSpecies";
    static String Genus = "Genus";
    static String Species = "Species";
    static String databaseParameterName = "FishBase";
    static String userParameterName = "user";
    static String passwordParameterName = "password";
    static String urlParameterName = "FishBase";

    @Override
    public String getDescription() {
        return "An algorithm for Taxa Matching with respect to the Fishbase database";
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    protected void process() throws Exception {
        String genus = this.getInputParameter(Genus);
        String species = this.getInputParameter(Species);
        String genusOperator = this.getInputParameter(GenusOperator);
        String speciesOperator = this.getInputParameter(SpeciesOperator);
        String databaseJdbc = this.getInputParameter(urlParameterName).replace("//", "");
        int separator = databaseJdbc.lastIndexOf("/");
        if (separator < 0) {
            this.log("Bad database URL: " + databaseJdbc);
            this.addOutputString("Number of Matches", "0");
            return;
        }
        String databaseIP = databaseJdbc.substring(0, separator);
        String databaseName = databaseJdbc.substring(separator + 1);
        String databaseUser = this.getInputParameter(userParameterName);
        String databasePwd = this.getInputParameter(passwordParameterName);
        this.log("Database Parameters to use: " + databaseIP + " " + databaseName + " " + databaseUser + " " + databasePwd);
        this.log("Computing matching for " + genus + " " + species);
        this.log("With operators: " + genusOperator + " " + speciesOperator);
        if (genus == null || species == null) {
            this.log("Void input");
            this.addOutputString("Number of Matches", "0");
        } else {
            func_Taxamatch func = new func_Taxamatch();
            AnalysisLogger.getLogger().trace((Object)"TaxaMatcher Initialized");
            String[] matches = func.func_Taxamatch(genus, species, genusOperator, speciesOperator, databaseIP, databaseUser, databasePwd, databaseName);
            if (matches == null || matches.length == 0) {
                this.log("No match");
                this.addOutputString("Number of Matches", "0");
            } else {
                this.log("Found " + matches[0] + " matches");
                this.addOutputString("Number of Matches", matches[0]);
                String[] speciesn = matches[1].split("\n");
                if (Integer.parseInt(matches[0]) > 0) {
                    for (int i = 0; i < speciesn.length; ++i) {
                        this.addOutputString("Match " + (i + 1), speciesn[i].trim());
                    }
                }
            }
        }
        this.log(this.outputParameters);
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected void setInputParameters() {
        this.addStringInput(Genus, "Genus of the species", "Gadus");
        this.addStringInput(Species, "Species", "morhua");
        this.addEnumerateInput(operators.values(), GenusOperator, "Comparison Operator for Genus", "" + (Object)((Object)operators.EQUAL));
        this.addEnumerateInput(operators.values(), SpeciesOperator, "Comparison Operator for Species", "" + (Object)((Object)operators.EQUAL));
        this.addRemoteDatabaseInput(databaseParameterName, urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
    }

    public static enum operators {
        EQUAL,
        NOT_EQUAL,
        CONTAINS,
        BEGINS_WITH,
        ENDS_WITH;

    }
}

