/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.JobSMspd;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.PluginDescription;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.dataanalysis.JobSMspd.Lock;
import org.gcube.dataanalysis.JobSMspd.MapDwCA;
import org.gcube.dataanalysis.JobSMspd.ThreadExtractionTaxaFromSPD;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.DynamicEnum;
import org.hibernate.SessionFactory;

public class TaxaProcedure
extends StandardLocalExternalAlgorithm {
    LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    static String databaseParameterName = "FishBase";
    static String userParameterName = "user";
    static String passwordParameterName = "password";
    static String urlParameterName = "FishBase";
    SessionFactory dbconnection = null;
    String tablename;
    String columnnames;
    List<Object> speciesList = null;
    String outputtablename;
    String outputErrortablename;
    String outputtable;
    HashMap<String, String> dpHash = new HashMap();
    HashMap<String, String> dpUHash = new HashMap();
    HashMap<String, String> dpEHash = new HashMap();
    String tableError;
    private static DataPenum dp = null;
    private static ExtentionDPEnum dpE = null;
    private static UnfoldDPEnum dpU = null;
    private String dataProvider = "Data Provider :";
    private String chosendataProvider = new String();
    private String dataProviderExtention = "Data Provider (Expand Option):";
    private String chosendataProviderExtention = new String();
    private String dataProviderUnfold = "Data Provider (Unfold Option):";
    private String chosendataProviderUnfold = new String();
    File file;
    private Lock lock = new Lock();

    public String getDescription() {
        return " An Algorithm that retrieves the taxon from a data provided based on the given search options";
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"SMFaoAlg");
    }

    public void fulfilParameters() throws IOException {
        this.config.setParam("DatabaseDriver", "org.postgresql.Driver");
        this.dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
        this.tablename = this.getInputParameter("SpeciesTable");
        this.columnnames = this.getInputParameter("SpeciesColumns");
        this.outputtablename = this.getInputParameter("OutputTableName");
        this.outputtable = this.getInputParameter("OutputTable");
        this.tableError = this.getInputParameter("ErrorTable");
        this.chosendataProviderUnfold = this.getInputParameter(this.dataProviderUnfold);
        this.chosendataProviderExtention = this.getInputParameter(this.dataProviderExtention);
        this.chosendataProvider = this.getInputParameter(this.dataProvider);
        this.outputErrortablename = this.getInputParameter("ErrorTableName");
        String[] columnlist = this.columnnames.split(AlgorithmConfiguration.getListSeparator());
        this.speciesList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[0] + " from " + this.tablename), (SessionFactory)this.dbconnection);
    }

    protected void process() throws Exception {
        try {
            this.fulfilParameters();
            this.createTables();
            int lenght = this.speciesList.size() / 3;
            ArrayList<String> chunk1 = new ArrayList<String>();
            ArrayList<String> chunk2 = new ArrayList<String>();
            ArrayList<String> chunk3 = new ArrayList<String>();
            for (int i = 0; i < this.speciesList.size(); ++i) {
                if (i < lenght) {
                    chunk1.add((String)this.speciesList.get(i));
                }
                if (i >= lenght && i <= 2 * lenght) {
                    chunk2.add((String)this.speciesList.get(i));
                }
                if (i <= 2 * lenght) continue;
                chunk3.add((String)this.speciesList.get(i));
            }
            String scope = ScopeProvider.instance.get();
            ThreadExtractionTaxaFromSPD t1 = new ThreadExtractionTaxaFromSPD(chunk1, this.chosendataProvider, this.chosendataProviderExtention, this.chosendataProviderUnfold, scope);
            ThreadExtractionTaxaFromSPD t2 = new ThreadExtractionTaxaFromSPD(chunk2, this.chosendataProvider, this.chosendataProviderExtention, this.chosendataProviderUnfold, scope);
            ThreadExtractionTaxaFromSPD t3 = new ThreadExtractionTaxaFromSPD(chunk3, this.chosendataProvider, this.chosendataProviderExtention, this.chosendataProviderUnfold, scope);
            Thread th1 = new Thread(t1);
            th1.start();
            Thread th2 = new Thread(t2);
            th2.start();
            Thread th3 = new Thread(t3);
            th3.start();
            th1.join();
            th2.join();
            th3.join();
            AnalysisLogger.getLogger().debug((Object)"Thread finished");
            Vector<TaxonomyItem> taxaList = t1.getTaxaList();
            taxaList.addAll(t2.getTaxaList());
            taxaList.addAll(t3.getTaxaList());
            MapDwCA fileMaker = new MapDwCA(this.config.getPersistencePath());
            Iterator<TaxonomyItem> it = taxaList.iterator();
            this.file = fileMaker.createDwCA(it);
            AnalysisLogger.getLogger().debug((Object)"DWA Created");
            this.insertInTheTableErrors(t1.getErrors());
            this.insertInTheTableErrors(t2.getErrors());
            this.insertInTheTableErrors(t3.getErrors());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)this.dbconnection);
        }
    }

    private void createTables() throws Exception {
        DatabaseFactory.executeSQLUpdate((String)("create table " + this.tableError + " (error character varying)"), (SessionFactory)this.dbconnection);
    }

    private void insertInTheTable(ArrayList<ArrayList<String>> arrays) throws IOException {
        for (ArrayList<String> array : arrays) {
            String writeString = new String();
            int i = 0;
            for (String s : array) {
                if (i != 0) {
                    writeString = writeString + "; ";
                }
                writeString = writeString + " '";
                if (s != null) {
                    s = s.replace("'", "");
                }
                writeString = writeString + s;
                writeString = writeString + "'";
                ++i;
            }
        }
    }

    private void insertInTheTableErrors(ArrayList<String> arrays) throws Exception {
        if (arrays != null) {
            String st = " (error)";
            for (String er : arrays) {
                String query = "insert into " + this.tableError + st + " values ('" + er + "')";
                AnalysisLogger.getLogger().debug((Object)("query error : " + query));
                DatabaseFactory.executeSQLUpdate((String)query, (SessionFactory)this.dbconnection);
            }
        }
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shut down ");
    }

    private void insertEnumValuesr() {
        AnalysisLogger.getLogger().debug((Object)" insertEnumValuesr");
        try {
            if (UnfoldDPEnumType.values().length == 0) {
                AnalysisLogger.getLogger().debug((Object)"Only one provider.");
                dp = new DataPenum();
                dpE = new ExtentionDPEnum();
                dpU = new UnfoldDPEnum();
                this.setDynamicParameter();
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            AnalysisLogger.getLogger().debug((Object)sw.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDynamicParameter() {
        AnalysisLogger.getLogger().debug((Object)"Inside setDynamicParameter");
        AnalysisLogger.getLogger().debug((Object)("Procedure called in the scope" + ScopeProvider.instance.get().toString()));
        Manager manager = null;
        manager = (Manager)AbstractPlugin.manager().build();
        AnalysisLogger.getLogger().debug((Object)"build manager");
        AnalysisLogger.getLogger().debug((Object)"before plugin");
        List plugin = null;
        try {
            plugin = manager.getPluginsDescription();
        }
        catch (Exception e) {
            String eTracMes = e.getMessage();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            AnalysisLogger.getLogger().debug((Object)eTracMes);
            AnalysisLogger.getLogger().debug((Object)sw.toString());
        }
        finally {
            try {
                this.lock.lock();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            dp.addEnum(DataProvidersType.class, "ALL");
            dpE.addEnum(ExtentionDPType.class, "ALL");
            dpU.addEnum(UnfoldDPEnumType.class, "NO OPTION");
            dpE.addEnum(ExtentionDPType.class, "NO OPTION");
            this.lock.unlock();
        }
        AnalysisLogger.getLogger().debug((Object)"get  plugin");
        if (plugin != null) {
            AnalysisLogger.getLogger().debug((Object)("*****PluginDescription is NOT null - length: " + plugin.size()));
            for (int i = 0; i < plugin.size(); ++i) {
                PluginDescription pluginDescription = (PluginDescription)plugin.get(i);
                AnalysisLogger.getLogger().debug((Object)("For   plugin ***" + pluginDescription.getName()));
                Map pluginCapabilities = pluginDescription.getSupportedCapabilities();
                AnalysisLogger.getLogger().debug((Object)"created maps");
                AnalysisLogger.getLogger().debug((Object)(" map size" + pluginCapabilities.size()));
                for (Map.Entry pluginCapability : pluginCapabilities.entrySet()) {
                    Capabilities capability = (Capabilities)pluginCapability.getKey();
                    String capabilityName = capability.name().toString();
                    AnalysisLogger.getLogger().debug((Object)capabilityName);
                    if (capabilityName.equals("Unfold")) {
                        dpU.addEnum(UnfoldDPEnumType.class, pluginDescription.getName().toString());
                    }
                    if (capabilityName.equals("Expansion")) {
                        dpE.addEnum(ExtentionDPType.class, pluginDescription.getName().toString());
                    }
                    if (!capabilityName.equals("Classification")) continue;
                    dp.addEnum(DataProvidersType.class, pluginDescription.getName().toString());
                }
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"*****PluginDescription is null");
        }
    }

    protected void setInputParameters() {
        try {
            AnalysisLogger.getLogger().debug((Object)"inside setInputParameters ");
            this.addRemoteDatabaseInput(databaseParameterName, urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
            ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
            templates.add(TableTemplates.GENERIC);
            InputTable tinput = new InputTable(templates, "SpeciesTable", "The table containing the species information");
            ColumnTypesList columns = new ColumnTypesList("SpeciesTable", "SpeciesColumns", "Select the columns for  species name", false);
            this.addStringInput("OutputTableName", "The name of the output table", "occ_");
            this.addStringInput("ErrorTableName", "The name of the output table", "err_");
            ServiceType randomstring = new ServiceType(ServiceParameters.RANDOMSTRING, "OutputTable", "", "tax_");
            ServiceType randomstringErr = new ServiceType(ServiceParameters.RANDOMSTRING, "ErrorTable", "", "err");
            AnalysisLogger.getLogger().debug((Object)"before setDynamicParameter() ");
            this.insertEnumValuesr();
            this.addEnumerateInput(DataProvidersType.values(), this.dataProvider, "Choose Data Providere", "ALL");
            AnalysisLogger.getLogger().debug((Object)"After DataProvidersType");
            this.addEnumerateInput(ExtentionDPType.values(), this.dataProviderExtention, "Choose Expand Option Data Providere", "ALL");
            AnalysisLogger.getLogger().debug((Object)"After ExtentionDPType");
            this.addEnumerateInput(UnfoldDPEnumType.values(), this.dataProviderUnfold, "Choose Unfold Option Data Providere", "ALL");
            AnalysisLogger.getLogger().debug((Object)"After UnfoldDPEnumType");
            this.inputs.add(tinput);
            this.inputs.add(columns);
            this.inputs.add(randomstring);
            this.inputs.add(randomstringErr);
            DatabaseType.addDefaultDBPars((List)this.inputs);
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)e.toString());
        }
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> outtemplate = new ArrayList<TableTemplates>();
        outtemplate.add(TableTemplates.GENERIC);
        ArrayList<TableTemplates> outtemplateErr = new ArrayList<TableTemplates>();
        outtemplateErr.add(TableTemplates.GENERIC);
        OutputTable outErr = new OutputTable(outtemplate, this.outputErrortablename, this.tableError, "The output table containing all the matches");
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)this.file, PrimitiveTypes.FILE, "OccFile", "OccFile");
        this.map.put("Output", (StatisticalType)f);
        this.map.put("Errors", (StatisticalType)outErr);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    class UnfoldDPEnum
    extends DynamicEnum {
        UnfoldDPEnum() {
        }

        public Field[] getFields() {
            Field[] fields = UnfoldDPEnumType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum UnfoldDPEnumType {

    }

    class ExtentionDPEnum
    extends DynamicEnum {
        ExtentionDPEnum() {
        }

        public Field[] getFields() {
            Field[] fields = ExtentionDPType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum ExtentionDPType {

    }

    class DataPenum
    extends DynamicEnum {
        DataPenum() {
        }

        public Field[] getFields() {
            Field[] fields = DataProvidersType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum DataProvidersType {

    }
}

