/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.JobSMspd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.streams.Stream;

public class ThreadExtractionOccFromSPD
implements Runnable {
    private ArrayList<String> chunk;
    private ArrayList<ArrayList<String>> informations;
    private ArrayList<String> errors;
    BufferedWriter out;
    private String dataProvider;
    private String dataProviderUnfold;
    private String dataProviderExpand;
    String scope;
    private File tempFile;

    public ThreadExtractionOccFromSPD(ArrayList<String> chunk, String dataProvider, String dataProviderExpand, String dataProviderUnfold, String scope) {
        this.chunk = chunk;
        this.dataProvider = dataProvider;
        this.dataProviderExpand = dataProviderExpand;
        this.dataProviderUnfold = dataProviderUnfold;
        this.errors = new ArrayList();
        this.scope = scope;
    }

    @Override
    public void run() {
        AnalysisLogger.getLogger().debug((Object)("SCOPE  " + this.scope));
        try {
            this.tempFile = File.createTempFile("chunk" + Thread.currentThread().getId(), ".csv");
            this.out = new BufferedWriter(new FileWriter(this.tempFile, false));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)("Error in the chunk file creation: " + e));
        }
        ScopeProvider.instance.set(this.scope);
        Manager manager = null;
        try {
            manager = (Manager)AbstractPlugin.manager().build();
            for (String species : this.chunk) {
                if (species == null) continue;
                String query = new String();
                query = this.createQueryParameter(species);
                AnalysisLogger.getLogger().debug((Object)("QUERY *******: " + query));
                try {
                    Stream stream = manager.search(query);
                    int i = 0;
                    while (stream.hasNext()) {
                        ++i;
                        OccurrencePoint ti = (OccurrencePoint)stream.next();
                        ArrayList<String> array = this.crateRowTable(ti);
                        this.insertInTheFile(array);
                        array = null;
                        System.gc();
                    }
                    if (i != 0) continue;
                    this.errors.add(species + " not found.");
                }
                catch (Exception e) {
                    this.errors.add("Exception on " + species + " :" + e.getMessage());
                    e.printStackTrace();
                }
            }
            this.out.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("An error occurred: " + e.getMessage()));
        }
    }

    private String createQueryParameter(String species) {
        String query = "SEARCH BY SN '" + species + "'";
        String where = new String();
        String expand = new String();
        String unfold = new String();
        where = this.dataProvider.equals("ALL") ? "" : " IN " + this.dataProvider;
        unfold = this.dataProviderUnfold.equals("NO OPTION") ? "" : " UNFOLD WITH " + this.dataProviderUnfold;
        query = query + unfold;
        AnalysisLogger.getLogger().debug((Object)("expand is : " + this.dataProviderExpand));
        if (this.dataProviderExpand.equals("ALL")) {
            expand = " EXPAND";
        } else {
            AnalysisLogger.getLogger().debug((Object)"inside else ");
            expand = this.dataProviderExpand.equals("NO OPTION") ? "" : " EXPAND WITH " + this.dataProviderExpand;
        }
        query = query + expand;
        query = query + where;
        query = query + " RETURN occurrence";
        return query;
    }

    private ArrayList<String> crateRowTable(OccurrencePoint occurrence) {
        ArrayList<String> infoOcc = new ArrayList<String>();
        infoOcc.add(occurrence.getInstitutionCode().replace(",", " "));
        infoOcc.add(occurrence.getCollectionCode().replace(",", " "));
        infoOcc.add(occurrence.getCatalogueNumber().replace(",", " "));
        infoOcc.add(occurrence.getDataSet().getName());
        infoOcc.add(occurrence.getDataSet().getDataProvider().getName());
        infoOcc.add(occurrence.getProvider());
        infoOcc.add(occurrence.getScientificNameAuthorship());
        infoOcc.add(occurrence.getIdentifiedBy());
        infoOcc.add(occurrence.getCredits());
        infoOcc.add(occurrence.getRecordedBy());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (occurrence.getEventDate() == null || sdf.format(occurrence.getEventDate().getTime()).length() == 0) {
            infoOcc.add("");
        } else {
            infoOcc.add(sdf.format(occurrence.getEventDate().getTime()));
        }
        if (occurrence.getModified() == null || sdf.format(occurrence.getModified().getTime()).length() == 0) {
            infoOcc.add("");
        } else {
            infoOcc.add(sdf.format(occurrence.getModified().getTime()));
        }
        infoOcc.add(occurrence.getScientificName());
        infoOcc.add(occurrence.getKingdom());
        infoOcc.add(occurrence.getFamily());
        infoOcc.add(occurrence.getLocality());
        infoOcc.add(occurrence.getCountry());
        infoOcc.add(occurrence.getCitation());
        infoOcc.add(Double.toString(occurrence.getDecimalLatitude()));
        infoOcc.add(Double.toString(occurrence.getDecimalLongitude()));
        infoOcc.add(occurrence.getCoordinateUncertaintyInMeters());
        infoOcc.add(Double.toString(occurrence.getMaxDepth()));
        infoOcc.add(Double.toString(occurrence.getMinDepth()));
        infoOcc.add(occurrence.getBasisOfRecord().toString());
        return infoOcc;
    }

    private void insertInTheFile(ArrayList<String> array) throws Exception {
        String writeString = new String();
        int i = 0;
        for (String s : array) {
            if (i == array.size() - 1) {
                writeString = s == null ? writeString + " " : writeString + s.replace(",", " ");
            } else if (s == null) {
                writeString = writeString + " ,";
                if (i == 10 || i == 11) {
                    writeString = writeString + ",";
                }
            } else {
                writeString = writeString + s.replace(",", " ") + ",";
            }
            ++i;
        }
        this.write(writeString);
        this.out.newLine();
    }

    private void write(String writeSt) {
        try {
            this.out.write(writeSt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getInfo() {
        return this.tempFile;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }
}

