package org.gcube.dataanalysis.JobSMspd;

import static org.gcube.data.spd.client.plugins.AbstractPlugin.manager;

import java.util.ArrayList;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.model.products.ResultElement;

import org.gcube.data.streams.Stream;

public class ThreadExtractionOccFromSPD implements Runnable {
	private ArrayList<String> chunk;
	private ArrayList<ArrayList<String>> informations;
	private ArrayList<String> errors;

	private String dataProvider;
	private String dataProviderUnfold;
	private String dataProviderExpand;
	String scope;
	

	public ThreadExtractionOccFromSPD(ArrayList<String> chunk, String dataProvider,String dataProviderExpand,String dataProviderUnfold,String scope ) {
		this.chunk = chunk;
		for (String species : chunk) {
		
//		AnalysisLogger.getLogger().debug(species);
		}
		this.dataProvider=dataProvider;
		this.dataProviderExpand= dataProviderExpand;
		this.dataProviderUnfold=dataProviderUnfold;
		informations = new ArrayList<ArrayList<String>>();
		errors= new ArrayList<String>();
		this.scope=scope;
		
		
	}
	

	public void run() {
		AnalysisLogger.getLogger().debug("SCOPE *******: "+scope);
		ScopeProvider.instance.set(scope);
		Manager manager=null;
		try{ 
			manager = manager().build();
		
		for (String species : chunk) {
			if (species != null) {
				String query = new String();

				query=createQueryParameter(species);
				AnalysisLogger.getLogger().debug("QUERY *******: "+query);
				Stream<ResultElement> stream;
				try {
					
					stream = manager.search(query);
					int i=0;
					while (stream.hasNext()) {
						i++;
						
						OccurrencePoint ti = (OccurrencePoint) stream.next();
						informations.add(crateRowTable(ti));

					}
					if(i==0)
					{
						errors.add(species+" not found.");
					}
				} catch (Exception e) {
					errors.add("Exception on "+species+" :"+ e.getMessage());
					e.printStackTrace();
					
				}
				
			}
			
		}
		}catch(Throwable e){
			e.printStackTrace();
			AnalysisLogger.getLogger().debug("An error occurred: "+e.getMessage());
		}
		
	}
	
	private String createQueryParameter(String species)
	{
		String query= "SEARCH BY SN '"+species +"'";
		String where=new String();
		String expand=new String();
		String unfold=new String();
		if(dataProvider.equals("ALL"))
			where="";
		else 
			where=" IN "+dataProvider;
		
		if(dataProviderUnfold.equals("NO OPTION"))
			unfold="";
			else
				unfold=" UNFOLD WITH "+dataProviderUnfold;
		
		query= query +unfold;
		AnalysisLogger.getLogger().debug("expand is : "+dataProviderExpand);
		if(dataProviderExpand.equals("ALL"))
			{expand=" EXPAND";}
		else{
			AnalysisLogger.getLogger().debug("inside else ");
			if(dataProviderExpand.equals("NO OPTION"))
			expand="";
			else
				expand=" EXPAND WITH "+dataProviderExpand;
		}
		query= query+ expand;				
		query=query+ where;
		query= query +" RETURN occurrence";
		return query;
	}
	
	

	private ArrayList<String> crateRowTable(OccurrencePoint p)
	{
		ArrayList<String> infoOcc= new ArrayList<String>();
		infoOcc.add(p.getScientificName());
		infoOcc.add(p.getScientificNameAuthorship());
		infoOcc.add(p.getCatalogueNumber());
		infoOcc.add(p.getCitation());
		infoOcc.add(p.getCollectionCode());
		infoOcc.add(p.getCoordinateUncertaintyInMeters());
		infoOcc.add(p.getCountry());
		infoOcc.add(p.getCredits());
		infoOcc.add(p.getFamily());
		infoOcc.add(p.getId());
		infoOcc.add(p.getInstitutionCode());
		infoOcc.add(p.getKingdom());
		infoOcc.add(p.getLocality());
		infoOcc.add(p.getProvider());
		infoOcc.add((Double.toString(p.getDecimalLatitude())));
		infoOcc.add((Double.toString(p.getDecimalLongitude())));
		infoOcc.add((Double.toString(p.getMaxDepth())));
		infoOcc.add((Double.toString(p.getMinDepth())));
		return infoOcc;
		
	}
	public ArrayList<ArrayList<String>> getInfo()
	{
		return informations;
	}
	public ArrayList<String> getErrors()
	{
		return errors;
	}
}
