/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.JobSMspd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDwCA {
    static Logger logger = LoggerFactory.getLogger(MapDwCA.class);
    private BufferedWriter vernacularFile;
    private File tempFolder;
    private List<File> fileList = new ArrayList<File>();
    private String archiveZip = "archive-tax.zip";
    private String directory;

    public MapDwCA(String directory) {
        this.directory = directory;
    }

    public synchronized File createDwCA(Iterator<TaxonomyItem> taxa) throws Exception {
        this.createMetaXml();
        this.createMetadata();
        this.createHeaders();
        this.createTaxaTxt(taxa);
        this.getAllFiles(this.tempFolder);
        return this.writeZipFile(this.tempFolder);
    }

    private void createMetaXml() {
        try {
            String line;
            BufferedWriter bw = null;
            BufferedReader br = null;
            this.tempFolder = new File(this.directory + "DwCA-folder");
            this.tempFolder.mkdir();
            File output = new File(this.tempFolder + "/meta.xml");
            bw = new BufferedWriter(new FileWriter(output));
            br = new BufferedReader(new InputStreamReader(MapDwCA.class.getResourceAsStream("/org/gcube/data/spd/dwca/meta.xml")));
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.write(10);
            }
            bw.close();
            br.close();
        }
        catch (IOException e) {
            logger.error("IO Error", (Throwable)e);
        }
    }

    private void createHeaders() {
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "taxa.txt", true));
            this.vernacularFile = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "VernacularName.txt", true));
            file.write("taxonID\t");
            file.write("acceptedNameUsageID\t");
            file.write("parentNameUsageID\t");
            file.write("scientificName\t");
            file.write("scientificNameAuthorship\t");
            file.write("nameAccordingTo\t");
            file.write("kingdom\t");
            file.write("phylum\t");
            file.write("class\t");
            file.write("order\t");
            file.write("family\t");
            file.write("genus\t");
            file.write("subgenus\t");
            file.write("specificEpithet\t");
            file.write("infraspecificEpithet\t");
            file.write("verbatimTaxonRank\t");
            file.write("taxonRank\t");
            file.write("taxonomicStatus\t");
            file.write("modified\t");
            file.write("bibliographicCitation\t");
            file.write("taxonRemarks\t");
            file.write("scientificNameID\n");
            file.close();
            this.vernacularFile.write("taxonID\t");
            this.vernacularFile.write("vernacularName\t");
            this.vernacularFile.write("language\t");
            this.vernacularFile.write("locality\n");
            this.vernacularFile.close();
        }
        catch (IOException e) {
            logger.error("IO Error", (Throwable)e);
        }
    }

    public void createTaxaTxt(Iterator<TaxonomyItem> taxaReader) {
        while (taxaReader.hasNext()) {
            TaxonomyItem item = taxaReader.next();
            this.writeLine(item);
        }
    }

    private void internalWriter(TaxonomyItem taxonomyItem, BufferedWriter file) throws IOException {
        String[] name = taxonomyItem.getScientificName().split(" ");
        TaxonomyItem tax = taxonomyItem.getParent();
        Hashtable<String, String> hashTaxa = new Hashtable<String, String>();
        if (tax != null) {
            this.getTax(tax, hashTaxa);
        }
        file.write(taxonomyItem.getId());
        file.write("\t");
        if (taxonomyItem.getStatus() == null) {
            logger.trace("the status is null for " + taxonomyItem.getId());
        }
        if (taxonomyItem.getStatus().getRefId() != null) {
            String id = taxonomyItem.getStatus().getRefId();
            file.write(id);
        }
        file.write("\t");
        if (tax != null) {
            file.write(tax.getId());
        }
        file.write("\t");
        file.write(taxonomyItem.getScientificName());
        file.write("\t");
        if (taxonomyItem.getAuthor() != null) {
            file.write(taxonomyItem.getAuthor());
        }
        file.write("\t");
        if (taxonomyItem.getCitation() != null) {
            file.write(taxonomyItem.getCitation());
        }
        file.write("\t");
        String kingdom = hashTaxa.get("kingdom");
        if (kingdom != null) {
            file.write(kingdom);
        }
        file.write("\t");
        String phylum = hashTaxa.get("phylum");
        if (phylum != null) {
            file.write(phylum);
        }
        file.write("\t");
        String claz = hashTaxa.get("class");
        if (claz != null) {
            file.write(claz);
        }
        file.write("\t");
        String order = hashTaxa.get("order");
        if (order != null) {
            file.write(order);
        }
        file.write("\t");
        String family = hashTaxa.get("family");
        if (family != null) {
            file.write(family);
        }
        file.write("\t");
        String genus = hashTaxa.get("genus");
        if (genus != null) {
            file.write(genus);
        }
        file.write("\t");
        String subgenus = hashTaxa.get("subgenus");
        if (subgenus != null) {
            file.write(subgenus);
        }
        file.write("\t");
        if (name.length > 1) {
            file.write(name[1]);
        }
        file.write("\t");
        if (name.length > 2) {
            file.write(name[name.length - 1]);
        }
        file.write("\t");
        if (name.length > 2) {
            file.write(name[name.length - 2]);
        }
        file.write("\t");
        if (taxonomyItem.getRank() != null) {
            file.write(taxonomyItem.getRank().toLowerCase());
        }
        file.write("\t");
        file.write(taxonomyItem.getStatus().getStatus().toString().toLowerCase());
        file.write("\t");
        if (taxonomyItem.getModified() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date = taxonomyItem.getModified().getTime();
            String s = sdf.format(date);
            file.write(s);
        }
        file.write("\t");
        if (taxonomyItem.getCredits() != null) {
            file.write(taxonomyItem.getCredits());
        }
        file.write("\t");
        if (taxonomyItem.getStatus().getStatusAsString() != null) {
            file.write(taxonomyItem.getStatus().getStatusAsString());
        }
        file.write("\t");
        if (taxonomyItem.getLsid() != null) {
            file.write(taxonomyItem.getLsid());
        }
        file.write("\n");
        if (taxonomyItem.getCommonNames() != null) {
            this.createVernacularTxt(taxonomyItem.getId(), taxonomyItem.getCommonNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLine(TaxonomyItem taxonomyItem) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "taxa.txt", true));
            this.internalWriter(taxonomyItem, bufferedWriter);
        }
        catch (IOException e) {
            logger.error("IO Error", (Throwable)e);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException e) {
                logger.error("error closing bufferedWriter", (Throwable)e);
            }
        }
    }

    private void createVernacularTxt(String id, List<CommonName> list) {
        try {
            this.vernacularFile = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "VernacularName.txt", true));
            for (CommonName vernacular : list) {
                this.vernacularFile.write(id);
                this.vernacularFile.write("\t");
                this.vernacularFile.write(vernacular.getName());
                this.vernacularFile.write("\t");
                if (vernacular.getLanguage() != null) {
                    this.vernacularFile.write(vernacular.getLanguage());
                }
                this.vernacularFile.write("\t");
                if (vernacular.getLocality() != null) {
                    this.vernacularFile.write(vernacular.getLocality());
                }
                this.vernacularFile.write("\n");
            }
            this.vernacularFile.close();
        }
        catch (IOException e) {
            logger.error("IO Error", (Throwable)e);
        }
    }

    private void getTax(TaxonomyItem tax, Hashtable<String, String> taxa) {
        if (tax != null) {
            if (tax.getRank() != null && tax.getScientificName() != null) {
                taxa.put(tax.getRank().toLowerCase(), tax.getScientificName());
            } else {
                AnalysisLogger.getLogger().debug((Object)"in DWA generator, tax rank or SN are null");
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"tax is null");
        }
        if (tax.getParent() != null) {
            this.getTax(tax.getParent(), taxa);
        }
    }

    private void getAllFiles(File dir) {
        try {
            File[] files;
            for (File file : files = dir.listFiles()) {
                this.fileList.add(file);
                if (file.isDirectory()) {
                    logger.trace("directory:" + file.getCanonicalPath());
                    this.getAllFiles(file);
                    continue;
                }
                logger.trace("     file:" + file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            logger.error("error creating files", (Throwable)e);
        }
    }

    private File writeZipFile(File directoryToZip) throws Exception {
        File zipFile = new File(directoryToZip + "/" + this.archiveZip);
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (File file : this.fileList) {
            if (file.isDirectory()) continue;
            this.addToZip(directoryToZip, file, zos);
        }
        zos.close();
        fos.close();
        return zipFile;
    }

    private void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        logger.trace("Writing '" + zipFilePath + "' to zip file");
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }

    public void createMetadata() throws IOException {
        String line;
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        File output = new File(this.tempFolder + "/eml.xml");
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(output));
        }
        catch (IOException e) {
            logger.error("IO Error", (Throwable)e);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(MapDwCA.class.getResourceAsStream("/org/gcube/data/spd/dwca/eml.xml")));
        while ((line = br.readLine()) != null) {
            bw.write(line.replace("<pubDate></pubDate>", "<pubDate>" + format.format(now.getTime()) + "</pubDate>"));
            bw.write(10);
        }
        bw.close();
        br.close();
    }
}

