/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.n52.wps.PropertyDocument;
import org.n52.wps.ServerDocument;
import org.n52.wps.commons.WPSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseURLFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseURLFilter.class);
    public static final String PROP_responseURLFilterEnabled = "responseURLFilterEnabled";
    private String configURLString;
    private boolean enabled;

    public void init(FilterConfig filterConfig) throws ServletException {
        PropertyDocument.Property[] serverProperties;
        ServerDocument.Server server = WPSConfig.getInstance().getWPSConfig().getServer();
        this.configURLString = server.getProtocol() + "://" + server.getHostname() + ":" + server.getHostport() + "/" + server.getWebappPath();
        for (PropertyDocument.Property serverProperty : serverProperties = server.getPropertyArray()) {
            if (!PROP_responseURLFilterEnabled.equals(serverProperty.getName())) continue;
            this.enabled = Boolean.parseBoolean(serverProperty.getStringValue());
        }
        if (this.enabled) {
            LOGGER.info("Response URL filtering enabled using base URL of {}", (Object)this.configURLString);
        } else {
            LOGGER.info("Response URL filtering disabled.");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse responseHTTP;
        HttpServletRequest requestHTTP = request instanceof HttpServletRequest ? (HttpServletRequest)request : null;
        HttpServletResponse httpServletResponse = responseHTTP = response instanceof HttpServletResponse ? (HttpServletResponse)response : null;
        if (this.enabled && requestHTTP != null && responseHTTP != null) {
            String requestURLString = ResponseURLFilter.extractRequestURLString(requestHTTP);
            String baseURLString = requestURLString.replaceAll("/[^/]*$", "");
            LOGGER.info("Wrapping response for URL filtering");
            chain.doFilter(request, (ServletResponse)new BaseURLFilterHttpServletResponse(responseHTTP, this.configURLString, baseURLString));
        } else {
            LOGGER.warn("Unable to to wrap response for URL filtering");
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    protected static String extractRequestURLString(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    private static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private final ServletOutputStream outputStream;
        private ByteBuffer find;
        private ByteBuffer replace;
        private boolean match;

        public ServletOutputStreamWrapper(ServletOutputStream outputStream, String find, String replace) {
            this.outputStream = outputStream;
            this.find = ByteBuffer.wrap(find.getBytes());
            this.replace = ByteBuffer.wrap(replace.getBytes());
        }

        public void write(int i) throws IOException {
            byte b = (byte)(i & 0xFF);
            if (this.match) {
                if (this.find.get() == b) {
                    if (!this.find.hasRemaining()) {
                        this.outputStream.write(this.replace.array());
                        this.match = false;
                    }
                } else {
                    this.outputStream.write(this.find.array(), 0, this.find.position() - 1);
                    this.outputStream.write((int)b);
                    this.match = false;
                }
            } else if (b == this.find.get(0)) {
                this.match = true;
                this.find.position(1);
            } else {
                this.outputStream.write((int)b);
            }
        }

        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        public void write(byte[] b, int o, int l) throws IOException {
            for (int i = 0; i < l; ++i) {
                this.write(b[o + i]);
            }
        }

        public void close() throws IOException {
            if (this.match) {
                this.outputStream.write(this.find.array(), 0, this.find.position());
                this.match = false;
            }
            super.close();
            this.outputStream.close();
        }

        public void flush() throws IOException {
            super.flush();
            this.outputStream.flush();
        }
    }

    private static class BaseURLFilterHttpServletResponse
    extends HttpServletResponseWrapper {
        private final String configURLString;
        public final String requestURLString;

        public BaseURLFilterHttpServletResponse(HttpServletResponse response, String configURLString, String requestURLString) {
            super(response);
            this.configURLString = configURLString;
            this.requestURLString = requestURLString;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            String contentType = this.getResponse().getContentType();
            if (contentType == null || contentType.startsWith("text/xml") || contentType.startsWith("application/xml")) {
                LOGGER.info("Content-type: {}, response URL filtering enabled for response to {}", (Object)contentType, (Object)this.requestURLString);
                return new ServletOutputStreamWrapper(this.getResponse().getOutputStream(), this.configURLString, this.requestURLString);
            }
            LOGGER.info("Content-type: {}, response URL filtering disabled for response to {}", (Object)contentType, (Object)this.requestURLString);
            return this.getResponse().getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter((OutputStream)this.getOutputStream());
        }
    }
}

