/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.utils.ConnectionManager;
import org.hibernate.SessionFactory;

public class DatabaseOperations {
    private String DBType = "";
    private static final String QueryPostgres = "select count(*) from (select * from \"%1$s\" limit 1) as a";
    private static final String QueryMysql = "select count(*) from (select * from `%1$s` limit 1) as a";
    private static final String explainQueryPostgres = "explain select * from \"%1$s\"";
    private static final String explainQueryMysql = "explain select * from `%1$s`";
    private static final String MYSQL = "MySQL";
    private static final String POSTGRES = "Postgres";

    public String getDBSchema(String configurationFile) throws Exception {
        File fl = new File(configurationFile);
        FileInputStream stream = new FileInputStream(fl);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((InputStream)stream);
        List nodes = document.selectNodes("//hibernate-configuration/session-factory/property");
        Iterator nodesIterator = nodes.iterator();
        String dbschema = "";
        while (nodesIterator.hasNext()) {
            String url;
            Node currentnode = (Node)nodesIterator.next();
            String element = currentnode.valueOf("@name");
            if (element.equals("connection.url")) {
                url = currentnode.getText();
                dbschema = url.substring(url.lastIndexOf("/") + 1);
                if (dbschema.indexOf(63) > 0) {
                    dbschema = dbschema.substring(0, dbschema.indexOf(63));
                }
                AnalysisLogger.getLogger().debug((Object)("DatabaseOperations->recovering the database's name: " + dbschema));
            }
            if (element.equals("connection.schemaname")) {
                url = currentnode.getText();
                dbschema = url.substring(url.lastIndexOf("/") + 1);
                if (dbschema.indexOf(63) > 0) {
                    dbschema = dbschema.substring(0, dbschema.indexOf(63));
                }
                AnalysisLogger.getLogger().debug((Object)("DatabaseOperations->recovering the schema's name: " + dbschema));
                this.DBType = POSTGRES;
            }
            if (!this.DBType.equals("")) continue;
            this.DBType = MYSQL;
        }
        stream.close();
        return dbschema;
    }

    public String getDBType() {
        return this.DBType;
    }

    public long calculateElements(ConnectionManager connection, String dbType, String tablename, SessionFactory session) throws Exception {
        Object element;
        ArrayList listvalues;
        Long numElemvalue;
        long numElem;
        long count = 0L;
        String countingQuery = null;
        if (dbType.equals(POSTGRES)) {
            countingQuery = String.format(QueryPostgres, tablename);
        }
        if (dbType.equals(MYSQL)) {
            countingQuery = String.format(QueryMysql, tablename);
        }
        AnalysisLogger.getLogger().debug((Object)("DatabaseOperations->calculating rows' number with the query: " + countingQuery));
        List<Object> result = connection.executeQuery(countingQuery, session);
        if (result != null && (numElem = (numElemvalue = Long.valueOf((listvalues = new ArrayList(((LinkedHashMap)(element = result.get(0))).values())).get(0).toString())).longValue()) > 0L) {
            AnalysisLogger.getLogger().debug((Object)"DatabaseOperations->the database has at least a row.Calculating rows' number through an estimation");
            String explain = null;
            if (dbType.equals(POSTGRES)) {
                explain = String.format(explainQueryPostgres, tablename);
            }
            if (dbType.equals(MYSQL)) {
                explain = String.format(explainQueryMysql, tablename);
            }
            AnalysisLogger.getLogger().debug((Object)("DatabaseOperations->calculating rows' number with the query: " + explain));
            List<Object> resultinfo = connection.executeQuery(explain, session);
            if (dbType.equals(MYSQL)) {
                Object elem = resultinfo.get(0);
                ArrayList values = new ArrayList(((LinkedHashMap)elem).values());
                BigInteger value = (BigInteger)values.get(8);
                count = value.longValue();
            }
            if (dbType.equals(POSTGRES)) {
                String var = resultinfo.get(0).toString();
                int beginindex = var.indexOf("rows");
                int lastindex = var.indexOf("width");
                var = var.substring(beginindex + 5, lastindex - 1);
                Long value = Long.valueOf(var);
                count = value;
            }
        }
        AnalysisLogger.getLogger().debug((Object)("DatabaseOperations->rows' number calculated: " + count));
        return count;
    }
}

