package org.gcube.dataaccess.databases.utils;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.ArrayList;
import java.util.LinkedHashMap;

import javax.xml.parsers.DocumentBuilderFactory;

/**
 * Class that allows to manage a database selected from a user. It performs to
 * set the database configuration, to connect to the database and finally to
 * execute a query.
 */
public class ConnectionManager {

	// private org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory df;

	// Constructor
	public ConnectionManager() {

		// org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory df = new
		// org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory();
		// df = new org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory();

	}

	// create the database's connection without using the configuration file but
	// using the data input
	public SessionFactory initDBConnection(AlgorithmConfiguration config) {

		SessionFactory dbconnection = DatabaseUtils.initDBSession(config);

		return dbconnection;

	}

	// create the database's connection using the configuration file
	public SessionFactory initDBConnection(String configurationFile)
			throws Exception {
		String xml = FileTools.readXMLDoc(configurationFile);
		SessionFactory DBSessionFactory = null;
		Configuration cfg = new Configuration();
		cfg = cfg.configure(DocumentBuilderFactory.newInstance()
				.newDocumentBuilder()
				.parse(new ByteArrayInputStream(xml.getBytes())));
		DBSessionFactory = cfg.buildSessionFactory();
		return DBSessionFactory;
	}

	/** Method that allows to set the configuration */
	public AlgorithmConfiguration setconfiguration(String ConfigPath,
			String DatabaseUserName, String DatabasePassword,
			String DatabaseDriver, String DatabaseDialect, String DatabaseURL,
			String DatabaseName) throws IOException {

		AlgorithmConfiguration config = new AlgorithmConfiguration();

		if (DatabaseName.equals("")) {

			throw new MalformedURLException(
					"Invalid Url: the database's name is not present");
			// return null;
		}

		if (!ConfigPath.equals(""))
			config.setConfigPath(ConfigPath);

		if (!DatabaseUserName.equals("")) {
			config.setParam("DatabaseUserName", DatabaseUserName);
		}

		if (!DatabasePassword.equals(""))
			config.setParam("DatabasePassword", DatabasePassword);

		if (!DatabaseDriver.equals(""))
			config.setParam("DatabaseDriver", DatabaseDriver);

		if (!DatabaseDialect.equals(""))
			config.setParam("DatabaseDialect", DatabaseDialect);

		if (!DatabaseURL.equals(""))
			config.setParam("DatabaseURL", DatabaseURL);

		return config;

	}

	/** Method that execute a query */
	public List<Object> executeQuery(String query,
			SessionFactory DBSessionFactory) throws Exception {

		List<Object> obj = null;
		Session ss = null;

		try {
			ss = DBSessionFactory.getCurrentSession();

			ss.beginTransaction();

			Query qr = null;

			// statement to check if the query is a "show create table"
			String keyword = "show create table";

			String regex = ".*\\b" + keyword.replaceAll(" +", "[ ]\\+")
					+ "\\b.*";

			if ((!(query.toLowerCase().contains("explain")))
					&& (!(query.toLowerCase().matches(regex)))) { // it does not
				// work if the
				// query
				// performs an
				// explain
				// operation

				// Wrapper for a query. It allows the query to operate in a
				// proper
				// way

				// query check in order to remove the character ";" if the query
				// contains it

				query = query.trim();

				if (query.endsWith(";")) {

					int endIndex = query.indexOf(";");

					query = query.substring(0, endIndex);

				}

				query = "select * from (" + query + ") as query";

			}

			AnalysisLogger.getLogger().debug(
					"In ConnectionManager-> executing query: " + query);

			qr = ss.createSQLQuery(query);

			qr.setResultTransformer(AliasToEntityOrderedMapResultTransformer.INSTANCE);

			// @SuppressWarnings("unchecked")
			List<Object> result = qr.list();

			AnalysisLogger.getLogger().debug(
					"In ConnectionManager-> result's size: " + result.size());

			ss.getTransaction().commit();

			/*
			 * if (result == null) System.out.println(
			 * "Hibernate doesn't return a valid object when org.gcube.contentmanagement.lexicalmatcher retrieve UserState Object"
			 * );
			 * 
			 * if (result != null && result.size() == 0)
			 * System.out.println(String.format("found nothing in database"));
			 */

			if (result != null && result.size() != 0) {

				obj = result;

			} else {

				AnalysisLogger.getLogger().debug(
						"ConnectionManager->Error: Result not available");

				throw new Exception("Result not available");

			}

		} catch (Exception e) {

			// e.printStackTrace();

			// System.out.println(String.format("Error while executing query: %1$s %2$s",
			// query, e.getMessage()));
			// e.printStackTrace();
			// System.out.println(String.format("Error while executing query: %1$s %2$s",
			// query, e.getMessage()));

			if (e.getClass().toString()
					.contains("org.hibernate.MappingException")) {

				// e.printStackTrace();

				// System.out.println(e.getClass().toString());

				AnalysisLogger
						.getLogger()
						.debug("In ConnectionManager-> ERROR The query could not be executed: Error in retrieving a user defined type. Try to use a store procedure to convert the type");

				throw new Exception(
						"The query could not be executed: Error in retrieving a user defined type. Try to use a store procedure to convert the type");
			}

			if (e.getClass().toString()
					.contains("org.hibernate.exception.SQLGrammarException")) {

				// System.out.println(e.getCause().getMessage());

				// AnalysisLogger.getLogger().debug("In ConnectionManager-> ERROR The query could not be executed: SQL grammar error in the query");

				// throw new
				// Exception("The query could not be executed: SQL grammar error in the query");

				AnalysisLogger.getLogger().debug(
						"In ConnectionManager-> "
								+ e.getCause().getLocalizedMessage());
				throw new Exception(e.getCause().getMessage());

			}

			else {

				throw e;

			}

			// throw e;
		}

		return obj;

	}

	// /** Method that creates the connection */
	// public SessionFactory createConnection(AlgorithmConfiguration config) {
	//
	// SessionFactory dbconnection = DatabaseUtils.initDBSession(config);
	//
	// return dbconnection;
	//
	// }

}
