package org.gcube.datatransfer.scheduler.db.model;

import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

@PersistenceCapable(table="TRANSFER_OUTCOMES")
public class TransferOutcome {
	
	private static final long serialVersionUID = 1L;
	@PrimaryKey	
	String transferOutcomesId;
	
	String submittedDateOfTransfer;
	String transferId;
	int numberOfOutcomeInThisTransfer;
	
	String fileName;
	String exception;
	String dest;
	String transferTime;
	boolean success;
	boolean failure;
	
	public TransferOutcome() {
		this.transferId=null;
		this.submittedDateOfTransfer = null;
		this.exception = null;
		this.fileName = null;
		this.dest = null;
		this.transferTime = null;
		this.success = false;
		this.failure = false;
		this.numberOfOutcomeInThisTransfer=0;
	}

	public int getNumberOfOutcomeInThisTransfer() {
		return numberOfOutcomeInThisTransfer;
	}

	public void setNumberOfOutcomeInThisTransfer(int numberOfOutcomeInThisTransfer) {
		this.numberOfOutcomeInThisTransfer = numberOfOutcomeInThisTransfer;
	}

	public String getTransferOutcomesId() {
		return transferOutcomesId;
	}

	public void setTransferOutcomesId(String transferOutcomesId) {
		this.transferOutcomesId = transferOutcomesId;
	}

	public String getTransferId() {
		return transferId;
	}

	public void setTransferId(String transferId) {
		this.transferId = transferId;
	}



	public String getSubmittedDateOfTransfer() {
		return submittedDateOfTransfer;
	}

	public void setSubmittedDateOfTransfer(String submittedDateOfTransfer) {
		this.submittedDateOfTransfer = submittedDateOfTransfer;
	}

	public String getException() {
		return exception;
	}

	public void setException(String exception) {
		this.exception = exception;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getDest() {
		return dest;
	}

	public void setDest(String dest) {
		this.dest = dest;
	}

	public String getTransferTime() {
		return transferTime;
	}

	public void setTransferTime(String transferTime) {
		this.transferTime = transferTime;
	}

	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	public boolean isFailure() {
		return failure;
	}

	public void setFailure(boolean failure) {
		this.failure = failure;
	}
	
	
	
}
