package org.gcube.datatransfer.scheduler.db.model;


import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

import java.net.URI;


@PersistenceCapable(table="TRANSFER_OBJECT")
public class TransferObject implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	@PrimaryKey	
	@Persistent(customValueStrategy="uuid")
	private String objectId;
	
	private URI uriLink;
	private Long size;
	
	//in case of storing in a remote node
	private String destUri;
		
	//	private Transfer transfer;
	private String transferid;

	public String getTransferid() {
		return transferid;
	}
	public void setTransferid(String transferid) {
		this.transferid = transferid;
	}
	public String getObjectId() {
		return objectId;
	}
	public void setObjectId(String objectId) {
		this.objectId = objectId;
	}


	public URI getSrcURI() {
		return uriLink;
	}
	public void setSrcURI(URI uriLink) {
		this.uriLink = uriLink;
	}
	public Long getSize() {
		return size;
	}
	public void setSize(Long size) {
		this.size = size;
	}
	public String getDestUri() {
		return destUri;
	}
	public void setDestUri(String destUri) {
		this.destUri = destUri;
	}
	
	
	

	


}
