package org.gcube.datatransfer.scheduler.db.model;

import java.util.List;

import javax.jdo.annotations.Join;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.PrimaryKey;



@PersistenceCapable(table="TRANSFER")
public class Transfer implements java.io.Serializable {
 

	private static final long serialVersionUID = 1L;
	
	@PrimaryKey	
	private String transferId;
	
	//type of schedule
	protected String typeOfScheduleId;
	
	protected String submitter;
	protected String status;
	protected String scope;
	protected String agentId;	
	
	//if the type is LocalFileBased then there is no need for having DataSource and DataStorages
	// in other case we check at least for data source
	protected String transferType;
	protected String typeOfStorage;
	
	protected String destinationFolder;
	protected boolean overwrite;
	protected boolean unzipFile;
	
	protected String sourceId;
	protected String storageId;
		
	protected List<String> outcomes;
	
 	//if Completed
	private String[] objectTrasferredIDs;
	private String[] objectFailedIDs;
	
	//if failed 
	public List<String> transferError;
	public String transferIdOfAgent;
		
	//"dd.MM.yy-HH.mm"
	String submittedDate; 
	
	//flag for knowing when the objs are stored at DB or not 
	public boolean readyObjects;
	
	public Transfer (){
		this.submitter=null;
		this.sourceId=null;
		this.storageId=null;
		this.agentId=null;
		this.typeOfScheduleId=null;
		this.status=null;
		this.objectTrasferredIDs=null;
		this.objectFailedIDs= null;
		this.transferError=null;
		this.transferIdOfAgent=null;
		this.scope=null;
		this.transferType=null;
		this.destinationFolder=null;
		this.overwrite=false;
		this.unzipFile=false;
		this.submittedDate=null;
		this.readyObjects=false;
		this.outcomes=null;
	}
	

	public List<String> getOutcomes() {
		return outcomes;
	}


	public void setOutcomes(List<String> outcomes) {
		this.outcomes = outcomes;
	}


	public String getTransferIdOfAgent() {
		return transferIdOfAgent;
	}
	public void setTransferIdOfAgent(String transferIdOfAgent) {
		this.transferIdOfAgent = transferIdOfAgent;
	}

	public String getTypeOfScheduleId() {
		return typeOfScheduleId;
	}
	public void setTypeOfScheduleId(String typeOfScheduleId) {
		this.typeOfScheduleId = typeOfScheduleId;
	}


	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getStorageId() {
		return storageId;
	}

	public void setStorageId(String storageId) {
		this.storageId = storageId;
	}

	public String getTransferId() {
		return transferId;
	}
	public String getAgentId() {
		return agentId;
	}

	public void setAgentId(String agentId) {
		this.agentId = agentId;
	}

	public void setTransferId(String transferId) {
		this.transferId = transferId;
	}
		public String getSubmitter() {
		return submitter;
	}
	public void setSubmitter(String submitter) {
		this.submitter = submitter;
	}

	
	public String[] getObjectTrasferredIDs() {
		return objectTrasferredIDs;
	}
	public void setObjectTrasferredIDs(String[] objectTrasferredIDs) {
		this.objectTrasferredIDs = objectTrasferredIDs;
	}


	public String[] getObjectFailedIDs() {
		return objectFailedIDs;
	}
	public void setObjectFailedIDs(String[] objectFailedIDs) {
		this.objectFailedIDs = objectFailedIDs;
	}

	public List<String> getTransferError() {
		return transferError;
	}
	public void setTransferError(List<String> transferError) {
		this.transferError = transferError;
	}

	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public String getScope() {
		return scope;
	}
	public void setScope(String scope) {
		this.scope = scope;
	}


	public String getTransferType() {
		return transferType;
	}


	public void setTransferType(String transferType) {
		this.transferType = transferType;
	}


	public String getDestinationFolder() {
		return destinationFolder;
	}
	public void setDestinationFolder(String destinationFolder) {
		this.destinationFolder = destinationFolder;
	}
	
	public boolean isOverwrite() {
		return overwrite;
	}
	public void setOverwrite(boolean overwrite) {
		this.overwrite = overwrite;
	}

	public boolean isUnzipFile() {
		return unzipFile;
	}
	public void setUnzipFile(boolean unzipFile) {
		this.unzipFile = unzipFile;
	}


	public String getSubmittedDate() {
		return submittedDate;
	}


	public void setSubmittedDate(String submittedDate) {
		this.submittedDate = submittedDate;
	}


	public boolean isReadyObjects() {
		return readyObjects;
	}
	public void setReadyObjects(boolean readyObjects) {
		this.readyObjects = readyObjects;
	}


	public String getTypeOfStorage() {
		return typeOfStorage;
	}


	public void setTypeOfStorage(String typeOfStorage) {
		this.typeOfStorage = typeOfStorage;
	}
	
	
	
}
