package org.gcube.datatransfer.scheduler.db.model;

import java.util.Calendar;

import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.PrimaryKey;

import org.gcube.datatransfer.scheduler.db.utils.Utils.FrequencyType;

@PersistenceCapable(table="PERIODICALLY_SCHEDULED")
public class PeriodicallyScheduled implements java.io.Serializable{

	private static final long serialVersionUID = 1L;
	
	@PrimaryKey	
	private String periodicallyScheduledId;
	
	//the startInstance is the point from when the schedule starts periodically..
	Calendar startInstance;
	//the frequency
	FrequencyType frequency;

	public PeriodicallyScheduled(){
		this.startInstance=null;
		this.frequency=null;
	}
	
	public FrequencyType getFrequency() {
		return frequency;
	}
	public void setFrequency(FrequencyType frequency) {
		this.frequency = frequency;
	}
	public Calendar getStartInstance() {
		return startInstance;
	}
	public void setStartInstance(Calendar startInstance) {
		this.startInstance = startInstance;
	}

	public String getPeriodicallyScheduledId() {
		return periodicallyScheduledId;
	}
	public void setPeriodicallyScheduledId(String periodicallyScheduledId) {
		this.periodicallyScheduledId = periodicallyScheduledId;
	}
	
	
	
}
