/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.messaging;

import java.io.IOException;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.datatransfer.common.messaging.messages.TransferMessage;
import org.gcube.datatransfer.common.messaging.messages.TransferRequestMessage;
import org.gcube.datatransfer.common.messaging.messages.TransferResponseMessage;
import org.gcube.datatransfer.common.messaging.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSGClient {
    public Logger logger = LoggerFactory.getLogger(this.getClass());

    protected MSGClient() throws IOException, GCUBEScopeNotSupportedException {
    }

    public void sendRequestMessage(GCUBEServiceContext context, TransferRequestMessage message, GCUBEScope ... scope) throws GHNClientModeException, IllegalArgumentException, Exception {
        try {
            message.setTimeNow();
            if (scope.length > 0) {
                message.createTopicName(scope[0]);
                message.setScope(scope[0].toString());
                this.sendMessage(message);
            } else {
                for (GCUBEScope sco : context.getInstance().getScopes().values()) {
                    message.createTopicName(sco);
                    message.setScope(sco.toString());
                    this.sendMessage(message);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error Sending Transfer message", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    public void sendResponseMessage(GCUBEServiceContext context, TransferResponseMessage message, GCUBEScope ... scope) throws GHNClientModeException, IllegalArgumentException, Exception {
        try {
            message.setTimeNow();
            if (scope.length > 0) {
                message.createTopicName(scope[0]);
                message.setScope(scope[0].toString());
                this.sendMessage(message);
            } else {
                for (GCUBEScope sco : context.getInstance().getScopes().values()) {
                    message.createTopicName(sco);
                    message.setScope(sco.toString());
                    this.sendMessage(message);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error Sending Transfer message", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    public void sendMessage(GCUBEServiceContext context, TransferMessage message, GCUBEScope ... scope) throws GHNClientModeException, IllegalArgumentException, Exception {
        try {
            message.setTimeNow();
            if (scope.length > 0) {
                message.createTopicName(scope[0]);
                message.setScope(scope[0].toString());
                this.sendMessage(message);
            } else {
                for (GCUBEScope sco : context.getInstance().getScopes().values()) {
                    message.createTopicName(sco);
                    message.setScope(sco.toString());
                    this.sendMessage(message);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error Sending Transfer message", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    private void sendMessage(GCUBEMessage message) {
        String source = this.getSource(message);
        String destination = this.getDestination(message);
        this.logger.debug("MSGClient is going to send a message from " + source + " to " + destination);
        Producer.getSingleton().sendMessageToQueue(message);
    }

    public String getSource(GCUBEMessage message) {
        String source = "";
        try {
            if (message instanceof TransferRequestMessage) {
                TransferRequestMessage req_msg = (TransferRequestMessage)message;
                source = req_msg.getSourceEndpoint();
            } else if (message instanceof TransferResponseMessage) {
                TransferResponseMessage res_msg = (TransferResponseMessage)message;
                source = res_msg.getSourceEndpoint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return source;
    }

    public String getDestination(GCUBEMessage message) {
        String destination = "";
        try {
            if (message instanceof TransferRequestMessage) {
                TransferRequestMessage req_msg = (TransferRequestMessage)message;
                destination = req_msg.getDestEndpoint();
            } else if (message instanceof TransferResponseMessage) {
                TransferResponseMessage res_msg = (TransferResponseMessage)message;
                destination = res_msg.getDestEndpoint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return destination;
    }

    public class GHNClientModeException
    extends Exception {
        private static final long serialVersionUID = 2107643850291448530L;

        public GHNClientModeException(String string) {
            super(string);
        }
    }
}

