/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.messaging;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.messaging.endpoints.BrokerNotConfiguredInScopeException;
import org.gcube.datatransfer.common.messaging.ConnectionsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrokerSubscription<LISTENER extends MessageListener>
extends Thread
implements ExceptionListener {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String subscriberEndpoint;
    protected DestinationPair pair;
    protected ArrayList<String> messageSelectors = new ArrayList();
    protected LISTENER listener;
    protected ArrayList<Connection> connections = new ArrayList();
    protected static boolean transacted = false;
    protected static int ackMode = 1;

    public abstract void setScope(GCUBEScope var1);

    public void subscribe() throws Exception {
        if (this.getDestinationPair().isQueue()) {
            this.setupQueueSubscription();
        }
    }

    public ArrayList<Connection> getConnections() {
        return this.connections;
    }

    public void setConnections(ArrayList<Connection> connections) {
        this.connections = connections;
    }

    public void setupQueueSubscription() throws Exception {
        if (ConnectionsManager.getBrokerRetriever(this.getDestinationPair().getScope()) != null) {
            for (String address : ConnectionsManager.getBrokerRetriever(this.getDestinationPair().getScope()).getEndpoints()) {
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(address);
                try {
                    QueueConnection connection = connectionFactory.createQueueConnection();
                    connection.setClientID(this.getDestinationPair().getDestinationName());
                    connection.start();
                    connection.setExceptionListener((ExceptionListener)this);
                    QueueSession session = connection.createQueueSession(transacted, ackMode);
                    Queue queue = session.createQueue(this.getDestinationPair().getDestinationName());
                    QueueReceiver consumer = null;
                    consumer = session.createReceiver(queue);
                    consumer.setMessageListener(this.listener);
                    this.connections.add((Connection)connection);
                }
                catch (JMSException e) {
                    this.logger.error("Error creating Queue Receiver", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error("Error creating Queue Receiver", (Throwable)e);
                    throw e;
                }
            }
        } else {
            this.logger.warn("Impossible to setup Queue Receiver, Broker addrress not specified for the scope: " + this.getDestinationPair().getScope().toString());
        }
        this.logger.info("Started Queue receveiver for topic: " + this.getDestinationPair().getDestinationName());
    }

    @Override
    public void run() {
        try {
            for (Connection connection : this.connections) {
                connection.stop();
                connection.close();
            }
            this.connections.clear();
        }
        catch (JMSException e) {
            this.logger.debug("Exception stopping the connection", (Throwable)e);
            this.connections.clear();
        }
        while (true) {
            try {
                this.subscribe();
                return;
            }
            catch (InvalidClientIDException ex) {
                this.logger.error("Subscription has not been reset", (Throwable)ex);
                return;
            }
            catch (Exception e) {
                this.logger.error("Error on subscription", (Throwable)e);
                try {
                    Thread.sleep(12000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    public void onException(JMSException exce) {
        this.logger.error(exce.getMessage());
        this.logger.error(exce.toString());
        this.run();
    }

    public BrokerSubscription(String subscriberEndpoint) {
        this.subscriberEndpoint = subscriberEndpoint;
    }

    public DestinationPair getDestinationPair() {
        return this.pair;
    }

    public void setDestinationPair(DestinationPair pair) {
        this.pair = pair;
    }

    public LISTENER getListener() {
        return this.listener;
    }

    public void setListener(LISTENER listener) {
        this.listener = listener;
    }

    public ArrayList<String> getMessageSelectors() {
        return this.messageSelectors;
    }

    public void setMessageSelectors(ArrayList<String> messageSelectors) {
        this.messageSelectors = messageSelectors;
    }

    public class DestinationPair {
        GCUBEScope scope;
        String destinationName;
        boolean queue = false;

        public GCUBEScope getScope() {
            return this.scope;
        }

        public void setScope(GCUBEScope scope) {
            try {
                ConnectionsManager.addScope(scope);
            }
            catch (BrokerNotConfiguredInScopeException e) {
                e.printStackTrace();
            }
            catch (GCUBEScopeNotSupportedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.scope = scope;
        }

        public String getDestinationName() {
            return this.destinationName;
        }

        public void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public boolean isQueue() {
            return this.queue;
        }

        public void setQueue(boolean queue) {
            this.queue = queue;
        }
    }
}

