/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.CopyStreamHandler;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class DataStorageTransferAsyncHandler
extends TransferHandler {
    public static int bufferSize = 1024000;
    private ExecutorService pool;
    protected String[] outputFiles = null;
    private long bytesTransferredForCurrent;
    CopyStreamListener listener = new CopyStreamListener(){

        public void bytesTransferred(long arg0, int arg1, long arg2) {
            try {
                ServiceContext.getContext().getDbManager().updateTransferObjectInfo(DataStorageTransferAsyncHandler.this.transferId, arg1);
                DataStorageTransferAsyncHandler.this.bytesTransferredForCurrent = DataStorageTransferAsyncHandler.this.bytesTransferredForCurrent + (long)arg1;
            }
            catch (Exception e) {
                DataStorageTransferAsyncHandler.this.logger.error((Object)"Error updating DB");
            }
        }

        public void bytesTransferred(CopyStreamEvent arg0) {
        }
    };

    public DataStorageTransferAsyncHandler(String[] inputFiles, String[] outputFiles, String transferId, TransferType type, DestData data, int startIndex, int endIndex) throws FileSystemException {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outputFiles = outputFiles;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            this.pool = Executors.newFixedThreadPool(1);
            long startTime = 0L;
            TransferObject transferObj = null;
            try {
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                transferObj.setDestURI(this.outputFiles[i]);
                FileObject inputFile = TransferUtils.prepareFileObject(this.inputFiles[i]);
                FileObject outputFile = TransferUtils.prepareFileObject(this.outputFiles[i]);
                this.logger.debug((Object)("Copy file from URL " + inputFile.getURL() + " to : " + outputFile.getURL()));
                if (outputFile.exists() && !this.destData.getOutUri().getOptions().isOverwrite()) {
                    this.logger.error((Object)"the file cannot be copied cause a file with the same name already exists");
                    throw new Exception("the file cannot be copied cause a  file with the same name already exists");
                }
                startTime = System.currentTimeMillis();
                boolean terminate = false;
                OutputStream destinationFileOut = outputFile.getContent().getOutputStream();
                InputStream sourceFileIn = inputFile.getContent().getInputStream();
                this.bytesTransferredForCurrent = 0L;
                CopyStreamHandler handler = new CopyStreamHandler(sourceFileIn, destinationFileOut, inputFile.getContent().getSize(), this.listener);
                try {
                    this.pool.execute(handler);
                    this.pool.shutdown();
                }
                catch (Exception e) {
                    this.pool.shutdownNow();
                    e.printStackTrace();
                    throw new Exception("Error while executing the transfer");
                }
                terminate = this.pool.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
                sourceFileIn.close();
                destinationFileOut.close();
                if (terminate) {
                    this.logger.debug((Object)("File succesfully copied to " + outputFile.getURL().toURI()));
                    transferObj.setSize(inputFile.getContent().getSize());
                    transferObj.setBytesOfObjTransferred(this.bytesTransferredForCurrent);
                    transferObj.setStatus(TransferStatus.DONE.name());
                    transferObj.setOutcome("File succesfully copied to " + outputFile.getURL().toURI());
                    continue;
                }
                String msg = "Transfer aborted because timeout has elapsed";
                this.logger.error((Object)msg);
                throw new Exception(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                transferObj.setBytesOfObjTransferred(0L);
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                this.transferObjs.add(transferObj);
            }
        }
    }
}

