/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.util;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;

public class Util {
    public static ResultItem cloneResultItem(ResultItem item) {
        if (item == null) {
            return null;
        }
        ResultItem clone = new ResultItem(item.getId(), item.getScientificName());
        Util.copyTaxon((Taxon)item, (Taxon)clone);
        clone.setCommonNames(Util.cloneCommonName(item.getCommonNames()));
        return clone;
    }

    protected static Taxon cloneTaxon(Taxon taxon) {
        if (taxon == null) {
            return null;
        }
        Taxon clone = new Taxon(taxon.getId(), taxon.getScientificName());
        Util.copyTaxon(taxon, clone);
        return clone;
    }

    protected static void copyTaxon(Taxon taxon, Taxon clone) {
        clone.setId(taxon.getId());
        clone.setScientificName(taxon.getScientificName());
        clone.setCitation(taxon.getCitation());
        clone.setCredits(taxon.getCredits());
        clone.setScientificNameAuthorship(taxon.getScientificNameAuthorship());
        clone.setRank(taxon.getRank());
        clone.setParent(Util.cloneTaxon(taxon.getParent()));
    }

    protected static List<CommonName> cloneCommonName(List<CommonName> commonNames) {
        if (commonNames == null) {
            return null;
        }
        ArrayList<CommonName> clones = new ArrayList<CommonName>(commonNames.size());
        for (CommonName commonName : commonNames) {
            clones.add(Util.cloneCommonName(commonName));
        }
        return clones;
    }

    protected static CommonName cloneCommonName(CommonName commonName) {
        if (commonName == null) {
            return null;
        }
        return new CommonName(commonName.getLanguage(), commonName.getName());
    }

    public static String stripNotValidXMLCharacters(String input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (char current : input.toCharArray()) {
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }
}

