/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis.capabilities;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.itis.Utils;
import org.gcube.data.spd.itis.dbconnection.ConnectionPool;
import org.gcube.data.spd.itis.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) {
        this.logger.trace((Object)"getSynonymnsById");
        ResultSet rs = null;
        ResultSet result = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select b.tsn from synonym_links as a NATURAL join longnames as b where a.tsn_accepted = ?";
            result = pool.selectPrestatement(query, id);
            if (result != null) {
                TaxonomyItem tax;
                String tsn = null;
                while (result.next() && (tax = this.retrieveTaxonById(tsn = result.getString(1))) != null && writer.isAlive()) {
                    writer.write((Object)tax);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"General Error", (Throwable)e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQL Error", (Throwable)e);
            }
        }
    }

    private String getFullName(String unit_name1, String unit_name2, String unit_name3, String unit_name4) {
        StringBuilder sName = new StringBuilder();
        if (unit_name1 != null) {
            sName.append(unit_name1);
            if (unit_name2 != null) {
                sName.append(" ");
                sName = sName.append(unit_name2);
                if (unit_name3 != null) {
                    sName.append(" ");
                    sName = sName.append(unit_name3);
                    if (unit_name4 != null) {
                        sName.append(" ");
                        sName = sName.append(unit_name4);
                    }
                }
            }
        }
        return sName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        block21: {
            ConnectionPool pool = null;
            Connection con = null;
            ResultSet results = null;
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                String query = "select a.tsn, a.completename, b.taxon_author_id, b.rank_id, b.update_date, b.name_usage, b.unaccept_reason, b.parent_tsn from longnames as a NATURAL join taxonomic_units as b where UPPER(a.completename) like UPPER(?)";
                results = pool.selectPrestatement(query, "%" + scientificName + "%");
                if (results == null) break block21;
                while (results.next()) {
                    try {
                        TaxonomyItem taxItem = this.createTaxItem(results.getString(1), results.getString(2), results.getString(3), results.getString(4), results.getString(5), results.getString(6), results.getString(7), results.getString(8), null, null, null, null, null, true);
                        if (writer.isAlive() && taxItem != null) {
                            writer.write((Object)taxItem);
                        }
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Exception", (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQLException", (Throwable)e);
            }
            catch (ConnectionPoolException e) {
                this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)"SQLException", (Throwable)e);
                }
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) {
        try {
            if (ids != null) {
                String id;
                this.logger.trace((Object)"ids!=null");
                TaxonomyItem tax = null;
                while (ids.hasNext() && (tax = this.retrieveTaxonById(id = ids.next())) != null && writer.isAlive()) {
                    writer.write((Object)tax);
                }
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyItem createTaxItem(String tsn, String completename, String author, String rank_id, String update_date, String status, String remarks, String parent_id, String citation_id, String unit_name1, String unit_name2, String unit_name3, String unit_name4, Boolean flag) throws SQLException, ParseException, ConnectionPoolException {
        TaxonomyItem tax = null;
        String rank = Utils.getInfoFromId(rank_id, "rank");
        String citation = Utils.getCitationItis();
        String credits = Utils.getCreditsItis();
        tax = new TaxonomyItem(tsn + "");
        if (completename != null) {
            tax.setScientificName(completename);
        } else {
            String sName = this.getFullName(unit_name1, unit_name2, unit_name3, unit_name4);
            tax.setScientificName(sName);
        }
        tax = this.setSources(tax, tsn);
        tax.setCredits(credits);
        tax.setCitation(citation);
        tax.setLsid("urn:lsid:itis.gov:itis_tsn:" + tsn);
        tax.setRank(rank);
        if (parent_id != null && flag.booleanValue() && !parent_id.equals("0")) {
            tax.setParent(this.retrieveTaxonById(parent_id));
        }
        tax.setCommonNames(Utils.getCommonNameFromId(tsn));
        if (author != null) {
            tax.setScientificNameAuthorship(Utils.getInfoFromId(author, "author"));
        }
        tax.setStatus(this.setTaxonomyStatus(status, remarks, tsn));
        List<String> comments = null;
        try {
            comments = this.retrieveComments(tsn);
            for (String comment : comments) {
                ElementProperty property = new ElementProperty("Comments", comment);
                tax.addProperty(property);
            }
        }
        finally {
            if (comments != null) {
                comments.clear();
            }
        }
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> retrieveComments(String tsn) throws ParseException, ConnectionPoolException {
        ResultSet rs = null;
        ConnectionPool pool = null;
        Connection con = null;
        ArrayList<String> comments = new ArrayList<String>();
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select comment_time_stamp, commentator, comment_detail from tu_comments_links as a JOIN comments as b where a.comment_id= b.comment_id and a.tsn = ?";
            rs = pool.selectPrestatement(query, tsn);
            if (rs != null) {
                StringBuilder comment = new StringBuilder();
                String time_stamp = null;
                String commentator = null;
                String comment_detail = null;
                while (rs.next()) {
                    time_stamp = rs.getString(1);
                    commentator = rs.getString(2);
                    comment_detail = rs.getString(3);
                    comment.append("Comment detail: ");
                    comment.append(comment_detail);
                    if (commentator != null) {
                        comment.append(" - Commentator: ");
                        comment.append(commentator);
                    }
                    if (time_stamp != null) {
                        comment.append(" - Date: ");
                        Date date = this.format.parse(time_stamp);
                        comment.append(this.format.format(date));
                    }
                    comments.add(comment.toString());
                    comment.delete(0, comment.length());
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"SQL Error", (Throwable)ex);
            }
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return comments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyItem setSources(TaxonomyItem tax, String id) throws ConnectionPoolException {
        ResultSet rs = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select a.source, a.version, a.source_type, a.acquisition_date from other_sources as a join reference_links as b on b.doc_id_prefix = a.source_id_prefix and b.documentation_id = a.source_id and b.tsn = ?";
            rs = pool.selectPrestatement(query, id);
            if (rs != null) {
                String source = null;
                String version = null;
                String source_type = null;
                String acquisition_date = null;
                while (rs.next()) {
                    source = rs.getString(1);
                    version = rs.getString(2);
                    source_type = rs.getString(3);
                    acquisition_date = rs.getString(4);
                    StringBuilder s = new StringBuilder();
                    if (source != null) {
                        s.append(source);
                    }
                    if (source_type != null) {
                        s.append(", ");
                        s.append(source_type);
                    }
                    if (acquisition_date != null) {
                        s.append(" (version ");
                        s.append(version);
                        s.append(").");
                    }
                    if (acquisition_date != null) {
                        s.append(" Acquired: ");
                        s.append(acquisition_date);
                        s.append(".");
                    }
                    ElementProperty property = new ElementProperty("Source", s.toString());
                    tax.addProperty(property);
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"SQL Error", (Throwable)ex);
            }
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return tax;
    }

    public TaxonomyStatus setTaxonomyStatus(String status, String notes, String id) {
        TaxonomyStatus tax = null;
        if (status != null) {
            if (status.equals("accepted")) {
                tax = new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED);
            } else if (notes.equals("synonym")) {
                tax = new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, this.getAcceptedTsn(id, null, null), "synonym");
            } else if (notes.equals("misapplied")) {
                tax = new TaxonomyStatus("misapplied", TaxonomyStatus.Status.MISAPPLIED);
            } else if (status.equals("invalid")) {
                tax = new TaxonomyStatus(TaxonomyStatus.Status.INVALID, this.getAcceptedTsn(id, null, null), "invalid");
            } else if (status.equals("valid")) {
                tax = new TaxonomyStatus("valid", TaxonomyStatus.Status.VALID);
            }
        }
        if (tax == null) {
            tax = new TaxonomyStatus(notes, TaxonomyStatus.Status.UNKNOWN);
        }
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAcceptedTsn(String tsn, ConnectionPool pool, Connection con) {
        String acceptTsn = "";
        ResultSet results = null;
        try {
            String query;
            if (pool == null) {
                pool = ConnectionPool.getConnectionPool();
            }
            if (con == null) {
                con = pool.getConnection();
            }
            if ((results = pool.selectPrestatement(query = "select tsn_accepted from synonym_links where tsn = ?", tsn)).next()) {
                acceptTsn = results.getString(1);
            }
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"SQL Error", (Throwable)ex);
            }
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return acceptTsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyItem retrieveTaxonById(String id) {
        TaxonomyItem tax = null;
        ResultSet result = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select a.tsn, a.completename, b.taxon_author_id, b.rank_id, b.update_date, b.name_usage, b.unaccept_reason, b.parent_tsn from longnames as a NATURAL join taxonomic_units as b where a.tsn = ?";
            result = pool.selectPrestatement(query, id);
            if (result != null && result.next()) {
                try {
                    tax = this.createTaxItem(result.getString(1), result.getString(2), result.getString(3), result.getString(4), result.getString(5), result.getString(6), result.getString(7), result.getString(8), null, null, null, null, null, true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQL Error", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException Error", (Throwable)e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQLException", (Throwable)e);
            }
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String id_parent) throws IdNotValidException, ExternalRepositoryException {
        ArrayList<TaxonomyItem> itemList = null;
        ResultSet results = null;
        ResultSet rs = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select a.tsn, b.unit_name1, b.unit_name2, b.unit_name3, b.unit_name4, b.taxon_author_id, b.rank_id, a.name_usage, a.unaccept_reason from taxonomic_units as a NATURAL join taxonomic_units as b where b.unaccept_reason ='' and a.parent_tsn = ? order by b.unit_name1";
            results = pool.selectPrestatement(query, id_parent);
            if (results != null) {
                itemList = new ArrayList<TaxonomyItem>();
                while (results.next()) {
                    try {
                        TaxonomyItem tax = this.createTaxItem(results.getString(1), null, results.getString(6), results.getString(7), null, results.getString(8), results.getString(9), null, null, results.getString(2), results.getString(3), results.getString(4), results.getString(5), false);
                        itemList.add(tax);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Exception", (Throwable)e);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQL Error", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"SQL Error", (Throwable)ex);
            }
        }
        return itemList;
    }
}

