/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.io.IOException;
import java.security.Key;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.spd.irmng.ClassificationCapabilityImpl;
import org.gcube.data.spd.irmng.UpdateThread;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPool;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.DataProvider;
import org.gcube.data.spd.model.DataSet;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.ResultItem;
import org.gcube.data.spd.model.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.util.RepositoryInfo;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class IrmngPlugin
extends AbstractPlugin {
    static GCUBELog logger = new GCUBELog(IrmngPlugin.class);
    public static String jdbc;
    public static String user;
    public static String password;
    public static String dumpUrl;
    static final String citation = "Accessed through: The Interim Register of Marine and Nonmarine Genera at http://www.obis.org.au/irmng/ on ";
    static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with the Interim Register of Marine and Nonmarine Genera (IRMNG) (http://www.obis.org.au/irmng/)";
    public static final String driver = "org.postgresql.Driver";
    public static final String dumpDb = "/createIrmngDb.sql";

    public void initialize(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (ap.name().equals("dump")) {
                dumpUrl = ap.address();
                continue;
            }
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            user = ap.username();
            password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
        }
        if (!(Utils.SQLTableExists("taxon") && Utils.SQLTableExists("speciesprofile") && Utils.SQLTableExists("updates"))) {
            try {
                logger.trace((Object)"create db");
                Utils.createDB();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"IOException", (Throwable)e);
            }
        }
        long update = UpdateThread.lastupdate();
        new UpdateThread(update);
        super.initialize(res);
    }

    public void update(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (ap.name().equals("dump")) {
                dumpUrl = ap.address();
                continue;
            }
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            user = ap.username();
            password = ap.password();
        }
        super.update(res);
    }

    public String getRepositoryName() {
        return "IRMNG";
    }

    public String getDescription() {
        return "Plugin for IRMNG";
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public void searchByCommonName(String commonName, ObjectWriter<ResultItem> writer, Property ... properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... properties) {
        logger.trace((Object)("searchByScientificName " + scientificName));
        ResultSet rs = null;
        try {
            rs = this.getRSByScName(scientificName);
            if (rs != null) {
                while (rs.next()) {
                    String citation;
                    String id = rs.getString(1);
                    String rank = rs.getString(2);
                    String idParent = rs.getString(3);
                    String author = rs.getString(4);
                    ResultItem item = this.createResultItem(id, rank, author, citation = rs.getString(5), idParent);
                    if (item == null || !writer.isAlive()) continue;
                    writer.write((Object)item);
                }
            }
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            writer.close();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getRSByScName(String scientificName) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String name = "%" + scientificName + "%";
            String query = "select taxonid, taxonrank, parentnameusageid, scientificnameauthorship, nameaccordingto from taxon where UPPER(scientificname) like UPPER(?)";
            results = pool.selectPrestatement(query, name);
        }
        catch (Throwable e) {
            logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultItem createResultItem(String id, String rank, String author, String citation, String idParent) {
        ResultItem item = null;
        try {
            ResultSet parentRS;
            item = new ResultItem(id, Utils.setScName(id, rank));
            item.setCredits(Utils.createCredits());
            StringBuilder cit = new StringBuilder();
            if (citation != null) {
                cit.append(citation);
                cit.append(". ");
            }
            cit.append(Utils.createCitation());
            item.setCitation(cit.toString());
            item.setAuthor(author);
            item.setRank(rank);
            DataSet dataSet = new DataSet(citation);
            dataSet.setName(citation);
            dataSet.setCitation(citation);
            DataProvider dp = new DataProvider("irmngid");
            dp.setName("IRMNG");
            dataSet.setDataProvider(dp);
            item.setDataSet(dataSet);
            if (rank != null && idParent != null && (parentRS = this.findTaxonById(idParent)).next()) {
                String citationP;
                String authorP;
                String idP = parentRS.getString(1);
                String rankP = parentRS.getString(2);
                ResultItem parent = this.createResultItem(idParent, rankP, authorP = parentRS.getString(3), citationP = parentRS.getString(4), idP);
                if (parent != null) {
                    item.setParent((Taxon)parent);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"ResultSet empty", (Throwable)e);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet findTaxonById(String idParent) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select parentnameusageid, scientificname, taxonrank, scientificnameauthorship from taxon where taxonid = ?";
            results = pool.selectPrestatement(query, idParent);
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException Error", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://www.cmar.csiro.au/datacentre/irmng/irmng-small.gif", "http://www.cmar.csiro.au/datacentre/irmng/", "The Interim Register of Marine and Nonmarine Genera (IRMNG) project, sponsored initially by OBIS Australia as a contribution to the international OBIS system, attempts to bring the content of extensive published genus-level compilations for botanical and zoological genus names, as well as smaller ones for prokaryotes and viruses, at least to certain cut-off points in time, into a common framework and fill residual gaps in genus-level coverage as apparent. Since its inception in 2006, the IRMNG data compilation has grown to include over 465,000 genus names as at mid 2012, covering all types of biota, both extant and fossil, out of an estimated 480,000-500,000 (+?) genus names ever published, the exact number being unclear because such a compilation has not been attempted previously. In addition, some 1.6 million species names have been included in the system as readily available, linked to their correct parent genus name instance so far as possible, to further assist the discrimination of marine from nonmarine taxa and to supply confirmation of correct spellings for species names as available.");
        return info;
    }
}

