/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis;

import java.security.Key;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.spd.asfis.Utils;
import org.gcube.data.spd.asfis.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.asfis.capabilities.NamesMappingImpl;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class AsfisPlugin
extends AbstractPlugin {
    public static String jdbc = "jdbc:postgresql://dl26.di.uoa.gr/";
    public static String username = "gcube";
    public static String password = "d4science";
    public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with ASFIS List of Species for Fishery Statistics Purposes (http://www.fao.org/fishery/collection/asfis/en)";
    public static final String citation = "Accessed through: ASFIS List of Species for Fishery Statistics Purposes at http://www.fao.org/fishery/collection/asfis/en on ";
    public static final String xslFile = "/ASFIS.xls";
    public static final String table = "asfis";
    public static final String driver = "org.postgresql.Driver";
    public static final String SPA = "Spanish";
    public static final String FRA = "French";
    public static final String ENG = "English";
    public static final String ARA = "Arabic";
    public static final String CHI = "Chinese";
    public static final String RUS = "Russian";
    public static final String STATUS = "Validated";
    GCUBELog logger = new GCUBELog(AsfisPlugin.class);

    public void initialize(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
        }
    }

    public void update(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = ap.password();
        }
        super.update(res);
    }

    public String getDescription() {
        return "ASFIS Plugin";
    }

    public String getRepositoryName() {
        return "ASFIS";
    }

    public void shutdown() throws Exception {
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.NamesMapping);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public MappingCapability getMappingInterface() {
        return new NamesMappingImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Condition ... properties) {
        block16: {
            this.logger.info((Object)("searching by ScientificName " + word));
            ResultSet results = null;
            try {
                results = Utils.createResultSetByName(word);
                if (results == null) break block16;
                while (results.next()) {
                    String id = results.getString(1);
                    String scientific_name = results.getString(2);
                    String author = results.getString(3);
                    String englishName = results.getString(4);
                    String frenchName = results.getString(5);
                    String spanishName = results.getString(6);
                    String arabic_name = results.getString(12);
                    String chinese_name = results.getString(13);
                    String russian_name = results.getString(14);
                    String parent_id = results.getString(7);
                    String taxocode = results.getString(8);
                    String isscaap = results.getString(9);
                    String threeA_CODE = results.getString(10);
                    String rank = results.getString(11);
                    this.logger.info((Object)("found ResultSet for " + scientific_name));
                    ResultItem rs = null;
                    try {
                        rs = this.createResultItem(id, scientific_name, author, englishName, frenchName, spanishName, parent_id, taxocode, isscaap, threeA_CODE, rank, arabic_name, chinese_name, russian_name);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Error retrieving information ", (Throwable)e);
                    }
                    if (writer.isAlive()) {
                        if (rs == null) continue;
                        writer.write(rs);
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
    }

    private ResultItem createResultItem(String id, String ScName, String author, String englishName, String frenchName, String spanishName, String parent_id, String taxocode, String isscaap, String threeA_CODE, String rank, String arabic_name, String chinese_name, String russian_name) {
        ResultItem item = new ResultItem(id, ScName);
        item.setRank(rank);
        item.setScientificNameAuthorship(author);
        if (englishName != null | frenchName != null | spanishName != null | arabic_name != null | chinese_name != null | russian_name != null) {
            item.setCommonNames(Utils.setCommonNames(englishName, frenchName, spanishName, arabic_name, chinese_name, russian_name));
        }
        item.setCitation(Utils.createCitation());
        item.setCredits(Utils.createCredits());
        DataSet dataSet = new DataSet("ASFISid");
        dataSet.setName("ASFIS");
        DataProvider dp = new DataProvider("ASFISid");
        dp.setName("ASFIS");
        dataSet.setDataProvider(dp);
        item.setDataSet(dataSet);
        item.setParent(this.createTaxonByID(parent_id));
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Taxon createTaxonByID(String id) {
        Taxon taxon;
        block17: {
            this.logger.info((Object)("createTaxonByID " + id));
            taxon = null;
            ResultSet results = null;
            try {
                String parent_id;
                results = Utils.createResultSetByID(id);
                if (results == null || !results.next() || id.equals(parent_id = results.getString(2))) break block17;
                try {
                    String scientific_name = results.getString(1);
                    this.logger.info((Object)("found ResultSet for " + scientific_name));
                    String rank = results.getString(3);
                    taxon = new Taxon(id, scientific_name);
                    taxon.setRank(rank);
                    taxon.setParent(this.createTaxonByID(parent_id));
                    taxon.setCitation(Utils.createCitation());
                    taxon.setCredits(Utils.createCredits());
                    Taxon taxon2 = taxon;
                    return taxon2;
                }
                catch (Exception e) {
                    try {
                        this.logger.error((Object)"Error retrieving information ", (Throwable)e);
                    }
                    catch (SQLException e2) {
                        this.logger.error((Object)"sql Error", (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
        return taxon;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://termportal.fao.org/faoas/as/pages/img/ftTermTitle_en.gif", "http://www.fao.org/fishery/collection/asfis/en/", "The FAO Fisheries and Aquaculture Statistics and Information Service (FIPS) collates world capture and aquaculture production statistics at either the species, genus, family or higher taxonomic levels in 2 119 statistical categories (2011 data) referred to as species items.");
        return info;
    }
}

