/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Scenario;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.gcube.data.simulfishgrowthdata.servlet.DatabaseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Scenario")
public class ScenarioUtil
extends BaseUtil {
    public final String additionalSimilarityConstraint = DatabaseFilter.additionalSimilarityConstraint;
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Scenario s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final Logger logger = LoggerFactory.getLogger(ScenarioUtil.class);

    @PUT
    @Consumes(value={"application/json"})
    public Response add(Scenario scenario) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil().add(scenario);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)scenario.getId()).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not add scenario [%s]", scenario), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response update(Scenario scenario) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil().update(scenario);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)scenario).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not update scenario [%s]", scenario), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil().delete(id);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not delete scenario [%s]", id), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Scenario getScenario(@PathParam(value="id") Long id) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil().getScenario(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve scenario [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<Scenario> getScenarios(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil().getScenarios(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve scenarios for ownerid [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/execute/{id}")
    @Produces(value={"application/json"})
    public Scenario executeScenario(@PathParam(value="id") Long id) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil().setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).executeScenario(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not execute scenario [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/execute/consumption/{from}/{to}/{weight}/{count}/{modelid}")
    @Produces(value={"application/json"})
    public String executeConsumptionScenario(@PathParam(value="from") String from, @PathParam(value="to") String to, @PathParam(value="weight") Integer weight, @PathParam(value="count") Integer count, @PathParam(value="modelid") Long modelId) throws Exception {
        return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil().setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).executeConsumptionScenario(from, to, weight, count, modelId);
    }
}

