@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\lib

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\jcommander-1.29.jar;"%REPO%"\log4j-1.2.16.jar;"%REPO%"\52n-wps-client-lib-3.0.jar;"%REPO%"\52n-wps-io-3.0.jar;"%REPO%"\commons-logging-1.0.4.jar;"%REPO%"\jts-1.10.jar;"%REPO%"\gt-main-2.7.4.jar;"%REPO%"\gt-api-2.7.4.jar;"%REPO%"\jdom-1.0.jar;"%REPO%"\gt-arcgrid-2.7.4.jar;"%REPO%"\imageio-ext-arcgrid-1.0.8.jar;"%REPO%"\imageio-ext-customstreams-1.0.8.jar;"%REPO%"\imageio-ext-utilities-1.0.8.jar;"%REPO%"\gt-xsd-gml3-2.7.4.jar;"%REPO%"\gt-xsd-gml2-2.7.4.jar;"%REPO%"\gt-coverage-2.7.4.jar;"%REPO%"\imageio-ext-tiff-1.0.8.jar;"%REPO%"\gt-referencing-2.7.4.jar;"%REPO%"\vecmath-1.3.2.jar;"%REPO%"\commons-pool-1.5.4.jar;"%REPO%"\gt-metadata-2.7.4.jar;"%REPO%"\gt-opengis-2.7.4.jar;"%REPO%"\jsr-275-1.0-beta-2.jar;"%REPO%"\gt-xsd-core-2.7.4.jar;"%REPO%"\gt-graph-2.7.4.jar;"%REPO%"\picocontainer-1.2.jar;"%REPO%"\xml-apis-1.0.b2.jar;"%REPO%"\xercesImpl-2.7.1.jar;"%REPO%"\xml-apis-xerces-2.7.1.jar;"%REPO%"\commons-jxpath-1.3.jar;"%REPO%"\commons-collections-3.1.jar;"%REPO%"\common-2.6.0.jar;"%REPO%"\ecore-2.6.1.jar;"%REPO%"\xsd-2.6.0.jar;"%REPO%"\gt-xsd-kml-2.7.4.jar;"%REPO%"\gt-xml-2.7.4.jar;"%REPO%"\gt-xsd-wfs-2.7.4.jar;"%REPO%"\gt-xsd-filter-2.7.4.jar;"%REPO%"\gt-xsd-fes-2.7.4.jar;"%REPO%"\gt-xsd-ows-2.7.4.jar;"%REPO%"\net.opengis.wfs-2.7.4.jar;"%REPO%"\net.opengis.ows-2.7.4.jar;"%REPO%"\org.w3.xlink-2.7.4.jar;"%REPO%"\gt-geotiff-2.7.4.jar;"%REPO%"\gt-epsg-hsql-2.7.4.jar;"%REPO%"\hsqldb-1.8.0.7.jar;"%REPO%"\gmlpacket-2.0-0.4.jar;"%REPO%"\commons-io-1.3.1.jar;"%REPO%"\jai_codec-1.1.3.jar;"%REPO%"\jai_core-1.1.3.jar;"%REPO%"\jai_imageio-1.1.jar;"%REPO%"\52n-wps-commons-3.0.jar;"%REPO%"\52n-wps-config-1.0.5.jar;"%REPO%"\commons-lang-2.5.jar;"%REPO%"\ogckml2.2-1.0.0.jar;"%REPO%"\axis-1.4.jar;"%REPO%"\axis-jaxrpc-1.4.jar;"%REPO%"\axis-saaj-1.4.jar;"%REPO%"\axis-wsdl4j-1.5.1.jar;"%REPO%"\commons-discovery-0.2.jar;"%REPO%"\gt-shapefile-2.7.4.jar;"%REPO%"\gt-data-2.7.4.jar;"%REPO%"\xalan-2.7.1.jar;"%REPO%"\serializer-2.7.1.jar;"%REPO%"\commons-httpclient-3.1.jar;"%REPO%"\commons-codec-1.5.jar;"%REPO%"\52n-wps-xml-1.0.0.jar;"%REPO%"\xmlbeans-2.4.0.jar;"%REPO%"\stax-api-1.0.1.jar;"%REPO%"\jsr173_api-1.0.jar;"%REPO%"\wps-client-1.0.0-4.12.1-126103.jar
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% -Xms500m -Xmx500m -XX:PermSize=128m -XX:-UseGCOverheadLimit -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="wpsclient" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" com.terradue.wps_hadoop.client.demo.WPSClientCL %CMD_LINE_ARGS%
if ERRORLEVEL 1 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
