/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.NullFilter;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.filter.FilterComplexTypes;
import org.geotools.xml.filter.FilterEncodingPreProcessor;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.Disjoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterOpsComplexTypes {
    private static final int SPATIAL_TYPE = 0;
    private static final int COMPARE_TYPE = 1;
    private static final int LOGIC_TYPE = 2;
    private static final int FID_TYPE = 3;

    protected static void encodeFilter(Filter filter, PrintHandler output, Map hints) throws OperationNotSupportedException, IOException {
        if (filter instanceof LogicFilter) {
            FilterType.elems[2].getType().encode(FilterType.elems[2], filter, output, hints);
        } else if (filter instanceof CompareFilter) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else if (filter instanceof FidFilter) {
            FilterType.elems[3].getType().encode(FilterType.elems[3], filter, output, hints);
        } else if (filter instanceof GeometryFilter) {
            FilterType.elems[0].getType().encode(FilterType.elems[0], filter, output, hints);
        } else if (filter instanceof LikeFilter) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else if (filter instanceof NullFilter) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else {
            throw new OperationNotSupportedException("The Filter type is not known: please try again. " + filter == null ? "null" : filter.getClass().getName());
        }
    }

    protected static void encodeExpr(org.geotools.filter.Expression expr, PrintHandler output, Map hints) throws OperationNotSupportedException, IOException {
        int i = 0;
        switch (expr.getType()) {
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                i = 36;
                break;
            }
            case 105: {
                i = 29;
                break;
            }
            case 106: {
                i = 30;
                break;
            }
            case 107: {
                i = 31;
                break;
            }
            case 108: {
                i = 32;
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: {
                i = 34;
                break;
            }
            case 114: {
                i = 35;
            }
        }
        if (i != 0) {
            FilterSchema.getInstance().getElements()[i].getType().encode(FilterSchema.getInstance().getElements()[i], expr, output, hints);
        }
    }

    public static class UnaryLogicOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new UnaryLogicOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance())};
        private static Choice choice = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return LogicOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            String name = element.getName();
            if ("and".equalsIgnoreCase(name)) {
                int type = 2;
            } else if ("or".equalsIgnoreCase(name)) {
                boolean type = true;
            } else if ("not".equalsIgnoreCase(name)) {
                int type = 3;
            } else {
                throw new SAXException("Expected AND or OR logic filter");
            }
            if (value == null || value.length != 1) {
                throw new SAXException("Require a single filter for " + element);
            }
            try {
                org.geotools.filter.Filter filter = (org.geotools.filter.Filter)value[0].getValue();
                return factory.not((Filter)filter);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Require a single filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "UnaryLogicOpType";
        }

        public Class getInstanceType() {
            return LogicFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3800000L) != 0x3800000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LogicFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LogicFilter lf = (LogicFilter)value;
            Iterator i = lf.getFilterIterator();
            output.startElement(element.getNamespace(), element.getName(), null);
            int c = 0;
            while (i.hasNext()) {
                if (c < 1) {
                    org.geotools.filter.Filter f = (org.geotools.filter.Filter)i.next();
                    FilterOpsComplexTypes.encodeFilter(f, output, hints);
                    ++c;
                    continue;
                }
                throw new OperationNotSupportedException("Invalid Not Filter -- more than one child filter.");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinaryLogicOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BinaryLogicOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance())};
        private static Choice choice = new ChoiceGT(null, 2, Integer.MAX_VALUE, elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return LogicOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            int type;
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            String name = element.getName();
            if ("and".equalsIgnoreCase(name)) {
                type = 2;
            } else if ("or".equalsIgnoreCase(name)) {
                type = 1;
            } else {
                throw new SAXException("Expected AND or OR logic filter");
            }
            try {
                ArrayList<org.geotools.filter.Filter> children = new ArrayList<org.geotools.filter.Filter>(value.length);
                HashSet ids = new HashSet(value.length);
                boolean fidOnly = true;
                for (int i = 0; i < value.length; ++i) {
                    org.geotools.filter.Filter filter = (org.geotools.filter.Filter)((Object)value[i]);
                    if (filter instanceof Id) {
                        Id id = (Id)filter;
                        ids.addAll(id.getIdentifiers());
                    } else {
                        fidOnly = false;
                    }
                    children.add(filter);
                }
                if (type == 1) {
                    if (fidOnly) {
                        return factory.id(ids);
                    }
                    return factory.or(children);
                }
                return factory.and(children);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "BinaryLogicOpType";
        }

        public Class getInstanceType() {
            return LogicFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3800000L) != 0x3800000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LogicFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LogicFilter lf = (LogicFilter)value;
            Iterator i = lf.getFilterIterator();
            output.startElement(element.getNamespace(), element.getName(), null);
            while (i.hasNext()) {
                org.geotools.filter.Filter f = (org.geotools.filter.Filter)i.next();
                FilterOpsComplexTypes.encodeFilter(f, output, hints);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class DistanceType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new DistanceType();
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("units", XSISimpleTypes.String.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isMixed() {
            return true;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                org.geotools.filter.Expression geometry1 = (org.geotools.filter.Expression)value[0].getValue();
                org.geotools.filter.Expression geometry2 = (org.geotools.filter.Expression)value[1].getValue();
                Literal literal = (Literal)value[2];
                double distance = ((Number)literal.getValue()).doubleValue();
                return factory.dwithin((Expression)geometry1, (Expression)geometry2, distance, null);
            }
            catch (ClassCastException wrong) {
                throw new SAXException(wrong);
            }
            catch (IllegalFilterException illegalFilterException) {
                throw new SAXException(illegalFilterException);
            }
        }

        public String getName() {
            return "DistanceType";
        }

        public Class getInstanceType() {
            return GeometryDistanceFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 0x600L) != 1536L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryDistanceFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryDistanceFilter distanceFilter = (GeometryDistanceFilter)value;
            AttributesImpl ai = new AttributesImpl();
            String name = attrs[0].getName();
            String uri = this.getNamespace().toString();
            if (distanceFilter.getLeftGeometry().getType() == 104) {
                Geometry geometry = (Geometry)distanceFilter.getLeftGeometry().getValue(null);
                if (geometry.getUserData() != null) {
                    String srsName = String.valueOf(geometry.getUserData());
                    ai.addAttribute(uri, name, null, "string", srsName);
                }
            } else {
                Geometry geometry = (Geometry)distanceFilter.getRightGeometry().getValue(null);
                if (geometry.getUserData() != null) {
                    String srsName = String.valueOf(geometry.getUserData());
                    ai.addAttribute(uri, name, null, "string", srsName);
                }
            }
            output.startElement(element.getNamespace(), element.getName(), null);
            output.characters("" + distanceFilter.getDistance());
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class DistanceBufferType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new DistanceBufferType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), GMLSchema.getInstance().getElements()[29], new FilterSchema.FilterElement("Distance", DistanceType.getInstance())};
        private Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return this.seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                org.geotools.filter.Expression geometry1 = (org.geotools.filter.Expression)value[0].getValue();
                org.geotools.filter.Expression geometry2 = (org.geotools.filter.Expression)value[1].getValue();
                Literal literal = (Literal)value[2];
                double distance = ((Number)literal.getValue()).doubleValue();
                return factory.beyond((Expression)geometry1, (Expression)geometry2, distance, null);
            }
            catch (ClassCastException wrong) {
                throw new SAXException(wrong);
            }
            catch (IllegalFilterException illegalFilterException) {
                throw new SAXException(illegalFilterException);
            }
        }

        public String getName() {
            return "DistanceBufferType";
        }

        public Class getInstanceType() {
            return GeometryDistanceFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 0x600L) != 1536L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryDistanceFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryDistanceFilter lf = (GeometryDistanceFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            if (lf.getLeftGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getLeftGeometry(), output, hints);
                elems[1].getType().encode(elems[1], lf.getRightGeometry().getValue(null), output, hints);
                elems[2].getType().encode(elems[2], lf, output, hints);
            } else if (lf.getRightGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getRightGeometry(), output, hints);
                elems[1].getType().encode(elems[1], lf.getLeftGeometry().getValue(null), output, hints);
                elems[2].getType().encode(elems[2], lf, output, hints);
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BBOXType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BBOXType();
        private static final Element OGC_PROPERTY_NAME = new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance());
        private static final Element GML_BOX = GMLSchema.getInstance().getElements()[41];
        private static Element[] elems = new Element[]{OGC_PROPERTY_NAME, GML_BOX};
        private Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return this.seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 2) {
                throw new SAXException("ogc:propertyName or gml:box required for bbox filter");
            }
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Object literal;
                org.geotools.filter.Expression geometry1 = (org.geotools.filter.Expression)value[0].getValue();
                org.geotools.filter.Expression geometry2 = (org.geotools.filter.Expression)value[1].getValue();
                if (geometry2 instanceof Literal && (literal = ((Literal)geometry2).getValue()) instanceof Geometry) {
                    Geometry geometry = (Geometry)literal;
                    Envelope env = geometry.getEnvelopeInternal();
                    return factory.bbox((Expression)geometry1, env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), null);
                }
                Disjoint disjoint = factory.disjoint((Expression)geometry1, (Expression)geometry2);
                return factory.not((Filter)disjoint);
            }
            catch (ClassCastException wrong) {
                throw new SAXException("ogc:propertyName or gml:box required for bbox filter", wrong);
            }
            catch (IllegalFilterException illegalFilterException) {
                throw new SAXException("Could not create bbox filter", illegalFilterException);
            }
        }

        public String getName() {
            return "BBOXType";
        }

        public Class getInstanceType() {
            return org.geotools.filter.Filter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 1L) != 1L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryFilter lf = (GeometryFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            if (lf.getLeftGeometry().getType() == 104) {
                elems[0].getType().encode(elems[0], lf.getRightGeometry(), output, hints);
                Geometry g = ((Geometry)((LiteralExpression)lf.getLeftGeometry()).getLiteral()).getEnvelope();
                elems[1].getType().encode(elems[1], g, output, hints);
            } else if (lf.getRightGeometry().getType() == 104) {
                elems[0].getType().encode(elems[0], lf.getLeftGeometry(), output, hints);
                Geometry g = ((Geometry)((LiteralExpression)lf.getRightGeometry()).getLiteral()).getEnvelope();
                elems[1].getType().encode(elems[1], g, output, hints);
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name : BBOXType");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinarySpatialOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BinarySpatialOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), GMLSchema.getInstance().getElements()[29], GMLSchema.getInstance().getElements()[41]};
        private static Sequence child = new SequenceGT(new ElementGrouping[]{elems[0], new ChoiceGT(new Element[]{elems[1], elems[2]})});

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return child;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                short type = SpatialOpsType.findFilterType(element.getName());
                org.geotools.filter.Expression geometry1 = (org.geotools.filter.Expression)value[0].getValue();
                org.geotools.filter.Expression geometry2 = (org.geotools.filter.Expression)value[1].getValue();
                switch (type) {
                    case 5: {
                        return factory.equal((Expression)geometry1, (Expression)geometry2);
                    }
                    case 6: {
                        return factory.disjoint((Expression)geometry1, (Expression)geometry2);
                    }
                    case 7: {
                        return factory.intersects((Expression)geometry1, (Expression)geometry2);
                    }
                    case 9: {
                        return factory.crosses((Expression)geometry1, (Expression)geometry2);
                    }
                    case 10: {
                        return factory.within((Expression)geometry1, (Expression)geometry2);
                    }
                    case 11: {
                        return factory.contains((Expression)geometry1, (Expression)geometry2);
                    }
                    case 12: {
                        return factory.overlaps((Expression)geometry1, (Expression)geometry2);
                    }
                    case 8: {
                        return factory.touches((Expression)geometry1, (Expression)geometry2);
                    }
                }
                throw new SAXException("Illegal filter for " + element);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "BinarySpatialOpType";
        }

        public Class getInstanceType() {
            return GeometryFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities")) {
                FilterCapabilities fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities");
                FilterCapabilities elementkey = FilterCapabilities.findOperation((String)element.getName());
                if (elementkey == null || !fc.supports(elementkey)) {
                    return false;
                }
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryFilter lf = (GeometryFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            if (lf.getLeftGeometry().getType() == 103 || lf.getLeftGeometry().getType() == 111 || lf.getLeftGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getLeftGeometry(), output, hints);
                if (lf.getRightGeometry().getType() == 104) {
                    elems[1].getType().encode(elems[1], ((LiteralExpression)lf.getRightGeometry()).getLiteral(), output, hints);
                } else {
                    elems[2].getType().encode(elems[2], ((LiteralExpression)lf.getRightGeometry()).getLiteral(), output, hints);
                }
            } else if (lf.getRightGeometry().getType() == 103 || lf.getRightGeometry().getType() == 111 || lf.getRightGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getRightGeometry(), output, hints);
                if (lf.getLeftGeometry().getType() == 104) {
                    elems[1].getType().encode(elems[1], ((LiteralExpression)lf.getLeftGeometry()).getLiteral(), output, hints);
                } else {
                    elems[2].getType().encode(elems[2], ((LiteralExpression)lf.getLeftGeometry()).getLiteral(), output, hints);
                }
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name l=" + lf.getLeftGeometry().getType() + " r=" + lf.getRightGeometry().getType());
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class UpperBoundaryType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new UpperBoundaryType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance())};
        private static Sequence choice = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return (org.geotools.filter.Expression)value[0].getValue();
        }

        public String getName() {
            return "UpperBoundaryType";
        }

        public Class getInstanceType() {
            return org.geotools.filter.Expression.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof org.geotools.filter.Expression;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            org.geotools.filter.Expression lf = (org.geotools.filter.Expression)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class LowerBoundaryType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new LowerBoundaryType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance())};
        private static Choice choice = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return (org.geotools.filter.Expression)value[0].getValue();
        }

        public String getName() {
            return "LowerBoundaryType";
        }

        public Class getInstanceType() {
            return org.geotools.filter.Expression.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof org.geotools.filter.Expression;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            org.geotools.filter.Expression lf = (org.geotools.filter.Expression)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsBetweenType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsBetweenType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance()), new FilterSchema.FilterElement("LowerBoundary", LowerBoundaryType.getInstance()), new FilterSchema.FilterElement("UpperBoundary", UpperBoundaryType.getInstance())};
        private static Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                org.geotools.filter.Expression left = (org.geotools.filter.Expression)value[1].getValue();
                org.geotools.filter.Expression middle = (org.geotools.filter.Expression)value[0].getValue();
                org.geotools.filter.Expression right = (org.geotools.filter.Expression)value[2].getValue();
                return factory.between((Expression)middle, (Expression)left, (Expression)right);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "PropertyIsBetweenType";
        }

        public Class getInstanceType() {
            return BetweenFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x1000L) != 4096L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof BetweenFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            BetweenFilter lf = (BetweenFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf.getMiddleValue(), output, hints);
            elems[1].getType().encode(elems[1], lf.getLeftValue(), output, hints);
            elems[2].getType().encode(elems[2], lf.getRightValue(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsNullType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsNullType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), new FilterSchema.FilterElement("Literal", FilterComplexTypes.LiteralType.getInstance())};
        private static Choice seq = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                org.geotools.filter.Expression expr = (org.geotools.filter.Expression)value[0].getValue();
                return factory.isNull((Expression)expr);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "PropertyIsNullType";
        }

        public Class getInstanceType() {
            return NullFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x2000L) != 8192L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof NullFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            NullFilter lf = (NullFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            elems[0].getType().encode(elems[0], lf.getNullCheckValue(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsLikeType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsLikeType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), new FilterSchema.FilterElement("Literal", FilterComplexTypes.LiteralType.getInstance())};
        private static Sequence seq = new SequenceGT(elems);
        private static Attribute[] attr = new Attribute[]{new FilterSchema.FilterAttribute("wildCard", XSISimpleTypes.String.getInstance(), 2), new FilterSchema.FilterAttribute("singleChar", XSISimpleTypes.String.getInstance(), 2), new FilterSchema.FilterAttribute("escape", XSISimpleTypes.String.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Attribute[] getAttributes() {
            return attr;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                org.geotools.filter.Expression expr = (org.geotools.filter.Expression)value[0].getValue();
                String wildCard = attrs.getValue("wildCard");
                String singleChar = attrs.getValue("singleChar");
                String escape = attrs.getValue("escape");
                Literal pattern = (Literal)value[1].getValue();
                return factory.like((Expression)expr, (String)pattern.getValue(), wildCard, singleChar, escape);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "PropertyIsLikeType";
        }

        public Class getInstanceType() {
            return LikeFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x800L) != 2048L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LikeFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LikeFilter lf = (LikeFilter)value;
            AttributesImpl at = new AttributesImpl();
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "wildCard", null, "string", lf.getWildcardMulti());
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "singleChar", null, "string", lf.getWildcardSingle());
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "escape", null, "string", lf.getEscape());
            output.startElement(element.getNamespace(), element.getName(), at);
            elems[0].getType().encode(elems[0], lf.getValue(), output, hints);
            elems[1].getType().encode(elems[1], lf.getPattern(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinaryComparisonOpType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new BinaryComparisonOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance()){

            public int getMaxOccurs() {
                return 2;
            }

            public int getMinOccurs() {
                return 2;
            }
        }};
        private static Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                short type = ComparisonOpsType.findFilterType(element.getName());
                org.geotools.filter.Expression expr1 = (org.geotools.filter.Expression)value[0].getValue();
                org.geotools.filter.Expression expr2 = (org.geotools.filter.Expression)value[1].getValue();
                switch (type) {
                    case 14: {
                        return factory.equals((Expression)expr1, (Expression)expr2);
                    }
                    case 23: {
                        return factory.notEqual((Expression)expr1, (Expression)expr2);
                    }
                    case 16: {
                        return factory.greater((Expression)expr1, (Expression)expr2);
                    }
                    case 18: {
                        return factory.greaterOrEqual((Expression)expr1, (Expression)expr2);
                    }
                    case 15: {
                        return factory.less((Expression)expr1, (Expression)expr2);
                    }
                    case 17: {
                        return factory.lessOrEqual((Expression)expr1, (Expression)expr2);
                    }
                }
                throw new SAXException("Illegal filter for " + element);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "BinaryComparisonOpType";
        }

        public Class getInstanceType() {
            return CompareFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3F4000L) != 4145152L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof CompareFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            CompareFilter cf = (CompareFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(cf.getLeftValue(), output, hints);
            FilterOpsComplexTypes.encodeExpr(cf.getRightValue(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class FeatureIdType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new FeatureIdType();
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("fid", XSISimpleTypes.AnyURI.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length != 0) {
                throw new SAXException("Invalid children: more than 0 ... " + value.length);
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            String fid = null;
            fid = attrs1.getValue("", attrs[0].getName());
            if (fid == null || "".equals(fid)) {
                fid = attrs1.getValue(attrs[0].getNamespace().toString(), attrs[0].getName());
            }
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            HashSet<FeatureId> fids = new HashSet<FeatureId>();
            fids.add(ff.featureId(fid));
            return ff.id(fids);
        }

        public String getName() {
            return "FeatureIdType";
        }

        public Class getInstanceType() {
            return Id.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Id;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            FidFilter ff = (FidFilter)value;
            String[] fids = ff.getFids();
            AttributesImpl att = new AttributesImpl();
            att.addAttribute(null, null, null, null, null);
            output.startElement(element.getNamespace(), "Filter", null);
            for (int i = 0; i < fids.length; ++i) {
                att.setAttribute(0, element.getNamespace().toString(), attrs[0].getName(), null, "anyUri", fids[i]);
                output.element(element.getNamespace(), element.getName(), att);
            }
            output.endElement(element.getNamespace(), "Filter");
        }
    }

    public static class FilterType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        static final Element[] elems = new Element[]{new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance()), new FilterSchema.FilterElement("FeatureId", FeatureIdType.getInstance()){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        }};
        private static Choice choice = new ChoiceGT(elems);
        private static final ComplexType instance = new FilterType();

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1) {
                return value[0].getValue();
            }
            if (value.length == 0) {
                return org.geotools.filter.Filter.EXCLUDE;
            }
            try {
                FilterFactory2 fac = CommonFactoryFinder.getFilterFactory2(null);
                ArrayList<Filter> filters = new ArrayList<Filter>();
                HashSet ids = new HashSet();
                boolean isOnlyFids = true;
                for (int i = 0; i < value.length; ++i) {
                    Filter value2 = (Filter)value[i].getValue();
                    if (value2 == org.geotools.filter.Filter.EXCLUDE) continue;
                    if (value2 instanceof Id) {
                        Id idFilter = (Id)value2;
                        ids.addAll(idFilter.getIdentifiers());
                    } else {
                        isOnlyFids = false;
                    }
                    filters.add(value2);
                }
                if (isOnlyFids && !ids.isEmpty()) {
                    return fac.id(ids);
                }
                if (filters.isEmpty()) {
                    return org.geotools.filter.Filter.EXCLUDE;
                }
                if (filters.size() == 1) {
                    return filters.iterator().next();
                }
                return fac.or(filters);
            }
            catch (IllegalFilterException e) {
                return value[0].getValue();
            }
        }

        public String getName() {
            return "FilterType";
        }

        public Class getInstanceType() {
            return org.geotools.filter.Filter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0L && fc.getSpatialOps() == 0L) {
                return false;
            }
            boolean r = element != null && element.getType() != null && this.getName().equals(element.getType().getName());
            r = r && value != null && value instanceof org.geotools.filter.Filter && ((org.geotools.filter.Filter)value).getFilterType() != 0;
            return r;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            org.geotools.filter.Filter filter = (org.geotools.filter.Filter)value;
            if (filter == null) {
                return;
            }
            if (filter == org.geotools.filter.Filter.NONE) {
                return;
            }
            if (filter == org.geotools.filter.Filter.ALL) {
                return;
            }
            if (element != null) {
                output.startElement(element.getNamespace(), element.getName(), null);
            }
            FilterEncodingPreProcessor visitor = this.getFilterEncodingPreProcessor(hints);
            filter.accept(visitor);
            if (!visitor.getFilter().equals(org.geotools.filter.Filter.EXCLUDE)) {
                FilterOpsComplexTypes.encodeFilter(visitor.getFilter(), output, hints);
            }
            if (!visitor.getFidFilter().getIDs().isEmpty()) {
                FilterOpsComplexTypes.encodeFilter(visitor.getFidFilter(), output, hints);
            }
            if (element != null) {
                output.endElement(element.getNamespace(), element.getName());
            }
        }

        private FilterEncodingPreProcessor getFilterEncodingPreProcessor(Map hints) {
            if (hints != null && hints.containsKey("org.geotools.xml.filter.FILTER_COMPLIANCE_STRICTNESS")) {
                return new FilterEncodingPreProcessor((Integer)hints.get("org.geotools.xml.filter.FILTER_COMPLIANCE_STRICTNESS"));
            }
            return new FilterEncodingPreProcessor(XMLHandlerHints.VALUE_FILTER_COMPLIANCE_LOW);
        }
    }

    public static class LogicOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new LogicOpsType();

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return "LogicOpsType";
        }

        public Class getInstanceType() {
            return LogicFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3800000L) != 0x3800000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LogicFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LogicFilter lf = (LogicFilter)value;
            switch (lf.getFilterType()) {
                case 2: {
                    BinaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("And", BinaryLogicOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 1: {
                    BinaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("Or", BinaryLogicOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 3: {
                    UnaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("Not", UnaryLogicOpType.getInstance(), element), value, output, hints);
                    return;
                }
            }
            throw new OperationNotSupportedException("Unknown filter type in LogicFilter: " + lf.getClass().getName());
        }

        public boolean isAbstract() {
            return true;
        }
    }

    public static class SpatialOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new SpatialOpsType();

        public static short findFilterType(String s) {
            if ("BBOX".equalsIgnoreCase(s)) {
                return 4;
            }
            if ("Equals".equalsIgnoreCase(s)) {
                return 5;
            }
            if ("Disjoint".equalsIgnoreCase(s)) {
                return 6;
            }
            if ("Intersects".equalsIgnoreCase(s)) {
                return 7;
            }
            if ("Touches".equalsIgnoreCase(s)) {
                return 8;
            }
            if ("Crosses".equalsIgnoreCase(s)) {
                return 9;
            }
            if ("Within".equalsIgnoreCase(s)) {
                return 10;
            }
            if ("Contains".equalsIgnoreCase(s)) {
                return 11;
            }
            if ("Overlaps".equalsIgnoreCase(s)) {
                return 12;
            }
            if ("Beyond".equalsIgnoreCase(s)) {
                return 13;
            }
            if ("DWithin".equalsIgnoreCase(s)) {
                return 24;
            }
            return 0;
        }

        public static String writeFilterType(short filterType) {
            switch (filterType) {
                case 4: {
                    return "BBOX";
                }
                case 5: {
                    return "Equals";
                }
                case 6: {
                    return "Disjoint";
                }
                case 7: {
                    return "Intersects";
                }
                case 8: {
                    return "Touches";
                }
                case 9: {
                    return "Crosses";
                }
                case 10: {
                    return "Within";
                }
                case 11: {
                    return "Contains";
                }
                case 12: {
                    return "Overlaps";
                }
                case 13: {
                    return "Beyond";
                }
                case 24: {
                    return "DWithin";
                }
            }
            return "";
        }

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isAbstract() {
            return true;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            return null;
        }

        public String getName() {
            return "SpatialOpsType";
        }

        public Class getInstanceType() {
            return GeometryFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() == 0L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryFilter lf = (GeometryFilter)value;
            switch (lf.getFilterType()) {
                case 4: {
                    BBOXType.getInstance().encode(new FilterSchema.FilterElement("BBOX", BBOXType.getInstance(), element), value, output, hints);
                    return;
                }
                case 13: {
                    DistanceBufferType.getInstance().encode(new FilterSchema.FilterElement("Beyond", DistanceBufferType.getInstance(), element), value, output, hints);
                    return;
                }
                case 11: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Contains", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 9: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Crosses", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 6: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Disjoint", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 24: {
                    DistanceBufferType.getInstance().encode(new FilterSchema.FilterElement("DWithin", DistanceBufferType.getInstance(), element), value, output, hints);
                    return;
                }
                case 5: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Equals", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 7: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Intersects", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 12: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Overlaps", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 8: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Touches", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 10: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Within", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
            }
            throw new OperationNotSupportedException("Unknown filter type in ComparisonFilter: " + lf.getClass().getName());
        }
    }

    public static class ComparisonOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new ComparisonOpsType();

        public static short findFilterType(String s) {
            if ("PropertyIsEqualTo".equalsIgnoreCase(s)) {
                return 14;
            }
            if ("PropertyIsGreaterThan".equalsIgnoreCase(s)) {
                return 16;
            }
            if ("PropertyIsGreaterThanOrEqualTo".equalsIgnoreCase(s)) {
                return 18;
            }
            if ("PropertyIsLessThan".equalsIgnoreCase(s)) {
                return 15;
            }
            if ("PropertyIsLessThanOrEqualTo".equalsIgnoreCase(s)) {
                return 17;
            }
            if ("PropertyIsNotEqualTo".equalsIgnoreCase(s)) {
                return 23;
            }
            if ("PropertyIsLike".equalsIgnoreCase(s)) {
                return 20;
            }
            if ("PropertyIsNull".equalsIgnoreCase(s)) {
                return 21;
            }
            if ("PropertyIsBetween".equalsIgnoreCase(s)) {
                return 19;
            }
            return 0;
        }

        public static String writeFilterType(short filterType) {
            switch (filterType) {
                case 14: {
                    return "PropertyIsEqualTo";
                }
                case 16: {
                    return "PropertyIsGreaterThan";
                }
                case 18: {
                    return "PropertyIsGreaterThanOrEqualTo";
                }
                case 15: {
                    return "PropertyIsLessThan";
                }
                case 17: {
                    return "PropertyIsLessThanOrEqualTo";
                }
                case 23: {
                    return "PropertyIsNotEqualTo";
                }
                case 20: {
                    return "PropertyIsLike";
                }
                case 21: {
                    return "PropertyIsNull";
                }
                case 19: {
                    return "PropertyIsBetween";
                }
            }
            return "";
        }

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isAbstract() {
            return true;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                org.geotools.filter.Expression expr1 = (org.geotools.filter.Expression)value[0].getValue();
                org.geotools.filter.Expression expr2 = (org.geotools.filter.Expression)value[1].getValue();
                short type = ComparisonOpsType.findFilterType(element.getName());
                switch (type) {
                    case 14: {
                        return factory.equals((Expression)expr1, (Expression)expr2);
                    }
                    case 16: {
                        return factory.greater((Expression)expr1, (Expression)expr2);
                    }
                    case 18: {
                        return factory.greaterOrEqual((Expression)expr1, (Expression)expr2);
                    }
                    case 15: {
                        return factory.less((Expression)expr1, (Expression)expr2);
                    }
                    case 17: {
                        return factory.lessOrEqual((Expression)expr1, (Expression)expr2);
                    }
                    case 23: {
                        return factory.notEqual((Expression)expr1, (Expression)expr2);
                    }
                }
                throw new SAXException("Illegal filter for " + element);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "ComparisonOpsType";
        }

        public Class getInstanceType() {
            return CompareFilter.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3F0000L) != 0x3F0000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && (value instanceof CompareFilter || value instanceof BetweenFilter || value instanceof NullFilter || value instanceof LikeFilter);
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            org.geotools.filter.Filter lf = (org.geotools.filter.Filter)value;
            switch (lf.getFilterType()) {
                case 14: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 16: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsGreaterThan", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 18: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsGreaterThanOrEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 15: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLessThan", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 17: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLessThanOrEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 23: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsNotEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 20: {
                    PropertyIsLikeType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLike", PropertyIsLikeType.getInstance(), element), value, output, hints);
                    return;
                }
                case 21: {
                    PropertyIsNullType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsNull", PropertyIsNullType.getInstance(), element), value, output, hints);
                    return;
                }
                case 19: {
                    PropertyIsBetweenType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsBetween", PropertyIsBetweenType.getInstance(), element), value, output, hints);
                    return;
                }
            }
            throw new OperationNotSupportedException("Unknown filter type in ComparisonFilter: " + lf.getClass().getName());
        }
    }
}

