/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.measure.unit.SI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.GeocentricTranslation;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Transformation;

public class MolodenskiTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 7536566033885338422L;
    private static final float EPS = 1.0E-5f;
    private final boolean abridged;
    private final boolean source3D;
    private final boolean target3D;
    private final double dx;
    private final double dy;
    private final double dz;
    private final double a;
    private final double b;
    private final double da;
    private final double db;
    private final double df;
    private final double b_a;
    private final double a_b;
    private final double daa;
    private final double da_a;
    private final double e2;
    private final double adf;
    private transient MolodenskiTransform inverse;

    public MolodenskiTransform(boolean abridged, double a, double b, boolean source3D, double ta, double tb, boolean target3D, double dx, double dy, double dz) {
        this.abridged = abridged;
        this.source3D = source3D;
        this.target3D = target3D;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.a = a;
        this.b = b;
        this.da = ta - a;
        this.db = tb - b;
        this.a_b = a / b;
        this.b_a = b / a;
        this.daa = this.da * a;
        this.da_a = this.da / a;
        this.df = (ta - tb) / ta - (a - b) / a;
        this.e2 = 1.0 - b * b / (a * a);
        this.adf = a * this.df + (a - b) * this.da / a;
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.abridged ? ProviderAbridged.PARAMETERS : Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        Parameter<Integer> dim = new Parameter<Integer>(Provider.DIM);
        dim.setValue(this.getSourceDimensions());
        return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])new ParameterValue[]{dim, new FloatParameter(Provider.DX, this.dx), new FloatParameter(Provider.DY, this.dy), new FloatParameter(Provider.DZ, this.dz), new FloatParameter(Provider.SRC_SEMI_MAJOR, this.a), new FloatParameter(Provider.SRC_SEMI_MINOR, this.b), new FloatParameter(Provider.TGT_SEMI_MAJOR, this.a + this.da), new FloatParameter(Provider.TGT_SEMI_MINOR, this.b + this.db)});
    }

    public int getSourceDimensions() {
        return this.source3D ? 3 : 2;
    }

    public final int getTargetDimensions() {
        return this.target3D ? 3 : 2;
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.transform(null, srcPts, srcOff, null, dstPts, dstOff, numPts);
        assert (!this.target3D || srcPts == dstPts || !(this.maxError(null, srcPts, srcOff, null, dstPts, dstOff, numPts) > 1.0E-5f));
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        this.transform(srcPts, null, srcOff, dstPts, null, dstOff, numPts);
        assert (!this.target3D || srcPts == dstPts || !(this.maxError(srcPts, null, srcOff, dstPts, null, dstOff, numPts) > 1.0E-5f));
    }

    private void transform(float[] srcPts1, double[] srcPts2, int srcOff, float[] dstPts1, double[] dstPts2, int dstOff, int numPts) {
        int step = 0;
        if ((srcPts2 != null ? srcPts2 == dstPts2 : srcPts1 == dstPts1) && srcOff < dstOff && srcOff + numPts * this.getSourceDimensions() > dstOff) {
            if (this.source3D != this.target3D) {
                throw new UnsupportedOperationException("Not yet implemented.");
            }
            step = this.getSourceDimensions();
            srcOff += (numPts - 1) * step;
            dstOff += (numPts - 1) * step;
            step *= -2;
        }
        while (--numPts >= 0) {
            double z;
            double y;
            double x;
            if (srcPts2 != null) {
                x = srcPts2[srcOff++];
                y = srcPts2[srcOff++];
                z = this.source3D ? srcPts2[srcOff++] : 0.0;
            } else {
                x = srcPts1[srcOff++];
                y = srcPts1[srcOff++];
                z = this.source3D ? (double)srcPts1[srcOff++] : 0.0;
            }
            x = Math.toRadians(x);
            y = Math.toRadians(y);
            double sinX = Math.sin(x);
            double cosX = Math.cos(x);
            double sinY = Math.sin(y);
            double cosY = Math.cos(y);
            double sin2Y = sinY * sinY;
            double Rn = this.a / Math.sqrt(1.0 - this.e2 * sin2Y);
            double Rm = Rn * (1.0 - this.e2) / (1.0 - this.e2 * sin2Y);
            if (this.abridged) {
                y += (this.dz * cosY - sinY * (this.dy * sinX + this.dx * cosX) + this.adf * Math.sin(2.0 * y)) / Rm;
                x += (this.dy * cosX - this.dx * sinX) / (Rn * cosY);
            } else {
                y += (this.dz * cosY - sinY * (this.dy * sinX + this.dx * cosX) + this.da_a * (Rn * this.e2 * sinY * cosY) + this.df * (Rm * this.a_b + Rn * this.b_a) * sinY * cosY) / (Rm + z);
                x += (this.dy * cosX - this.dx * sinX) / ((Rn + z) * cosY);
            }
            if (Math.abs(y) > 1.5707963267948966) {
                if (dstPts2 != null) {
                    dstPts2[dstOff++] = 0.0;
                    dstPts2[dstOff++] = y > 0.0 ? 90.0 : -90.0;
                } else {
                    dstPts1[dstOff++] = 0.0f;
                    dstPts1[dstOff++] = y > 0.0 ? 90.0f : -90.0f;
                }
            } else {
                x = Math.toDegrees(MolodenskiTransform.rollLongitude(x));
                y = Math.toDegrees(y);
                if (dstPts2 != null) {
                    dstPts2[dstOff++] = x;
                    dstPts2[dstOff++] = y;
                } else {
                    dstPts1[dstOff++] = (float)x;
                    dstPts1[dstOff++] = (float)y;
                }
            }
            if (this.target3D) {
                z = this.abridged ? (z += this.dx * cosY * cosX + this.dy * cosY * sinX + this.dz * sinY + this.adf * sin2Y - this.da) : (z += this.dx * cosY * cosX + this.dy * cosY * sinX + this.dz * sinY + this.df * this.b_a * Rn * sin2Y - this.daa / Rn);
                if (dstPts2 != null) {
                    dstPts2[dstOff++] = z;
                } else {
                    dstPts1[dstOff++] = (float)z;
                }
            }
            srcOff += step;
            dstOff += step;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private float maxError(float[] srcPts1, double[] srcPts2, int srcOff, float[] dstPts1, double[] dstPts2, int dstOff, int numPts) {
        float max = 0.0f;
        if (this.inverse == null) {
            this.inverse();
            if (this.inverse == null) {
                return max;
            }
        }
        int sourceDim = this.getSourceDimensions();
        float[] tmp = new float[numPts * sourceDim];
        this.inverse.transform(dstPts1, dstPts2, dstOff, tmp, null, 0, numPts);
        int i = 0;
        while (true) {
            block9: {
                if (i >= tmp.length) {
                    return max;
                }
                float expected = srcPts2 != null ? (float)srcPts2[srcOff] : srcPts1[srcOff];
                float error = Math.abs(tmp[i] - expected);
                switch (i % sourceDim) {
                    case 0: {
                        error = (float)((double)error - 360.0 * Math.floor(error / 360.0f));
                        break;
                    }
                    case 2: {
                        break block9;
                    }
                }
                if (error > max) {
                    max = error;
                }
            }
            ++i;
            ++srcOff;
        }
    }

    public boolean isIdentity() {
        return this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0 && this.da == 0.0 && this.db == 0.0 && this.source3D == this.target3D;
    }

    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new MolodenskiTransform(this.abridged, this.a + this.da, this.b + this.db, this.target3D, this.a, this.b, this.source3D, -this.dx, -this.dy, -this.dz);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    public final int hashCode() {
        long code = Double.doubleToLongBits(this.dx) + 37L * (Double.doubleToLongBits(this.dy) + 37L * (Double.doubleToLongBits(this.dz) + 37L * (Double.doubleToLongBits(this.a) + 37L * (Double.doubleToLongBits(this.b) + 37L * (Double.doubleToLongBits(this.da) + 37L * Double.doubleToLongBits(this.db))))));
        int c = (int)code ^ (int)(code >>> 32) ^ 0x9C029B36;
        if (this.abridged) {
            c ^= 0xFFFFFFFF;
        }
        return c;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            MolodenskiTransform that = (MolodenskiTransform)object;
            return this.abridged == that.abridged && this.source3D == that.source3D && this.target3D == that.target3D && Double.doubleToLongBits(this.dx) == Double.doubleToLongBits(that.dx) && Double.doubleToLongBits(this.dy) == Double.doubleToLongBits(that.dy) && Double.doubleToLongBits(this.dz) == Double.doubleToLongBits(that.dz) && Double.doubleToLongBits(this.a) == Double.doubleToLongBits(that.a) && Double.doubleToLongBits(this.b) == Double.doubleToLongBits(that.b) && Double.doubleToLongBits(this.da) == Double.doubleToLongBits(that.da) && Double.doubleToLongBits(this.db) == Double.doubleToLongBits(that.db);
        }
        return false;
    }

    public static class ProviderAbridged
    extends Provider {
        private static final long serialVersionUID = 9148242601566635131L;
        static final ParameterDescriptorGroup PARAMETERS = ProviderAbridged.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Abridged_Molodenski"), new NamedIdentifier(Citations.EPSG, "Abridged Molodenski"), new NamedIdentifier(Citations.EPSG, "9605"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.format((int)1))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{DIM, DX, DY, DZ, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR});

        public ProviderAbridged() {
            super(2, 2, PARAMETERS);
        }

        private ProviderAbridged(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
            super(sourceDimensions, targetDimensions, parameters);
        }

        Provider create3D() {
            return new ProviderAbridged(3, 3, PARAMETERS);
        }

        boolean isAbridged() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -5332126871499059030L;
        static final int DEFAULT_DIMENSION = 2;
        public static final ParameterDescriptor<Integer> DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.OGC, "dim")), 2, 2, 3, false);
        public static final ParameterDescriptor<Integer> SRC_DIM = GeocentricTranslation.Provider.SRC_DIM;
        public static final ParameterDescriptor<Integer> TGT_DIM = GeocentricTranslation.Provider.TGT_DIM;
        public static final ParameterDescriptor<Double> DX = GeocentricTranslation.Provider.DX;
        public static final ParameterDescriptor<Double> DY = GeocentricTranslation.Provider.DY;
        public static final ParameterDescriptor<Double> DZ = GeocentricTranslation.Provider.DZ;
        public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.SRC_SEMI_MAJOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> SRC_SEMI_MINOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.SRC_SEMI_MINOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.TGT_SEMI_MAJOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> TGT_SEMI_MINOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.TGT_SEMI_MINOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Molodenski"), new NamedIdentifier(Citations.EPSG, "Molodenski"), new NamedIdentifier(Citations.EPSG, "9604"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)143))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{DIM, DX, DY, DZ, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR});
        private transient Provider withHeight;

        private static final NamedIdentifier[] identifiers(ParameterDescriptor parameter) {
            Collection id = parameter.getAlias();
            return id.toArray(new NamedIdentifier[id.size()]);
        }

        public Provider() {
            super(2, 2, PARAMETERS);
        }

        Provider(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
            super(sourceDimensions, targetDimensions, parameters);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            boolean hasHeight;
            int dim = Provider.intValue(DIM, values);
            switch (dim) {
                case 0: 
                case 2: {
                    hasHeight = false;
                    break;
                }
                case 3: {
                    hasHeight = true;
                    if (this.withHeight != null) break;
                    this.withHeight = this.create3D();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format((int)58, (Object)"dim", (Object)dim));
                }
            }
            double a = Provider.doubleValue(SRC_SEMI_MAJOR, values);
            double b = Provider.doubleValue(SRC_SEMI_MINOR, values);
            double ta = Provider.doubleValue(TGT_SEMI_MAJOR, values);
            double tb = Provider.doubleValue(TGT_SEMI_MINOR, values);
            double dx = Provider.doubleValue(DX, values);
            double dy = Provider.doubleValue(DY, values);
            double dz = Provider.doubleValue(DZ, values);
            boolean abridged = this.isAbridged();
            if (!hasHeight) {
                return new As2D(abridged, a, b, ta, tb, dx, dy, dz);
            }
            return new MathTransformProvider.Delegate(new MolodenskiTransform(abridged, a, b, hasHeight, ta, tb, hasHeight, dx, dy, dz), this.withHeight);
        }

        Provider create3D() {
            return new Provider(3, 3, PARAMETERS);
        }

        boolean isAbridged() {
            return false;
        }
    }

    private static final class As2D
    extends MolodenskiTransform
    implements MathTransform2D {
        private static final long serialVersionUID = 8098439371246167474L;

        public As2D(boolean abridged, double a, double b, double ta, double tb, double dx, double dy, double dz) {
            super(abridged, a, b, false, ta, tb, false, dx, dy, dz);
        }

        public MathTransform2D inverse() {
            if (((MolodenskiTransform)this).inverse == null) {
                ((MolodenskiTransform)this).inverse = (MolodenskiTransform)new As2D(((MolodenskiTransform)this).abridged, ((MolodenskiTransform)this).a + ((MolodenskiTransform)this).da, ((MolodenskiTransform)this).b + ((MolodenskiTransform)this).db, ((MolodenskiTransform)this).a, ((MolodenskiTransform)this).b, -((MolodenskiTransform)this).dx, -((MolodenskiTransform)this).dy, -((MolodenskiTransform)this).dz);
                ((MolodenskiTransform)this).inverse.inverse = (MolodenskiTransform)this;
            }
            return (MathTransform2D)((MolodenskiTransform)this).inverse;
        }
    }
}

