/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVAbstractLineProcessor;

public class CSVLineProcessorTimeSeries
extends CSVAbstractLineProcessor {
    private int indexTime = -1;
    private boolean toContinue = true;
    private File file = File.createTempFile("TimeSeries", "csv");

    public CSVLineProcessorTimeSeries(String separator) throws IOException {
        super(separator);
    }

    public boolean continueProcessing() {
        return this.toContinue;
    }

    private int getIndexTime() {
        if (this.indexTime != -1) {
            return this.indexTime;
        }
        int i = 0;
        for (String value : this.getColsName()) {
            System.out.println("field " + value);
            if (value.toLowerCase().equals("time")) {
                this.indexTime = i;
            }
            ++i;
        }
        return this.indexTime;
    }

    @Override
    public void processDataLine(int arg0, List<String> fields) {
        try {
            FileWriter fstream = new FileWriter(this.file, true);
            BufferedWriter out = new BufferedWriter(fstream);
            for (int i = 0; i < fields.size(); ++i) {
                String fieldValue = fields.get(i);
                if (this.separator.equals(",")) {
                    if (i == this.getIndexTime()) {
                        this.sqlTypes.add("timestamp without time zone");
                    } else {
                        String sqlType = this.getSQLType(fieldValue);
                        this.sqlTypes.add(sqlType);
                    }
                    if (i == this.getIndexTime()) {
                        Calendar calendar = DateGuesser.convertDate((String)fieldValue);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        String timeValue = sdf.format(calendar.getTime());
                        timeValue = i == fields.size() - 1 ? timeValue : timeValue + ",";
                        out.write(timeValue);
                        continue;
                    }
                    String cleanedValue = fieldValue.contains(",") ? "\"" + fieldValue + "\"" : fieldValue;
                    cleanedValue = i == fields.size() - 1 ? cleanedValue : cleanedValue + ",";
                    out.write(cleanedValue);
                    continue;
                }
                int j = 0;
                for (String value : fieldValue.split(this.separator)) {
                    if (j == this.getIndexTime()) {
                        this.sqlTypes.add("timestamp without time zone");
                    } else {
                        String sqlType = this.getSQLType(value);
                        this.sqlTypes.add(sqlType);
                        ++j;
                    }
                    out.write(fieldValue + ",");
                }
            }
            out.write("\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getSQLType(String value) {
        String sqlType = null;
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        String className = DataTypeRecognizer.guessType(values);
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    public boolean isTimeFound() {
        return this.indexTime != -1;
    }

    public File getFile() {
        return this.file;
    }
}

