package org.gcube.data.analysis.statisticalmanager.experimentspace.genericresources;

import static org.gcube.resources.discovery.icclient.ICFactory.client;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.Type;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;

public class GenericRGenerator {
	public static final String SECONDARY_TYPE = "StatisticalManagerAlgorithm";
	private static int call = 0;
	private static Lock l = new ReentrantLock();;
	// protected GCUBEScope scope= GCUBEScope.getScope("/gcube/devsec");
	// GCUBEScope scope = ServiceContext.getContext().getScope();

	GCUBELog logger = new GCUBELog(ComputationFactory.class);
	public static int consecutiveCall = 0;
	private static ArrayList<String> algoritmJustPublish = new ArrayList<String>();

	public GenericRGenerator() {

	}

	protected StringBuilder createGR(SMAlgorithm a, String name,
			String description, List<StatisticalType> parameters)
			throws Exception {
		// logger.debug("inside create GR");
		StringBuilder xml = new StringBuilder();
		ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
		xml.append("<Resource version=\"0.4.x\">");
		xml.append("<Type>GenericResource</Type>");
		xml.append("<Profile>");
		xml.append("<SecondaryType>");
		xml.append(SECONDARY_TYPE);
		xml.append("</SecondaryType>");
		xml.append("<Name>");
		xml.append(name);
		xml.append("</Name>");
		xml.append("<Description>");
		xml.append(description);
		xml.append("</Description>");
		xml.append("<Body>");
		xml.append("<category>");
		xml.append(a.getCategory());
		xml.append("</category>");
		for (StatisticalType param : parameters) {
			SMParameter smParameter = FactoryComputationParameter
					.createParameter(param);
			if (smParameter != null)
				listParameters.add(smParameter);
		}

		SMParameters smParameters= new SMParameters(
				listParameters.toArray(new SMParameter[listParameters.size()]));
		xml.append("<inputs>");
		for (SMParameter smParam : smParameters.getList()) {
			
				xml.append("<input>" + "<name>" + smParam.getName() + "</name>"
						+ "<description>" + smParam.getDescription()
						+ "</description>" + "<defaultValue>" + smParam.getDefaultValue()
						+ "</defaultValue>" +"<type>" + smParam.getType().getName()
						+ "</type>"+
						"</input>");
//			
		}
//		if (parameters.size() != 0) {
//			xml.append("<inputs>");
//			for (StatisticalType p : parameters)
//				xml.append("<input>" + "<name>" + p.getName() + "</name>"
//						+ "<description>" + p.getDescription()
//						+ "</description>" + "</input>");
//
//		}

		xml.append("</inputs>");
		xml.append("</Body>");
		xml.append("</Profile>");
		xml.append("</Resource>");
		// logger.debug("return xml");
		return xml;

	}

	// protected void createGRs(
	// HashMap<SMAlgorithm, List<StatisticalType>> algorithms)
	// throws Exception {
	//
	// HashMap<SMAlgorithm, StringBuilder> results = new HashMap<SMAlgorithm,
	// StringBuilder>();
	// for (Entry<SMAlgorithm, List<StatisticalType>> alg :
	// algorithms.entrySet()) {
	// StringBuilder xml = new StringBuilder();
	// List<StatisticalType> parameters = alg.getValue();
	// SMAlgorithm a = alg.getKey();
	// xml.append("<category>");
	// xml.append(a.getCategory());
	// xml.append("</category>");
	//
	// if (parameters.size() != 0) {
	// xml.append("<inputs>");
	// for (StatisticalType p : parameters)
	// xml.append("<input>" + "<name>" + p.getName() + "</name>"
	// + "<description>" + p.getDescription()
	// + "</description>" + "</input>");
	// }
	//
	// xml.append("</inputs>");
	//
	// results.put(a, xml);
	// // publishGR(xml, a.getName(),a.getDescription());
	// // publishGR(results);
	//
	// }
	// publishGR(results);
	//
	// }

	/*
	 * Return all generic resources with Secondary Type equal to
	 * "StatisticalManagerAlgorithm"
	 */
	public List<String> getGenericResources() throws Exception {

		List<String> algNames = new ArrayList<String>();
		for (GCUBEScope s : ServiceContext.getContext().getStartScopes()) {
			ScopeProvider.instance.set(s.toString());
			String queryString = "for $resource in collection('/db/Profiles/GenericResource')"
					+ "//Resource where ($resource/Profile/SecondaryType eq '"
					+ SECONDARY_TYPE
					+ "')"
					+ " and ($resource/Scopes/Scope eq '"
					+ s.toString()
					+ "') return $resource/Profile/Name/text()";
			logger.debug(queryString);
			Query q = new QueryBox(queryString);

			DiscoveryClient<String> client = client();
			algNames.addAll(client.submit(q));
		}
		algoritmJustPublish = new ArrayList<String>();
		algoritmJustPublish.addAll(algNames);
		int size = algNames.size();
		logger.debug("Size gr found :" + size);
		return algNames;
	}

	public boolean isPublished(String name) throws Exception {

		List<String> algNames = new ArrayList<String>();
		for (GCUBEScope s : ServiceContext.getContext().getStartScopes()) {
			ScopeProvider.instance.set(s.toString());
			String queryString = "for $resource in collection('/db/Profiles/GenericResource')"
					+ "//Resource where (resource/Profile/Name/text() eq '"
					+ name
					+ "')"
					+ " and ($resource/Scopes/Scope eq '"
					+ s.toString() + "') return $resource/Profile/Name/text()";
//			logger.debug(queryString);
			Query q = new QueryBox(queryString);

			DiscoveryClient<String> client = client();
			if (client.submit(q).size() > 0)
				return true;

		}
		return false;
	}

	/*
	 * If exist return Resource having name equal name otherwise throw excpetion
	 */
	public boolean existGR(List<String> listExistAlg, String name)
			throws Exception {
		for (String algName : listExistAlg) {

			if (name.equals(algName))
				return true;

		}
		return false;
		// return listExistAlg.contains(name);

	}

	public void publishGRNew(
			HashMap<SMAlgorithm, List<StatisticalType>> algorithms)
			throws Exception {
		consecutiveCall++;
		

		List<String> listExistAlg = new ArrayList<String>();
		listExistAlg = getGenericResources();
		// this hash in needed because are returned same algorithms more times
		HashMap<String, String> algJustPublish = new HashMap<String, String>();
		if(consecutiveCall==1)
		{
		for (Entry<SMAlgorithm, List<StatisticalType>> alg : algorithms
				.entrySet()) {
			List<StatisticalType> parameters = alg.getValue();
			SMAlgorithm a = alg.getKey();
			String name = alg.getKey().getName();
			logger.debug("Algorithm :" + name);
			//if (algJustPublish.containsKey(name) == false) {
			//isPublished(name)==false && 
			
				algJustPublish.put(name, name);
				String description = alg.getKey().getDescription();
				GenericResource resource;

				if (!existGR(listExistAlg, name)) {
					 logger.debug("Create resource." + name);

					StringBuilder xml = createGR(a, name, description,
							parameters);

					String xmlResource = xml.toString();
					StringReader reader = new StringReader(xmlResource);

					resource = (GenericResource) Resources.unmarshal(
							GenericResource.class, reader);
					List<String> scopes = new ArrayList<String>();
					
					for (GCUBEScope s : ServiceContext.getContext()
							.getStartScopes()) {
						Type type = s.getType();
						String scope = s.toString();
						if (type == Type.VO)
							scopes.add(scope);
//						logger.debug("Add scope :" + scope);

					}
//					logger.debug("Consecutive call number" + consecutiveCall);

					logger.debug("Publish");
					ScopedPublisher sp = RegistryPublisherFactory
							.scopedPublisher();
					Resource r = sp.create(resource, scopes);

				}

			}

		}
		if(consecutiveCall>=3)
			consecutiveCall=0;

	}
}

//
// StringWriter sw = new StringWriter();
// PrintWriter pw = new PrintWriter(sw);
// exe.printStackTrace(pw);
//
// logger.debug(sw.toString());

